/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.schematic.getters;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import me.eccentric_nz.TARDIS.schematic.getters.ItemStackGetter;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class ArmourStandGetter {
    public static JsonObject getJson(ArmorStand stand, int minx, int miny, int minz) {
        ItemStack boots;
        ItemStack leggings;
        ItemStack chestplate;
        Location location = stand.getLocation();
        JsonObject object = new JsonObject();
        JsonObject loc = new JsonObject();
        loc.addProperty("x", (Number)(location.getX() - (double)minx));
        loc.addProperty("y", (Number)(location.getY() - (double)miny));
        loc.addProperty("z", (Number)(location.getZ() - (double)minz));
        object.add("rel_location", (JsonElement)loc);
        object.addProperty("facing", stand.getFacing().toString());
        object.addProperty("invisible", Boolean.valueOf(stand.isVisible()));
        object.addProperty("gravity", Boolean.valueOf(stand.hasGravity()));
        object.addProperty("body_yaw", (Number)Float.valueOf(stand.getBodyYaw()));
        object.addProperty("yaw", (Number)Float.valueOf(stand.getYaw()));
        JsonArray rotations = new JsonArray();
        JsonArray headRotations = new JsonArray();
        headRotations.add((Number)stand.getHeadRotations().x());
        headRotations.add((Number)stand.getHeadRotations().y());
        headRotations.add((Number)stand.getHeadRotations().z());
        rotations.add((JsonElement)headRotations);
        JsonArray bodyRotations = new JsonArray();
        bodyRotations.add((Number)stand.getBodyRotations().x());
        bodyRotations.add((Number)stand.getBodyRotations().y());
        bodyRotations.add((Number)stand.getBodyRotations().z());
        rotations.add((JsonElement)bodyRotations);
        JsonArray leftArmRotations = new JsonArray();
        leftArmRotations.add((Number)stand.getLeftArmRotations().x());
        leftArmRotations.add((Number)stand.getLeftArmRotations().y());
        leftArmRotations.add((Number)stand.getLeftArmRotations().z());
        rotations.add((JsonElement)leftArmRotations);
        JsonArray rightArmRotations = new JsonArray();
        rightArmRotations.add((Number)stand.getRightArmRotations().x());
        rightArmRotations.add((Number)stand.getRightArmRotations().y());
        rightArmRotations.add((Number)stand.getRightArmRotations().z());
        rotations.add((JsonElement)rightArmRotations);
        JsonArray leftLegRotations = new JsonArray();
        leftLegRotations.add((Number)stand.getLeftLegRotations().x());
        leftLegRotations.add((Number)stand.getLeftLegRotations().y());
        leftLegRotations.add((Number)stand.getLeftLegRotations().z());
        rotations.add((JsonElement)leftLegRotations);
        JsonArray rightLegRotations = new JsonArray();
        rightLegRotations.add((Number)stand.getRightLegRotations().x());
        rightLegRotations.add((Number)stand.getRightLegRotations().y());
        rightLegRotations.add((Number)stand.getRightLegRotations().z());
        rotations.add((JsonElement)rightLegRotations);
        object.add("rotations", (JsonElement)rotations);
        EntityEquipment equipment = stand.getEquipment();
        ItemStack helmet = equipment.getHelmet();
        if (helmet != null) {
            JsonObject head = new JsonObject();
            if (helmet.hasItemMeta()) {
                ItemMeta im = helmet.getItemMeta();
                if (im.hasItemModel()) {
                    head.addProperty("model", im.getItemModel().toString());
                }
                if (im instanceof SkullMeta) {
                    SkullMeta skullMeta = (SkullMeta)im;
                    skullMeta.getPlayerProfile().getProperties().stream().findFirst().ifPresent(property -> head.addProperty("skull", property.getValue()));
                }
            }
            head.addProperty("material", helmet.getType().toString());
            object.add("head", (JsonElement)head);
        }
        if ((chestplate = equipment.getChestplate()) != null) {
            object.add("chest", (JsonElement)ItemStackGetter.getJson(chestplate));
        }
        if ((leggings = equipment.getLeggings()) != null) {
            object.add("leggings", (JsonElement)ItemStackGetter.getJson(leggings));
        }
        if ((boots = equipment.getBoots()) != null) {
            object.add("boots", (JsonElement)ItemStackGetter.getJson(boots));
        }
        ItemStack mainhand = equipment.getItemInMainHand();
        object.add("mainhand", (JsonElement)ItemStackGetter.getJson(mainhand));
        ItemStack offhand = equipment.getItemInOffHand();
        object.add("offhand", (JsonElement)ItemStackGetter.getJson(offhand));
        return object;
    }
}

