/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.schematic.actions;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.schematic.setters.ArmourStandSetter;
import me.eccentric_nz.TARDIS.schematic.setters.BannerSetter;
import me.eccentric_nz.TARDIS.schematic.setters.HeadSetter;
import me.eccentric_nz.TARDIS.schematic.setters.ItemDisplaySetter;
import me.eccentric_nz.TARDIS.schematic.setters.ItemFrameSetter;
import me.eccentric_nz.TARDIS.schematic.setters.MannequinSetter;
import me.eccentric_nz.TARDIS.schematic.setters.PaintingSetter;
import me.eccentric_nz.TARDIS.schematic.setters.PotSetter;
import me.eccentric_nz.TARDIS.schematic.setters.SIDRATFenceSetter;
import me.eccentric_nz.TARDIS.schematic.setters.ShelfSetter;
import me.eccentric_nz.TARDIS.schematic.setters.SignSetter;
import me.eccentric_nz.TARDIS.utility.TARDISBannerData;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class SchematicPaster
implements Runnable {
    private final TARDIS plugin;
    private final Player player;
    private final boolean air;
    private final HashMap<Block, BlockData> postRedstoneTorches = new HashMap();
    private final HashMap<Block, BlockData> postRedstoneDust = new HashMap();
    private final HashMap<Block, BlockData> postPistons = new HashMap();
    private final HashMap<Block, TARDISBannerData> postBanners = new HashMap();
    private final HashMap<Block, BlockData> sidratFenceBlocks = new HashMap();
    private int task;
    private int l;
    private int r;
    private int h;
    private int w;
    private int d;
    private int x;
    private int y;
    private int z;
    private int counter = 0;
    private double div = 1.0;
    private World world;
    private JsonObject obj;
    private JsonArray arr;
    private boolean running = false;
    private BossBar bb;

    public SchematicPaster(TARDIS plugin, Player player, boolean air) {
        this.plugin = plugin;
        this.player = player;
        this.air = air;
        this.l = 0;
        this.r = 0;
    }

    @Override
    public void run() {
        if (!this.running) {
            Iterator<Map.Entry<Block, BlockData>> uuid = this.player.getUniqueId();
            if (!this.plugin.getTrackerKeeper().getPastes().containsKey(uuid)) {
                this.plugin.getMessenger().message((CommandSender)this.player, TardisModule.TARDIS, "No schematic loaded! /ts load [console|room|structure|user] [name]");
                this.plugin.getServer().getScheduler().cancelTask(this.task);
                this.task = -1;
                return;
            }
            this.obj = this.plugin.getTrackerKeeper().getPastes().get(uuid);
            JsonObject dimensions = this.obj.get("dimensions").getAsJsonObject();
            this.h = dimensions.get("height").getAsInt() - 1;
            this.w = dimensions.get("width").getAsInt();
            this.d = dimensions.get("length").getAsInt() - 1;
            this.div = ((double)this.h + 1.0) * (double)this.w * ((double)this.d + 1.0);
            JsonObject r = this.obj.get("relative").getAsJsonObject();
            int rx = r.get("x").getAsInt();
            int ry = r.get("y").getAsInt();
            int rz = r.get("z").getAsInt();
            this.x = this.player.getLocation().getBlockX() - rx;
            this.y = this.player.getLocation().getBlockY() - ry;
            this.z = this.player.getLocation().getBlockZ() - rz;
            this.world = this.player.getWorld();
            this.arr = this.obj.get("input").getAsJsonArray();
            this.bb = Bukkit.createBossBar((String)"TARDIS Schematic Paste Progress", (BarColor)BarColor.WHITE, (BarStyle)BarStyle.SOLID, (BarFlag[])TARDISConstants.EMPTY_ARRAY);
            this.bb.setProgress(0.0);
            this.bb.addPlayer(this.player);
            this.bb.setVisible(true);
            this.running = true;
        }
        if (this.l == this.h && this.r == this.w - 1) {
            for (Map.Entry<Block, BlockData> map : this.postRedstoneTorches.entrySet()) {
                ((Block)map.getKey()).setBlockData((BlockData)map.getValue());
                if (!TARDIS.plugin.getBlockLogger().isLogging()) continue;
                TARDIS.plugin.getBlockLogger().logPlacement(map.getKey());
            }
            for (Map.Entry<Block, BlockData> map : this.postRedstoneDust.entrySet()) {
                map.getKey().setBlockData(map.getValue());
                if (!TARDIS.plugin.getBlockLogger().isLogging()) continue;
                TARDIS.plugin.getBlockLogger().logPlacement(map.getKey());
            }
            for (Map.Entry<Block, BlockData> map : this.postPistons.entrySet()) {
                map.getKey().setBlockData(map.getValue());
                if (!TARDIS.plugin.getBlockLogger().isLogging()) continue;
                TARDIS.plugin.getBlockLogger().logPlacement(map.getKey());
            }
            BannerSetter.setBanners(this.postBanners);
            SIDRATFenceSetter.update(this.sidratFenceBlocks);
            if (this.obj.has("mannequins")) {
                JsonArray mannequins = this.obj.get("mannequins").getAsJsonArray();
                MannequinSetter.setMannequins(mannequins, this.world, this.x, this.y, this.z);
            }
            if (this.obj.has("armour_stands")) {
                JsonArray stands = this.obj.get("armour_stands").getAsJsonArray();
                ArmourStandSetter.setStands(stands, this.world, this.x, this.y, this.z);
            }
            if (this.obj.has("paintings")) {
                JsonArray paintings = (JsonArray)this.obj.get("paintings");
                PaintingSetter.setArt(paintings, this.world, this.x, this.y, this.z);
            }
            Location start = new Location(this.world, (double)this.x, (double)this.y, (double)this.z);
            if (this.obj.has("item_frames")) {
                JsonArray frames = this.obj.get("item_frames").getAsJsonArray();
                ItemFrameSetter.curate(frames, start, -1);
            }
            if (this.obj.has("item_displays")) {
                JsonArray displays = this.obj.get("item_displays").getAsJsonArray();
                for (int i = 0; i < displays.size(); ++i) {
                    ItemDisplaySetter.fakeBlock(displays.get(i).getAsJsonObject(), start, -1);
                }
            }
            this.plugin.getServer().getScheduler().cancelTask(this.task);
            this.task = -1;
            this.bb.setProgress(1.0);
            this.bb.setVisible(false);
            this.bb.removeAll();
        }
        JsonArray level = (JsonArray)this.arr.get(this.l);
        JsonArray row = (JsonArray)level.get(this.r);
        for (int c = 0; c <= this.d; ++c) {
            ++this.counter;
            JsonObject col = row.get(c).getAsJsonObject();
            BlockData data = this.plugin.getServer().createBlockData(col.get("data").getAsString());
            Block block = this.world.getBlockAt(this.x + this.r, this.y + this.l, this.z + c);
            if (!block.getType().isAir() && this.plugin.getBlockLogger().isLogging()) {
                this.plugin.getBlockLogger().logRemoval(block);
            }
            switch (data.getMaterial()) {
                case AIR: 
                case CAVE_AIR: 
                case VOID_AIR: {
                    if (!this.air) break;
                    block.setBlockData(data, true);
                    break;
                }
                case REDSTONE_TORCH: {
                    this.postRedstoneTorches.put(block, data);
                    break;
                }
                case REDSTONE: {
                    this.postRedstoneDust.put(block, data);
                    break;
                }
                case STICKY_PISTON: {
                    this.postPistons.put(block, data);
                    break;
                }
                case PLAYER_HEAD: 
                case PLAYER_WALL_HEAD: {
                    UUID uuid;
                    JsonObject head;
                    block.setBlockData(data, true);
                    JsonObject jsonObject = head = col.has("head") ? col.get("head").getAsJsonObject() : null;
                    if (head == null || !head.has("uuid") || (uuid = UUID.fromString(head.get("uuid").getAsString())) == null) break;
                    HeadSetter.textureSkull(this.plugin, uuid, head, block);
                    break;
                }
                case DECORATED_POT: {
                    block.setBlockData(data, true);
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                        if (col.has("pot")) {
                            JsonObject pot = col.get("pot").getAsJsonObject();
                            PotSetter.decorate(this.plugin, pot, block);
                        }
                    }, 1L);
                    break;
                }
                case OAK_SHELF: 
                case SPRUCE_SHELF: 
                case BIRCH_SHELF: 
                case JUNGLE_SHELF: 
                case ACACIA_SHELF: 
                case DARK_OAK_SHELF: 
                case MANGROVE_SHELF: 
                case CHERRY_SHELF: 
                case PALE_OAK_SHELF: 
                case BAMBOO_SHELF: 
                case CRIMSON_SHELF: 
                case WARPED_SHELF: {
                    block.setBlockData(data, true);
                    if (this.plugin.getBlockLogger().isLogging()) {
                        this.plugin.getBlockLogger().logPlacement(block);
                    }
                    if (!col.has("items")) break;
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> ShelfSetter.stock(block, col.get("items").getAsJsonArray()), 3L);
                    break;
                }
                case PALE_OAK_FENCE: {
                    block.setBlockData(data, false);
                    this.sidratFenceBlocks.put(block, data);
                    break;
                }
                default: {
                    if (Tag.BANNERS.isTagged((Keyed)data.getMaterial())) {
                        JsonObject state;
                        JsonObject jsonObject = state = col.has("banner") ? col.get("banner").getAsJsonObject() : null;
                        if (state == null) break;
                        TARDISBannerData tbd = new TARDISBannerData(data, state);
                        this.postBanners.put(block, tbd);
                        break;
                    }
                    if (Tag.ALL_SIGNS.isTagged((Keyed)data.getMaterial())) {
                        JsonObject state;
                        JsonObject jsonObject = state = col.has("sign") ? col.get("sign").getAsJsonObject() : null;
                        if (state == null) break;
                        block.setBlockData(data, true);
                        SignSetter.setSign(block, state, null, 0);
                        break;
                    }
                    block.setBlockData(data, true);
                    if (!this.plugin.getBlockLogger().isLogging()) break;
                    this.plugin.getBlockLogger().logPlacement(block);
                }
            }
            double progress = (double)this.counter / this.div;
            this.bb.setProgress(progress);
            if (c == this.d && this.r < this.w) {
                ++this.r;
            }
            if (c != this.d || this.r != this.w || this.l >= this.h) continue;
            this.r = 0;
            ++this.l;
        }
    }

    public void setTask(int task) {
        this.task = task;
    }
}

