/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.schematic;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import me.eccentric_nz.TARDIS.TARDIS;

public class SchematicGZip {
    public static void zip(String instr, String outstr) {
        try {
            int len;
            FileInputStream fis = new FileInputStream(instr);
            FileOutputStream fos = new FileOutputStream(outstr);
            GZIPOutputStream gzos = new GZIPOutputStream(fos);
            byte[] buffer = new byte[16384];
            while ((len = fis.read(buffer)) != -1) {
                gzos.write(buffer, 0, len);
            }
            gzos.close();
            fos.close();
            fis.close();
        }
        catch (IOException e) {
            TARDIS.plugin.debug("Could not GZip schematic file!" + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsonObject unzip(String instr) {
        InputStreamReader isr = null;
        StringWriter sw = null;
        String s = "";
        try {
            int len;
            GZIPInputStream gzis = new GZIPInputStream(new FileInputStream(instr));
            isr = new InputStreamReader((InputStream)gzis, StandardCharsets.UTF_8);
            sw = new StringWriter();
            char[] buffer = new char[16384];
            while ((len = isr.read(buffer)) > 0) {
                sw.write(buffer, 0, len);
            }
            s = sw.toString();
        }
        catch (IOException ex) {
            TARDIS.plugin.debug("Could not read GZip schematic file! " + ex.getMessage());
        }
        finally {
            try {
                if (sw != null) {
                    sw.close();
                }
                if (isr != null) {
                    isr.close();
                }
            }
            catch (IOException ex) {
                TARDIS.plugin.debug("Could not close GZip schematic file! " + ex.getMessage());
            }
        }
        return s.startsWith("{") ? JsonParser.parseString((String)s).getAsJsonObject() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsonObject unzip(InputStream stream) {
        InputStreamReader isr = null;
        StringWriter sw = null;
        String s = "";
        try {
            int len;
            GZIPInputStream gzis = new GZIPInputStream(stream);
            isr = new InputStreamReader((InputStream)gzis, StandardCharsets.UTF_8);
            sw = new StringWriter();
            char[] buffer = new char[16384];
            while ((len = isr.read(buffer)) > 0) {
                sw.write(buffer, 0, len);
            }
            s = sw.toString();
        }
        catch (IOException ex) {
            TARDIS.plugin.debug("Could not read GZip schematic file! " + ex.getMessage());
        }
        finally {
            try {
                if (sw != null) {
                    sw.close();
                }
                if (isr != null) {
                    isr.close();
                }
            }
            catch (IOException ex) {
                TARDIS.plugin.debug("Could not close GZip schematic file! " + ex.getMessage());
            }
        }
        return s.startsWith("{") ? JsonParser.parseString((String)s).getAsJsonObject() : null;
    }

    public static JsonObject getObject(TARDIS plugin, String folder, String which, boolean user) {
        JsonObject obj = null;
        if (user) {
            String path = String.valueOf(plugin.getDataFolder()) + File.separator + "user_schematics" + File.separator + which + ".tschm";
            File file = new File(path);
            if (!file.exists()) {
                plugin.debug("Could not find a schematic with that name!");
                return null;
            }
            obj = SchematicGZip.unzip(path);
        } else {
            String path = folder + "/" + which + ".tschm";
            InputStream stream = plugin.getResource(path);
            if (stream != null) {
                obj = SchematicGZip.unzip(stream);
            }
        }
        return obj;
    }
}

