/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.rooms.games.tetris;

public enum Pieces {
    I(new byte[][]{{0, 0, 0, 0}, {0, 0, 0, 0}, {1, 1, 1, 1}, {0, 0, 0, 0}}, new byte[][]{{0, 0, 1, 0}, {0, 0, 1, 0}, {0, 0, 1, 0}, {0, 0, 1, 0}}),
    J(new byte[][]{{0, 0, 0}, {3, 3, 3}, {0, 0, 3}}, new byte[][]{{0, 3, 0}, {0, 3, 0}, {3, 3, 0}}, new byte[][]{{3, 0, 0}, {3, 3, 3}, {0, 0, 0}}, new byte[][]{{0, 3, 3}, {0, 3, 0}, {0, 3, 0}}),
    L(new byte[][]{{0, 0, 0}, {2, 2, 2}, {2, 0, 0}}, new byte[][]{{2, 2, 0}, {0, 2, 0}, {0, 2, 0}}, new byte[][]{{0, 0, 2}, {2, 2, 2}, {0, 0, 0}}, new byte[][]{{0, 2, 0}, {0, 2, 0}, {0, 2, 2}}),
    O(new byte[][][]{new byte[][]{{1, 1}, {1, 1}}}),
    S(new byte[][]{{0, 0, 0}, {0, 3, 3}, {3, 3, 0}}, new byte[][]{{0, 3, 0}, {0, 3, 3}, {0, 0, 3}}),
    T(new byte[][]{{0, 0, 0}, {1, 1, 1}, {0, 1, 0}}, new byte[][]{{0, 1, 0}, {1, 1, 0}, {0, 1, 0}}, new byte[][]{{0, 1, 0}, {1, 1, 1}, {0, 0, 0}}, new byte[][]{{0, 1, 0}, {0, 1, 1}, {0, 1, 0}}),
    Z(new byte[][]{{0, 0, 0}, {2, 2, 0}, {0, 2, 2}}, new byte[][]{{0, 0, 2}, {0, 2, 2}, {0, 2, 0}});

    private final byte[][][] shapes;
    private final int startX;
    private final int startY;
    private int x;
    private int y;
    private byte rotation;

    private Pieces(byte[][] ... shapes) {
        this.shapes = shapes;
        this.startX = -shapes[0][0].length / 2;
        for (int i = 0; i < shapes[0].length; ++i) {
            for (byte b : shapes[0][i]) {
                if (b == 0) continue;
                this.startY = -i;
                this.x = this.startX;
                this.y = this.startY;
                return;
            }
        }
        this.startY = 0;
    }

    public byte[][] getShape() {
        return this.shapes[this.rotation];
    }

    public int getXOffset() {
        return this.x;
    }

    public int getYOffset() {
        return this.y;
    }

    public void rotateClockwise() {
        this.rotation = (byte)((this.rotation + 1) % this.shapes.length);
    }

    public void rotateCounterClockwise() {
        this.rotation = (byte)((this.rotation + 3) % this.shapes.length);
    }

    void move(int dx, int dy) {
        this.x += dx;
        this.y += dy;
    }

    public void reset() {
        this.x = this.startX;
        this.y = this.startY;
        this.rotation = 0;
    }
}

