/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.rooms.architectural.tree;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import me.eccentric_nz.TARDIS.rooms.architectural.tree.Branch;
import me.eccentric_nz.TARDIS.rooms.architectural.tree.Fractal;
import me.eccentric_nz.TARDIS.rooms.architectural.tree.Tree;
import me.eccentric_nz.TARDIS.rooms.architectural.tree.TreeVector;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Lantern;

public class TreeBuilder {
    private final ArrayList<Block> blocks = new ArrayList();
    private int width;
    private int height;
    private int leafDensity;
    private int branchMinLength;
    private int branchMaxLength;
    private int stemLength;
    private int growIterations;
    private int leafPerBranch;
    private int branchThickness;
    private List<Material> branchMaterial;
    private List<Material> leafMaterial;

    public void place(Block block) {
        block.getWorld().spawnParticle(Particle.FIREWORK, block.getLocation(), 3);
        this.setTreeProperties();
        this.growFractalTree(block);
    }

    private void setTreeProperties() {
        this.width = 13;
        this.height = 11;
        this.leafDensity = 50;
        this.branchMinLength = 3;
        this.branchMaxLength = 5;
        this.stemLength = 4;
        this.growIterations = 25;
        this.branchMaterial = List.of(Material.GRAY_WOOL);
        this.leafMaterial = List.of(Material.IRON_CHAIN);
        this.leafPerBranch = 1;
        this.branchThickness = 1;
    }

    private void growFractalTree(Block block) {
        Tree tree = new Tree(this.width, this.height, this.leafDensity, this.branchMinLength, this.branchMaxLength, this.stemLength, this.branchThickness);
        tree.createTree();
        for (int i = 0; i < this.growIterations; ++i) {
            tree.grow();
        }
        tree.leaves.clear();
        this.renderTree(tree, block);
        this.generateLeaves(block);
        this.generateRoots(block);
    }

    private void renderTree(Tree tree, Block block) {
        for (Branch branch : tree.branches) {
            if (branch.getParent() == null) continue;
            List<TreeVector> line = Fractal.line(branch.getPosition(), branch.getParent().getPosition());
            for (TreeVector loc : line) {
                Block b = block.getWorld().getBlockAt((int)loc.x() + block.getX(), (int)loc.y() + block.getY() + 1, (int)loc.z() + block.getZ());
                Random r = new Random();
                int low = 1;
                int high = this.branchMaterial.size() + 1;
                int result = r.nextInt(high - low) + low;
                if (!b.getType().isAir()) continue;
                b.setType(this.branchMaterial.get(result - 1));
                this.blocks.add(b);
            }
        }
    }

    private void generateLeaves(Block block) {
        for (Block branch : this.blocks) {
            if (branch.getY() <= block.getY() + this.stemLength / 5 * 3) continue;
            for (int i = 0; i < this.leafPerBranch; ++i) {
                int x = branch.getX() - 1 + (int)(Math.random() * 3.0);
                int y = branch.getY() - 1 + (int)(Math.random() * 3.0);
                int z = branch.getZ() - 1 + (int)(Math.random() * 3.0);
                Block b = block.getWorld().getBlockAt(x, y, z);
                if (this.branchMaterial.contains(b.getType()) || !b.getType().isAir()) continue;
                Random r = new Random();
                int low = 1;
                int high = this.leafMaterial.size() + 1;
                int result = r.nextInt(high - low) + low;
                Material material = this.leafMaterial.get(result - 1);
                b.setType(material);
                BlockData lantern = this.getSoulLantern();
                Block down = b.getRelative(BlockFace.DOWN);
                if (!down.getType().isAir()) continue;
                down.setBlockData(lantern);
            }
        }
    }

    private BlockData getSoulLantern() {
        Lantern lantern = (Lantern)Material.SOUL_LANTERN.createBlockData();
        lantern.setHanging(true);
        return lantern;
    }

    private void generateRoots(Block block) {
        Random rand = new Random();
        rand.setSeed(System.currentTimeMillis());
        for (int i = 0; i < 3; ++i) {
            int x = -1 + (int)(Math.random() * 3.0);
            int y = -rand.nextInt(3) + 1;
            int z = -1 + (int)(Math.random() * 3.0);
            List<TreeVector> line = Fractal.line(new TreeVector(x, y, z), new TreeVector(0.0, 0.0, 0.0));
            for (TreeVector loc : line) {
                Block b = block.getWorld().getBlockAt((int)loc.x() + block.getX(), (int)loc.y() + 1 + block.getY(), (int)loc.z() + block.getZ());
                Random r = new Random();
                int low = 1;
                int high = this.branchMaterial.size() + 1;
                int result = r.nextInt(high - low) + low;
                b.setType(this.branchMaterial.get(result - 1));
            }
        }
    }
}

