/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.move;

import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetDoorBlocks;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetPlayerPrefs;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisPreset;
import me.eccentric_nz.TARDIS.doors.inner.Inner;
import me.eccentric_nz.TARDIS.doors.inner.InnerDisplayDoorCloser;
import me.eccentric_nz.TARDIS.doors.inner.InnerDisplayDoorOpener;
import me.eccentric_nz.TARDIS.doors.inner.InnerDoor;
import me.eccentric_nz.TARDIS.doors.inner.InnerMinecraftDoorCloser;
import me.eccentric_nz.TARDIS.doors.outer.OuterDisplayDoorCloser;
import me.eccentric_nz.TARDIS.doors.outer.OuterDisplayDoorOpener;
import me.eccentric_nz.TARDIS.doors.outer.OuterDoor;
import me.eccentric_nz.TARDIS.doors.outer.OuterMinecraftDoorCloser;
import me.eccentric_nz.TARDIS.doors.outer.OuterMinecraftDoorOpener;
import me.eccentric_nz.TARDIS.utility.TARDISStaticUtils;
import org.bukkit.Keyed;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;

public class BlackWoolToggler {
    private final TARDIS plugin;

    public BlackWoolToggler(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void toggleBlocks(int id, Player player) {
        ResultSetDoorBlocks rsd = new ResultSetDoorBlocks(this.plugin, id);
        if (!rsd.resultSet()) {
            return;
        }
        ResultSetTardisPreset rs = new ResultSetTardisPreset(this.plugin);
        if (!rs.fromID(id)) {
            return;
        }
        boolean outerDisplayDoor = rs.getPreset().usesArmourStand();
        Block door = rsd.getInnerBlock();
        Block b = door.getRelative(BlockFace.NORTH);
        Inner innerDisplayDoor = new InnerDoor(this.plugin, id).get();
        UUID playerUUID = player.getUniqueId();
        ResultSetPlayerPrefs rsp = new ResultSetPlayerPrefs(this.plugin, playerUUID.toString());
        if (rsp.resultSet() && rsp.isOpenDisplayDoorOn() && innerDisplayDoor.display()) {
            if (TARDISStaticUtils.isDoorOpen(door)) {
                new InnerDisplayDoorCloser(this.plugin).close(door, id, playerUUID, false);
                if (outerDisplayDoor) {
                    new OuterDisplayDoorCloser(this.plugin).close(new OuterDoor(this.plugin, id).getDisplay(), id, playerUUID, false);
                } else if (rs.getPreset().hasDoor()) {
                    new OuterMinecraftDoorCloser(this.plugin).close(new OuterDoor(this.plugin, id).getMinecraft(), id, playerUUID);
                }
            } else {
                new InnerDisplayDoorOpener(this.plugin).open(door, id, false);
                if (outerDisplayDoor) {
                    new OuterDisplayDoorOpener(this.plugin).open(new OuterDoor(this.plugin, id).getDisplay(), id);
                } else if (rs.getPreset().hasDoor()) {
                    new OuterMinecraftDoorOpener(this.plugin).open(new OuterDoor(this.plugin, id).getMinecraft(), id, player);
                }
            }
        } else {
            BlockData mat;
            if (b.getType().isAir()) {
                mat = TARDISConstants.BLACK;
                this.plugin.getTrackerKeeper().getWoolToggles().remove(id);
            } else {
                mat = TARDISConstants.AIR;
                this.plugin.getTrackerKeeper().getWoolToggles().add(id);
            }
            b.setBlockData(mat);
            b.getRelative(BlockFace.UP).setBlockData(mat);
            if (Tag.DOORS.isTagged((Keyed)door.getType()) && TARDISStaticUtils.isDoorOpen(door)) {
                if (innerDisplayDoor.display()) {
                    new InnerDisplayDoorCloser(this.plugin).close(door, id, playerUUID, false);
                } else {
                    new InnerMinecraftDoorCloser(this.plugin).close(door, id, playerUUID);
                }
                if (outerDisplayDoor) {
                    new OuterDisplayDoorCloser(this.plugin).close(new OuterDoor(this.plugin, id).getDisplay(), id, playerUUID, false);
                } else if (rs.getPreset().hasDoor()) {
                    new OuterMinecraftDoorCloser(this.plugin).close(new OuterDoor(this.plugin, id).getMinecraft(), id, playerUUID);
                }
            }
        }
    }

    public boolean isOpen(int id) {
        ResultSetDoorBlocks rsd = new ResultSetDoorBlocks(this.plugin, id);
        if (rsd.resultSet()) {
            Block b = rsd.getInnerBlock().getRelative(BlockFace.NORTH);
            return b.getType().isAir();
        }
        return false;
    }
}

