/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.listeners.controls;

import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.console.telepathic.TelepathicInventory;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetControls;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetPlayerPrefs;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.floodgate.FloodgateTelepathicForm;
import me.eccentric_nz.TARDIS.floodgate.TARDISFloodgate;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class TARDISTelepathicListener
implements Listener {
    private final TARDIS plugin;

    public TARDISTelepathicListener(TARDIS plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onTelepathicCircuit(PlayerInteractEvent event) {
        if (event.getHand() == null || event.getHand().equals((Object)EquipmentSlot.OFF_HAND)) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block != null && block.getType().equals((Object)Material.DAYLIGHT_DETECTOR)) {
            String location = block.getLocation().toString();
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("type", 23);
            where.put("location", location);
            ResultSetControls rsc = new ResultSetControls(this.plugin, where, false);
            if (rsc.resultSet()) {
                Player player = event.getPlayer();
                UUID uuid = player.getUniqueId();
                int id = rsc.getTardis_id();
                if (player.isSneaking()) {
                    HashMap<String, Object> wheret = new HashMap<String, Object>();
                    wheret.put("tardis_id", id);
                    ResultSetTardis rs = new ResultSetTardis(this.plugin, wheret, "", false);
                    if (rs.resultSet()) {
                        UUID o_uuid = rs.getTardis().getUuid();
                        String owner = o_uuid.toString();
                        ResultSetPlayerPrefs rsp = new ResultSetPlayerPrefs(this.plugin, owner);
                        if (rsp.resultSet()) {
                            if (rsp.isTelepathyOn()) {
                                this.plugin.getTrackerKeeper().getTelepaths().put(uuid, o_uuid);
                                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TELEPATHIC_COMMAND");
                            } else {
                                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TELEPATHIC_OFF");
                            }
                        }
                        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> block.setBlockData(TARDISConstants.DAYLIGHT), 3L);
                    }
                } else if (TARDISFloodgate.isFloodgateEnabled() && TARDISFloodgate.isBedrockPlayer(uuid)) {
                    new FloodgateTelepathicForm(this.plugin, uuid, id).send();
                } else {
                    player.openInventory(new TelepathicInventory(this.plugin, player).getInventory());
                }
            }
        } else {
            ItemStack is = event.getItem();
            if (is == null) {
                return;
            }
            if (!is.getType().equals((Object)Material.GLOWSTONE_DUST) || !is.hasItemMeta()) {
                return;
            }
            ItemMeta im = is.getItemMeta();
            if (im.hasDisplayName() && ComponentUtils.endsWith(im.displayName(), "TARDIS Telepathic Circuit")) {
                Block up = event.getClickedBlock().getRelative(BlockFace.UP);
                if (!up.getType().isAir()) {
                    return;
                }
                up.setType(Material.DAYLIGHT_DETECTOR);
                int amount = is.getAmount();
                if (amount > 1) {
                    is.setAmount(amount - 1);
                } else {
                    event.getPlayer().getInventory().setItemInMainHand(null);
                }
                UUID uuid = event.getPlayer().getUniqueId();
                String l = up.getLocation().toString();
                this.plugin.getTrackerKeeper().getTelepathicPlacements().put(uuid, l);
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onTelepathicCircuitBreak(BlockBreakEvent event) {
        Block b = event.getBlock();
        if (!b.getType().equals((Object)Material.DAYLIGHT_DETECTOR)) {
            return;
        }
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("type", 23);
        where.put("location", b.getLocation().toString());
        ResultSetControls rsc = new ResultSetControls(this.plugin, where, false);
        if (!rsc.resultSet()) {
            return;
        }
        event.setCancelled(true);
        b.setBlockData(TARDISConstants.AIR);
        ItemStack is = ItemStack.of((Material)Material.GLOWSTONE_DUST, (int)1);
        ItemMeta im = is.getItemMeta();
        im.displayName((Component)ComponentUtils.toWhite("TARDIS Telepathic Circuit"));
        TextComponent uses = this.plugin.getConfig().getString("circuits.uses.telepathic", "20").equals("0") || !this.plugin.getConfig().getBoolean("circuits.damage") ? Component.text((String)"unlimited", (TextColor)NamedTextColor.YELLOW) : Component.text((String)this.plugin.getConfig().getString("circuits.uses.telepathic", "20"), (TextColor)NamedTextColor.YELLOW);
        List<TextComponent> lore = List.of(Component.text((String)"Uses left"), uses);
        im.lore(lore);
        is.setItemMeta(im);
        b.getWorld().dropItemNaturally(b.getLocation(), is);
    }

    @EventHandler(ignoreCancelled=true)
    public void onTelepathicCircuitPlace(BlockPlaceEvent event) {
        ItemStack is = event.getItemInHand();
        if (!is.getType().equals((Object)Material.DAYLIGHT_DETECTOR) || !is.hasItemMeta()) {
            return;
        }
        ItemMeta im = is.getItemMeta();
        if (im.hasDisplayName() && ComponentUtils.endsWith(im.displayName(), "TARDIS Telepathic Circuit")) {
            UUID uuid = event.getPlayer().getUniqueId();
            String l = event.getBlock().getLocation().toString();
            this.plugin.getTrackerKeeper().getTelepathicPlacements().put(uuid, l);
        }
    }
}

