/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.listeners;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.builders.exterior.BuilderUtility;
import me.eccentric_nz.TARDIS.builders.interior.TARDISInteriorPostioning;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItemUtils;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisID;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.flight.FlightEnd;
import me.eccentric_nz.TARDIS.flight.FlightReturnData;
import me.eccentric_nz.TARDIS.flight.vehicle.TARDISArmourStand;
import me.eccentric_nz.TARDIS.utility.TARDISBlockSetters;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Levelled;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.entity.CraftArmorStand;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffectType;

public class TARDISTeleportListener
implements Listener {
    private final TARDIS plugin;
    private final List<PlayerTeleportEvent.TeleportCause> causes = new ArrayList<PlayerTeleportEvent.TeleportCause>();

    public TARDISTeleportListener(TARDIS plugin) {
        this.plugin = plugin;
        this.causes.add(PlayerTeleportEvent.TeleportCause.PLUGIN);
        this.causes.add(PlayerTeleportEvent.TeleportCause.COMMAND);
        this.causes.add(PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onTeleport(PlayerTeleportEvent event) {
        Player player = event.getPlayer();
        PlayerTeleportEvent.TeleportCause cause = event.getCause();
        String world_to = event.getTo().getWorld().getName();
        String world_from = event.getFrom().getWorld().getName();
        if (this.plugin.getTrackerKeeper().getFlyingReturnLocation().containsKey(player.getUniqueId())) {
            if (this.plugin.getTrackerKeeper().getStillFlyingNotReturning().contains(player.getUniqueId())) {
                if (world_to.contains("TARDIS") || world_from.contains("TARDIS") || cause == PlayerTeleportEvent.TeleportCause.UNKNOWN || cause == PlayerTeleportEvent.TeleportCause.DISMOUNT) {
                    return;
                }
                this.stopFlying(player);
            } else {
                player.resetPlayerTime();
            }
            return;
        }
        if (this.causes.contains(cause)) {
            String uuid = player.getUniqueId().toString();
            if (world_from.contains("TARDIS") && !world_to.contains("TARDIS")) {
                HashMap<String, Object> where = new HashMap<String, Object>();
                where.put("uuid", uuid);
                this.plugin.getQueryFactory().doDelete("travellers", where);
                if (!cause.equals((Object)PlayerTeleportEvent.TeleportCause.PLUGIN)) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "OCCUPY_AUTO");
                }
                this.plugin.getTrackerKeeper().getTelepaths().remove(player.getUniqueId());
                player.resetPlayerTime();
            } else if (world_to.contains("TARDIS") && !cause.equals((Object)PlayerTeleportEvent.TeleportCause.PLUGIN)) {
                int slot;
                ResultSetTardisID rsid = new ResultSetTardisID(this.plugin);
                if (this.plugin.getConfig().getBoolean("creation.default_world") ? (this.plugin.getConfig().getBoolean("creation.create_worlds_with_perms") && player.hasPermission("tardis.create_world") ? !rsid.fromUUID(uuid) : !rsid.fromTIPSSlot(slot = TARDISInteriorPostioning.getTIPSSlot(player.getLocation()))) : !rsid.fromUUID(uuid)) {
                    return;
                }
                HashMap<String, Object> wherer = new HashMap<String, Object>();
                wherer.put("uuid", uuid);
                this.plugin.getQueryFactory().doDelete("travellers", wherer);
                this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                    HashMap<String, Object> wherei = new HashMap<String, Object>();
                    wherei.put("tardis_id", rsid.getTardisId());
                    wherei.put("uuid", uuid);
                    this.plugin.getQueryFactory().doInsert("travellers", wherei);
                }, 2L);
            }
        }
    }

    private void stopFlying(Player player) {
        if (player.hasPotionEffect(PotionEffectType.INVISIBILITY)) {
            player.removePotionEffect(PotionEffectType.INVISIBILITY);
        }
        UUID uuid = player.getUniqueId();
        this.plugin.getTrackerKeeper().getHiddenFlight().remove(uuid);
        String direction = player.getFacing().getOppositeFace().toString();
        FlightReturnData data = this.plugin.getTrackerKeeper().getFlyingReturnLocation().get(uuid);
        if (data != null) {
            Location interior = data.location();
            this.plugin.getServer().getScheduler().cancelTask(data.animation());
            this.plugin.getServer().getScheduler().cancelTask(data.sound());
            ArmorStand stand = (ArmorStand)Bukkit.getEntity((UUID)data.stand());
            if (stand != null) {
                TARDISArmourStand tas = (TARDISArmourStand)((CraftArmorStand)stand).getHandle();
                tas.setPlayer(null);
                tas.setStationary(true);
                Location location = stand.getLocation();
                ItemDisplay display = (ItemDisplay)Bukkit.getEntity((UUID)data.display());
                ItemStack is = display.getItemStack();
                EntityEquipment ee = stand.getEquipment();
                ee.setHelmet(is);
                HashMap<String, Object> set = new HashMap<String, Object>();
                set.put("world", location.getWorld().getName());
                set.put("x", location.getBlockX());
                set.put("y", location.getBlockY());
                set.put("z", location.getBlockZ());
                set.put("direction", direction);
                set.put("submarine", player.isInWater() ? 1 : 0);
                HashMap<String, Object> where = new HashMap<String, Object>();
                where.put("tardis_id", data.id());
                this.plugin.getQueryFactory().doUpdate("current", set, where);
                BuilderUtility.saveDoorLocation(location, data.id(), direction);
                Block under = location.getBlock().getRelative(BlockFace.DOWN);
                if (under.getType().isAir()) {
                    TARDISBlockSetters.setUnderDoorBlock(location.getWorld(), under.getX(), under.getY(), under.getZ(), data.id(), false);
                }
                Levelled light = TARDISConstants.LIGHT;
                light.setLevel(7);
                location.getBlock().getRelative(BlockFace.UP, 2).setBlockData((BlockData)light);
                TARDISDisplayItemUtils.setInteraction(stand, data.id());
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)TARDIS.plugin, () -> {
                    COMPASS compass = COMPASS.valueOf(direction);
                    stand.teleport(new Location(location.getWorld(), (double)location.getBlockX() + 0.5, (double)location.getBlockY(), (double)location.getBlockZ() + 0.5, compass.getYaw(), 0.0f));
                });
            }
            this.plugin.getTrackerKeeper().getFlyingReturnLocation().remove(player.getUniqueId());
            this.plugin.getTrackerKeeper().getStillFlyingNotReturning().remove(player.getUniqueId());
            player.teleport(interior);
            player.setInvulnerable(false);
            player.setFlying(false);
            player.setAllowFlight(false);
            HashMap<String, Object> sett = new HashMap<String, Object>();
            sett.put("tardis_id", data.id());
            sett.put("uuid", uuid.toString());
            this.plugin.getQueryFactory().doSyncInsert("travellers", sett);
            this.plugin.getTrackerKeeper().getMaterialising().removeAll(Collections.singleton(data.id()));
            this.plugin.getTrackerKeeper().getMalfunction().remove(data.id());
            this.plugin.getTrackerKeeper().getInVortex().removeAll(Collections.singleton(data.id()));
            if (this.plugin.getTrackerKeeper().getDidDematToVortex().contains(data.id())) {
                this.plugin.getTrackerKeeper().getDidDematToVortex().removeAll(Collections.singleton(data.id()));
            }
            if (this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(data.id())) {
                int taskID = this.plugin.getTrackerKeeper().getDestinationVortex().get(data.id());
                this.plugin.getServer().getScheduler().cancelTask(taskID);
                this.plugin.getTrackerKeeper().getDestinationVortex().remove(data.id());
            }
            new FlightEnd(this.plugin).process(data.id(), player, false, true);
        }
    }
}

