/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.listeners;

import com.destroystokyo.paper.MaterialTags;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.advanced.CircuitChecker;
import me.eccentric_nz.TARDIS.advanced.CircuitDamager;
import me.eccentric_nz.TARDIS.api.Parameters;
import me.eccentric_nz.TARDIS.artron.AdaptiveBoxLampToggler;
import me.eccentric_nz.TARDIS.artron.BeaconToggler;
import me.eccentric_nz.TARDIS.artron.PresetLampToggler;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.builders.exterior.BuildData;
import me.eccentric_nz.TARDIS.builders.exterior.EmergencyRelocation;
import me.eccentric_nz.TARDIS.database.data.Current;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.data.Throticle;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetPlayerPrefs;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetThrottle;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTravellers;
import me.eccentric_nz.TARDIS.destroyers.DestroyData;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.enumeration.DiskCircuit;
import me.eccentric_nz.TARDIS.enumeration.Flag;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.sensor.PowerSensor;
import me.eccentric_nz.TARDIS.travel.TARDISTimeTravel;
import me.eccentric_nz.TARDIS.upgrades.SystemTree;
import me.eccentric_nz.TARDIS.upgrades.SystemUpgradeChecker;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.TARDIS.utility.TARDISMaterials;
import me.eccentric_nz.TARDIS.utility.TARDISStaticUtils;
import me.eccentric_nz.TARDIS.utility.protection.TARDISLWCChecker;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import nl.rutgerkok.blocklocker.BlockLockerAPIv2;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class TARDISStattenheimListener
implements Listener {
    private final TARDIS plugin;
    private final List<Material> useless = new ArrayList<Material>();

    public TARDISStattenheimListener(TARDIS plugin) {
        this.plugin = plugin;
        this.useless.add(Material.SNOW);
        this.useless.add(Material.MOSS_CARPET);
        this.useless.addAll(Tag.WOOL_CARPETS.getValues());
        this.useless.addAll(TARDISMaterials.plants);
        this.useless.addAll(Tag.FLOWERS.getValues());
        this.useless.addAll(MaterialTags.MUSHROOMS.getValues());
        this.useless.addAll(Tag.SAPLINGS.getValues());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onStattenheimInteract(PlayerInteractEvent event) {
        ItemMeta im;
        if (event.getHand() == null || event.getHand().equals((Object)EquipmentSlot.OFF_HAND)) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack is = player.getInventory().getItemInMainHand();
        if (is.getType().equals((Object)Material.FLINT) && is.hasItemMeta() && ComponentUtils.endsWith((im = is.getItemMeta()).displayName(), "Stattenheim Remote")) {
            int uses;
            UUID uuid = player.getUniqueId();
            if (this.plugin.getConfig().getBoolean("difficulty.system_upgrades") && !new SystemUpgradeChecker(this.plugin).has(uuid.toString(), SystemTree.STATTENHEIM_REMOTE)) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SYS_NEED", "Stattenheim Remote");
                return;
            }
            if (im.getPersistentDataContainer().has(this.plugin.getCustomBlockKey(), PersistentDataType.INTEGER)) {
                uses = (Integer)im.getPersistentDataContainer().get(this.plugin.getCustomBlockKey(), PersistentDataType.INTEGER);
                if (uses <= 0) {
                    player.getInventory().setItemInMainHand(null);
                    player.playSound(player.getLocation(), Sound.ITEM_SHIELD_BREAK, 1.0f, 1.0f);
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "STATTENHEIM_USED");
                    return;
                }
            } else {
                int u = this.plugin.getConfig().getInt("circuits.uses.stattenheim");
                uses = u > 0 ? u : 1000;
                im.getPersistentDataContainer().set(this.plugin.getCustomBlockKey(), PersistentDataType.INTEGER, (Object)uses);
                is.setItemMeta(im);
            }
            Action action = event.getAction();
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("uuid", uuid.toString());
            ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
            if (!rs.resultSet()) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_TARDIS");
                return;
            }
            Tardis tardis = rs.getTardis();
            int id = tardis.getTardisId();
            if (this.plugin.getTrackerKeeper().getInSiegeMode().contains(id)) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SIEGE_NO_CONTROL");
                return;
            }
            if (this.plugin.getTrackerKeeper().getDispersedTARDII().contains(id)) {
                this.plugin.getMessenger().send((CommandSender)player.getPlayer(), TardisModule.TARDIS, "NOT_WHILE_DISPERSED");
                return;
            }
            boolean power = tardis.isPoweredOn();
            if (action.equals((Object)Action.RIGHT_CLICK_BLOCK)) {
                Block b = event.getClickedBlock();
                Material m = b.getType();
                if (b.getState() instanceof InventoryHolder || Tag.DOORS.isTagged((Keyed)m)) {
                    return;
                }
                if (TARDISPermission.hasPermission(player, "tardis.timetravel")) {
                    int count;
                    Location remoteLocation = b.getLocation();
                    if (!this.plugin.getConfig().getBoolean("travel.include_default_world") && this.plugin.getConfig().getBoolean("creation.default_world") && remoteLocation.getWorld().getName().equals(this.plugin.getConfig().getString("creation.default_world_name"))) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_WORLD_TRAVEL");
                        return;
                    }
                    if (!this.plugin.getPluginRespect().getRespect(remoteLocation, new Parameters(player, Flag.getDefaultFlags()))) {
                        return;
                    }
                    if (TARDISPermission.hasPermission(player, "tardis.exile") && this.plugin.getConfig().getBoolean("travel.exile")) {
                        String areaPerm = this.plugin.getTardisArea().getExileArea(player);
                        if (this.plugin.getTardisArea().areaCheckInExile(areaPerm, remoteLocation)) {
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "EXILE_NO_TRAVEL");
                            return;
                        }
                    }
                    if (this.plugin.getTardisArea().isInExistingArea(remoteLocation)) {
                        this.plugin.getMessenger().sendColouredCommand((CommandSender)player, "AREA_NO_STAT", "/tardistravel area [area name]", this.plugin);
                        return;
                    }
                    if (!this.useless.contains(m)) {
                        int yplusone = remoteLocation.getBlockY();
                        remoteLocation.setY((double)(yplusone + 1));
                    }
                    String world = remoteLocation.getWorld().getName();
                    if (!this.plugin.getPlanetsConfig().getBoolean("planets." + world + ".time_travel")) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_PB_IN_WORLD");
                        return;
                    }
                    if (this.plugin.getConfig().getBoolean("allow.power_down") && !power) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "POWER_DOWN");
                        return;
                    }
                    CircuitChecker tcc = new CircuitChecker(this.plugin, id);
                    tcc.getCircuits();
                    if (this.plugin.getConfig().getBoolean("difficulty.circuits") && !this.plugin.getUtils().inGracePeriod(player, true) && !tcc.hasMaterialisation()) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_MAT_CIRCUIT");
                        return;
                    }
                    if (this.plugin.getConfig().getBoolean("circuits.damage") && this.plugin.getConfig().getInt("circuits.uses.materialisation") > 0) {
                        int uses_left = tcc.getMaterialisationUses();
                        new CircuitDamager(this.plugin, DiskCircuit.MATERIALISATION, uses_left, id, player).damage();
                    }
                    int decremented = uses - 1;
                    im.getPersistentDataContainer().set(this.plugin.getCustomBlockKey(), PersistentDataType.INTEGER, (Object)decremented);
                    im.lore(List.of(Component.text((String)"Right-click block"), Component.text((String)"to call TARDIS"), Component.text((String)"Uses left"), Component.text((int)decremented, (TextColor)NamedTextColor.YELLOW)));
                    is.setItemMeta(im);
                    boolean hidden = tardis.isHidden();
                    int level = tardis.getArtronLevel();
                    HashMap<String, Object> wherettrav = new HashMap<String, Object>();
                    wherettrav.put("uuid", uuid.toString());
                    wherettrav.put("tardis_id", id);
                    ResultSetTravellers rst = new ResultSetTravellers(this.plugin, wherettrav, false);
                    if (rst.resultSet()) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_PB_IN_TARDIS");
                        return;
                    }
                    if (this.plugin.getTrackerKeeper().getInVortex().contains(id) || this.plugin.getTrackerKeeper().getMaterialising().contains(id) || this.plugin.getTrackerKeeper().getDematerialising().contains(id)) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_WHILE_MAT");
                        return;
                    }
                    ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, id);
                    if (!rsc.resultSet()) {
                        new EmergencyRelocation(this.plugin).relocate(id, player);
                        return;
                    }
                    Current current = rsc.getCurrent();
                    COMPASS d = current.direction();
                    COMPASS player_d = COMPASS.valueOf(TARDISStaticUtils.getPlayersDirection(player, false));
                    TARDISTimeTravel tt = new TARDISTimeTravel(this.plugin);
                    boolean sub = false;
                    if (b.getRelative(BlockFace.UP).getType().equals((Object)Material.WATER)) {
                        int n = count = tt.isSafeSubmarine(remoteLocation, player_d) ? 0 : 1;
                        if (count == 0) {
                            sub = true;
                        }
                    } else {
                        int[] start_loc = TARDISTimeTravel.getStartLocation(remoteLocation, player_d);
                        count = TARDISTimeTravel.safeLocation(start_loc[0], remoteLocation.getBlockY(), start_loc[2], start_loc[1], start_loc[3], remoteLocation.getWorld(), player_d);
                    }
                    Block under = remoteLocation.getBlock().getRelative(BlockFace.DOWN);
                    if (this.plugin.getPM().isPluginEnabled("BlockLocker") && (BlockLockerAPIv2.isProtected((Block)remoteLocation.getBlock()) || BlockLockerAPIv2.isProtected((Block)under))) {
                        count = 1;
                    }
                    if (this.plugin.getPM().isPluginEnabled("LWC") && new TARDISLWCChecker().isBlockProtected(remoteLocation.getBlock(), under, player)) {
                        count = 1;
                    }
                    if (count > 0) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "WOULD_GRIEF_BLOCKS");
                        return;
                    }
                    Throticle throticle = new ResultSetThrottle(this.plugin).getSpeedAndParticles(uuid.toString());
                    int ch = Math.round((float)this.plugin.getArtronConfig().getInt("comehere") * throticle.throttle().getArtronMultiplier());
                    if (level < ch) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_ENOUGH_ENERGY");
                        return;
                    }
                    Location oldSave = null;
                    HashMap<String, Object> bid = new HashMap<String, Object>();
                    bid.put("tardis_id", id);
                    HashMap<String, Object> bset = new HashMap<String, Object>();
                    if (current.location().getWorld() != null) {
                        oldSave = current.location();
                        bset.put("world", current.location().getWorld().getName());
                        bset.put("x", current.location().getBlockX());
                        bset.put("y", current.location().getBlockY());
                        bset.put("z", current.location().getBlockZ());
                        bset.put("direction", d.toString());
                        bset.put("submarine", current.submarine());
                    } else {
                        hidden = true;
                        bset.put("world", remoteLocation.getWorld().getName());
                        bset.put("x", remoteLocation.getX());
                        bset.put("y", remoteLocation.getY());
                        bset.put("z", remoteLocation.getZ());
                        bset.put("submarine", sub ? 1 : 0);
                    }
                    this.plugin.getQueryFactory().doUpdate("back", bset, bid);
                    HashMap<String, Object> cid = new HashMap<String, Object>();
                    cid.put("tardis_id", id);
                    HashMap<String, Object> cset = new HashMap<String, Object>();
                    cset.put("world", remoteLocation.getWorld().getName());
                    cset.put("x", remoteLocation.getBlockX());
                    cset.put("y", remoteLocation.getBlockY());
                    cset.put("z", remoteLocation.getBlockZ());
                    cset.put("direction", player_d.toString());
                    cset.put("submarine", sub ? 1 : 0);
                    this.plugin.getQueryFactory().doUpdate("current", cset, cid);
                    if (hidden) {
                        HashMap<String, Object> tid = new HashMap<String, Object>();
                        HashMap<String, Object> set = new HashMap<String, Object>();
                        set.put("hidden", 0);
                        tid.put("tardis_id", id);
                        this.plugin.getQueryFactory().doUpdate("tardis", set, tid);
                    }
                    this.plugin.getMessenger().sendStatus(player, "TARDIS_COMING");
                    long delay = 10L;
                    this.plugin.getTrackerKeeper().getInVortex().add(id);
                    boolean hid = hidden;
                    if (!this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(id)) {
                        DestroyData dd = new DestroyData();
                        dd.setDirection(d);
                        dd.setLocation(oldSave);
                        dd.setPlayer((OfflinePlayer)player);
                        dd.setHide(false);
                        dd.setOutside(true);
                        dd.setSubmarine(current.submarine());
                        dd.setTardisID(id);
                        dd.setThrottle(throticle.throttle());
                        dd.setParticles(throticle.particles());
                        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                            if (!hid) {
                                this.plugin.getTrackerKeeper().getDematerialising().add(id);
                                this.plugin.getPresetDestroyer().destroyPreset(dd);
                            } else {
                                this.plugin.getPresetDestroyer().removeBlockProtection(id);
                            }
                        }, delay);
                    }
                    BuildData bd = new BuildData(uuid.toString());
                    bd.setDirection(player_d);
                    bd.setLocation(remoteLocation);
                    bd.setMalfunction(false);
                    bd.setOutside(true);
                    bd.setPlayer((OfflinePlayer)player);
                    bd.setRebuild(false);
                    bd.setSubmarine(sub);
                    bd.setTardisID(id);
                    bd.setThrottle(throticle.throttle());
                    bd.setParticles(throticle.particles());
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.plugin.getPresetBuilder().buildPreset(bd), delay * 2L);
                    HashMap<String, Object> wheret = new HashMap<String, Object>();
                    wheret.put("tardis_id", id);
                    this.plugin.getQueryFactory().alterEnergyLevel("tardis", -ch, wheret, player);
                    this.plugin.getTrackerKeeper().getHasDestination().remove(id);
                    this.plugin.getTrackerKeeper().getRescue().remove(id);
                } else {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_PERMS");
                }
            } else if (action.equals((Object)Action.RIGHT_CLICK_AIR) && this.plugin.getConfig().getBoolean("allow.power_down") && !power) {
                ResultSetPlayerPrefs rsp = new ResultSetPlayerPrefs(this.plugin, uuid.toString());
                boolean beacon_on = true;
                if (rsp.resultSet()) {
                    beacon_on = rsp.isBeaconOn();
                }
                ChameleonPreset preset = tardis.getPreset();
                HashMap<String, Object> wherep = new HashMap<String, Object>();
                wherep.put("tardis_id", id);
                HashMap<String, Object> setp = new HashMap<String, Object>();
                setp.put("powered_on", 1);
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "POWER_ON");
                if (tardis.isLightsOn()) {
                    new PresetLampToggler(this.plugin).flickSwitch(id, uuid, false, tardis.getSchematic().getLights());
                }
                if (beacon_on) {
                    new BeaconToggler(this.plugin).flickSwitch(uuid, id, true);
                }
                if (preset.equals((Object)ChameleonPreset.ADAPTIVE) || preset.usesArmourStand()) {
                    new AdaptiveBoxLampToggler(this.plugin).toggleLamp(id, true, preset);
                }
                this.plugin.getQueryFactory().doUpdate("tardis", setp, wherep);
                new PowerSensor(this.plugin, id).toggle();
            }
        }
    }
}

