/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.listeners;

import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class TARDISGlassesListener
implements Listener {
    private final TARDIS plugin;

    public TARDISGlassesListener(TARDIS plugin) {
        this.plugin = plugin;
        this.checkGlasses(this.plugin);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on3dGlassesEquip(InventoryCloseEvent event) {
        Inventory inv = event.getInventory();
        if (inv.getType().equals((Object)InventoryType.CRAFTING)) {
            Player player = (Player)event.getPlayer();
            PlayerInventory pi = player.getInventory();
            ItemStack is = pi.getHelmet();
            if (is != null) {
                if (this.is3DGlasses(is) && !this.plugin.getTrackerKeeper().getSpectacleWearers().contains(player.getUniqueId())) {
                    player.removePotionEffect(PotionEffectType.NIGHT_VISION);
                    player.addPotionEffect(new PotionEffect(PotionEffectType.NIGHT_VISION, 3600, 10));
                    this.plugin.getTrackerKeeper().getSpectacleWearers().add(player.getUniqueId());
                }
            } else if (this.plugin.getTrackerKeeper().getSpectacleWearers().contains(player.getUniqueId())) {
                player.removePotionEffect(PotionEffectType.NIGHT_VISION);
                this.plugin.getTrackerKeeper().getSpectacleWearers().remove(player.getUniqueId());
            }
        }
    }

    private void checkGlasses(TARDIS plugin) {
        plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)plugin, () -> plugin.getTrackerKeeper().getSpectacleWearers().forEach(uuid -> {
            Player p = plugin.getServer().getPlayer(uuid);
            if (p != null && p.isOnline()) {
                PlayerInventory pi = p.getInventory();
                ItemStack is = pi.getHelmet();
                boolean g = this.is3DGlasses(is);
                if ((is == null || !g) && p.hasPotionEffect(PotionEffectType.NIGHT_VISION)) {
                    p.removePotionEffect(PotionEffectType.NIGHT_VISION);
                    plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)plugin, (Runnable)new removeFromMap((UUID)uuid), 20L);
                } else if (is != null && g) {
                    Damageable damageable = (Damageable)is.getItemMeta();
                    int d = damageable.getDamage() + 1;
                    if (d >= 56) {
                        pi.setHelmet(null);
                        p.removePotionEffect(PotionEffectType.NIGHT_VISION);
                        plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "GLASSES_DONE");
                        p.getWorld().dropItemNaturally(p.getLocation(), ItemStack.of((Material)Material.PAPER, (int)1));
                        plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)plugin, (Runnable)new removeFromMap((UUID)uuid), 20L);
                    } else {
                        damageable.setDamage(d);
                    }
                    p.updateInventory();
                }
            }
        }), 3600L, 1200L);
    }

    private boolean is3DGlasses(ItemStack is) {
        if (is != null && is.hasItemMeta()) {
            ItemMeta im = is.getItemMeta();
            return im.hasDisplayName() && ComponentUtils.endsWith(im.displayName(), "3-D Glasses");
        }
        return false;
    }

    class removeFromMap
    implements Runnable {
        final UUID uuid;

        removeFromMap(UUID uuid) {
            this.uuid = uuid;
        }

        @Override
        public void run() {
            TARDISGlassesListener.this.plugin.getTrackerKeeper().getSpectacleWearers().remove(this.uuid);
        }
    }
}

