/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.lights;

import com.google.gson.JsonObject;
import java.util.HashMap;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.builders.interior.TARDISInteriorPostioning;
import me.eccentric_nz.TARDIS.builders.interior.TIPSData;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItemUtils;
import me.eccentric_nz.TARDIS.customblocks.VariableLight;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.enumeration.Schematic;
import me.eccentric_nz.TARDIS.enumeration.TardisLight;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.schematic.SchematicGZip;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class LightConverter {
    private final TARDIS plugin;

    public LightConverter(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void apply(TardisLight light, Material emitting, Player player, Material variable) {
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("uuid", player.getUniqueId().toString());
        ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
        if (rs.resultSet()) {
            Tardis tardis = rs.getTardis();
            World w = player.getWorld();
            Schematic schm = tardis.getSchematic();
            JsonObject obj = SchematicGZip.getObject(this.plugin, "consoles", schm.getPermission(), schm.isCustom());
            if (obj != null) {
                JsonObject dimensions = obj.get("dimensions").getAsJsonObject();
                int h = dimensions.get("height").getAsInt();
                int width = dimensions.get("width").getAsInt();
                int d = dimensions.get("length").getAsInt() - 1;
                int starty = schm.getStartY();
                int endy = starty + h;
                TARDISInteriorPostioning tintpos = new TARDISInteriorPostioning(this.plugin);
                TIPSData pos = tintpos.getTIPSData(tardis.getTIPS());
                int minx = pos.getCentreX();
                int maxx = minx + width;
                int minz = pos.getCentreZ();
                int maxz = minz + d;
                for (int l = starty; l <= endy; ++l) {
                    for (int r = minx; r <= maxx; ++r) {
                        for (int c = minz; c <= maxz; ++c) {
                            Block b = w.getBlockAt(r, l, c);
                            if (!b.getType().equals((Object)emitting)) continue;
                            if (light.getOn().isVariable()) {
                                new VariableLight(variable, b.getLocation().add(0.5, 0.5, 0.5)).set(tardis.isLightsOn() ? light.getOn().getCustomModel() : light.getOff().getCustomModel(), tardis.isLightsOn() ? 15 : 0);
                            } else {
                                TARDISDisplayItemUtils.set(light.getOn(), b, -1);
                            }
                            for (BlockFace face : this.plugin.getGeneralKeeper().getBlockFaces()) {
                                Block block = b.getRelative(face);
                                if (!block.getType().equals((Object)Material.LEVER) && !block.getType().equals((Object)Material.REDSTONE_BLOCK)) continue;
                                block.setType(Material.AIR);
                            }
                        }
                    }
                }
                this.plugin.getMessenger().message((CommandSender)player, TardisModule.TARDIS, "Light conversion complete");
                this.plugin.getTrackerKeeper().getLightChangers().remove(player.getUniqueId());
            }
        }
    }
}

