/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.floodgate;

import java.util.Locale;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.data.Archive;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisSize;
import me.eccentric_nz.TARDIS.desktop.DesktopThemeProcessor;
import me.eccentric_nz.TARDIS.desktop.RandomArchiveName;
import me.eccentric_nz.TARDIS.desktop.UpgradeData;
import me.eccentric_nz.TARDIS.enumeration.ConsoleSize;
import me.eccentric_nz.TARDIS.enumeration.Desktops;
import me.eccentric_nz.TARDIS.enumeration.Schematic;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.floodgate.FloodgateColouredBlocks;
import me.eccentric_nz.TARDIS.schematic.archive.ArchiveUpdate;
import me.eccentric_nz.TARDIS.schematic.archive.ResultSetArchiveButtons;
import me.eccentric_nz.TARDIS.schematic.archive.ResultSetArchiveByName;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.geysermc.cumulus.form.Form;
import org.geysermc.cumulus.form.SimpleForm;
import org.geysermc.cumulus.response.SimpleFormResponse;
import org.geysermc.cumulus.util.FormImage;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.floodgate.api.player.FloodgatePlayer;

public class FloodgateDesktopArchiveForm {
    private final TARDIS plugin;
    private final UUID uuid;
    private final String path = "textures/blocks/%s.png";

    public FloodgateDesktopArchiveForm(TARDIS plugin, UUID uuid) {
        this.plugin = plugin;
        this.uuid = uuid;
    }

    public void send() {
        SimpleForm.Builder builder = SimpleForm.builder();
        builder.button("Scan console", FormImage.Type.URL, "https://github.com/eccentricdevotion/TARDIS-Resource-Pack/raw/master/assets/tardis/textures/item/gui/archive/scan_button.png");
        builder.button("Archive current console", FormImage.Type.URL, "https://github.com/eccentricdevotion/TARDIS-Resource-Pack/raw/master/assets/tardis/textures/item/gui/archive/archive_button.png");
        ResultSetArchiveButtons rs = new ResultSetArchiveButtons(this.plugin, this.uuid.toString());
        if (rs.resultSet()) {
            int i = 48;
            builder.title("TARDIS Archive");
            ItemStack[] itemStackArray = rs.getButtons();
            int n = itemStackArray.length;
            for (int j = 0; j < n; ++j) {
                ItemStack is = itemStackArray[j];
                ItemMeta im = is.getItemMeta();
                builder.button(ComponentUtils.stripColour(im.displayName()), FormImage.Type.PATH, String.format("textures/blocks/%s.png", FloodgateColouredBlocks.IMAGES.get(i)));
                ++i;
            }
        }
        for (ConsoleSize c : ConsoleSize.values()) {
            if (c.equals((Object)ConsoleSize.MASSIVE)) continue;
            String url = "https://raw.githubusercontent.com/eccentricdevotion/TARDIS-Resource-Pack/master/assets/tardis/textures/item/gui/archive/" + c.toString().toLowerCase(Locale.ROOT) + ".png";
            builder.button(c.toString(), FormImage.Type.URL, url);
        }
        builder.validResultHandler(this::handleResponse);
        SimpleForm form = (SimpleForm)builder.build();
        FloodgatePlayer player = FloodgateApi.getInstance().getPlayer(this.uuid);
        player.sendForm((Form)form);
    }

    private void handleResponse(SimpleFormResponse response) {
        String label;
        Player player = this.plugin.getServer().getPlayer(this.uuid);
        switch (label = response.clickedButton().text()) {
            case "Scan console": {
                ResultSetTardisSize rss = new ResultSetTardisSize(this.plugin);
                if (!rss.fromUUID(this.uuid.toString())) break;
                player.performCommand("tardis archive scan " + rss.getConsoleSize().toString());
                break;
            }
            case "Archive current console": {
                ResultSetTardisSize rss = new ResultSetTardisSize(this.plugin);
                if (!rss.fromUUID(this.uuid.toString())) break;
                String name = RandomArchiveName.getRandomName();
                player.performCommand("tardis archive add " + name + " " + rss.getConsoleSize().toString());
                break;
            }
            case "SMALL": 
            case "MEDIUM": 
            case "TALL": {
                UpgradeData tud = this.plugin.getTrackerKeeper().getUpgrades().get(this.uuid);
                String size = label.toLowerCase(Locale.ROOT);
                int upgrade = this.plugin.getArtronConfig().getInt("upgrades.template." + size);
                if (tud.getLevel() < upgrade) break;
                new ArchiveUpdate(this.plugin, this.uuid.toString(), label).setInUse();
                tud.setSchematic(Desktops.schematicFor(size));
                tud.setWall("ORANGE_WOOL");
                tud.setFloor("LIGHT_GRAY_WOOL");
                this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                    this.plugin.getTrackerKeeper().getUpgrades().put(this.uuid, tud);
                    new DesktopThemeProcessor(this.plugin, this.uuid).changeDesktop();
                }, 10L);
                break;
            }
            default: {
                Schematic schm = Desktops.schematicFor("archive");
                UpgradeData tud = this.plugin.getTrackerKeeper().getUpgrades().get(this.uuid);
                ResultSetArchiveByName rsa = new ResultSetArchiveByName(this.plugin, this.uuid.toString(), label);
                if (!rsa.resultSet()) break;
                Archive a = rsa.getArchive();
                if (a.getUse() == 1) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ARCHIVE_NOT_CURRENT");
                    return;
                }
                int upgrade = this.plugin.getArtronConfig().getInt("upgrades.archive." + a.getConsoleSize().toString().toLowerCase(Locale.ROOT));
                if (tud.getLevel() < upgrade) break;
                new ArchiveUpdate(this.plugin, this.uuid.toString(), label).setInUse();
                tud.setSchematic(schm);
                tud.setWall("ORANGE_WOOL");
                tud.setFloor("LIGHT_GRAY_WOOL");
                this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                    this.plugin.getTrackerKeeper().getUpgrades().put(this.uuid, tud);
                    new DesktopThemeProcessor(this.plugin, this.uuid).changeDesktop();
                }, 10L);
            }
        }
    }
}

