/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.destroyers;

import java.util.Locale;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.builders.exterior.BuilderUtility;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItemUtils;
import me.eccentric_nz.TARDIS.custommodels.keys.ChameleonVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.ColouredVariant;
import me.eccentric_nz.TARDIS.database.data.ParticleData;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetParticlePrefs;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetPlayerPrefs;
import me.eccentric_nz.TARDIS.destroyers.DestroyData;
import me.eccentric_nz.TARDIS.destroyers.InstantPresetDestroyer;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.enumeration.SpaceTimeThrottle;
import me.eccentric_nz.TARDIS.particles.Emitter;
import me.eccentric_nz.TARDIS.utility.TARDISSounds;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Levelled;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Interaction;
import org.bukkit.entity.ItemFrame;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class DematerialiseModelledPreset
implements Runnable {
    private final TARDIS plugin;
    private final DestroyData dd;
    private final int loops;
    private final ChameleonPreset preset;
    private int task;
    private int i;
    private ItemFrame frame;
    private ArmorStand stand;
    private ItemStack is;

    DematerialiseModelledPreset(TARDIS plugin, DestroyData dd, ChameleonPreset preset) {
        this.plugin = plugin;
        this.dd = dd;
        this.loops = dd.getThrottle().getLoops();
        this.preset = preset;
    }

    @Override
    public void run() {
        World world = this.dd.getLocation().getWorld();
        Block light = this.dd.getLocation().getBlock().getRelative(BlockFace.UP, 2);
        Material dye = BuilderUtility.getMaterialForArmourStand(this.preset, this.dd.getTardisID(), false);
        if (this.i < this.loops) {
            NamespacedKey model;
            if (this.i % 2 == 0) {
                model = switch (dye) {
                    case Material.BLACK_DYE -> ChameleonVariant.BLACK_STAINED.getKey();
                    case Material.BLUE_DYE -> ChameleonVariant.BLUE_STAINED.getKey();
                    case Material.BROWN_DYE -> ChameleonVariant.BROWN_STAINED.getKey();
                    case Material.CYAN_DYE -> ChameleonVariant.CYAN_STAINED.getKey();
                    case Material.GRAY_DYE -> ChameleonVariant.GRAY_STAINED.getKey();
                    case Material.GREEN_DYE -> ChameleonVariant.GREEN_STAINED.getKey();
                    case Material.LIGHT_BLUE_DYE -> ChameleonVariant.LIGHT_BLUE_STAINED.getKey();
                    case Material.LIGHT_GRAY_DYE -> ChameleonVariant.LIGHT_GRAY_STAINED.getKey();
                    case Material.LIME_DYE -> ChameleonVariant.LIME_STAINED.getKey();
                    case Material.MAGENTA_DYE -> ChameleonVariant.MAGENTA_STAINED.getKey();
                    case Material.ORANGE_DYE -> ChameleonVariant.ORANGE_STAINED.getKey();
                    case Material.PINK_DYE -> ChameleonVariant.PINK_STAINED.getKey();
                    case Material.PURPLE_DYE -> ChameleonVariant.PURPLE_STAINED.getKey();
                    case Material.RED_DYE -> ChameleonVariant.RED_STAINED.getKey();
                    case Material.WHITE_DYE -> ChameleonVariant.WHITE_STAINED.getKey();
                    case Material.YELLOW_DYE -> ChameleonVariant.YELLOW_STAINED.getKey();
                    case Material.CYAN_STAINED_GLASS_PANE -> ChameleonVariant.TENNANT_STAINED.getKey();
                    case Material.GRAY_STAINED_GLASS_PANE -> ChameleonVariant.WEEPING_ANGEL_STAINED.getKey();
                    case Material.GREEN_STAINED_GLASS_PANE -> ChameleonVariant.SIDRAT_STAINED.getKey();
                    case Material.RED_STAINED_GLASS_PANE -> ChameleonVariant.BATTLE_STAINED.getKey();
                    case Material.ENDER_PEARL -> ChameleonVariant.PANDORICA_STAINED.getKey();
                    case Material.LEATHER_HORSE_ARMOR -> ColouredVariant.TINTED_STAINED.getKey();
                    default -> new NamespacedKey((Plugin)this.plugin, BuilderUtility.getCustomModelPath(dye.toString()) + "_stained");
                };
                light.setBlockData(TARDISConstants.AIR);
            } else if (this.i % 4 == 1) {
                model = switch (dye) {
                    case Material.BLACK_DYE -> ChameleonVariant.BLACK_GLASS.getKey();
                    case Material.BLUE_DYE -> ChameleonVariant.BLUE_GLASS.getKey();
                    case Material.BROWN_DYE -> ChameleonVariant.BROWN_GLASS.getKey();
                    case Material.CYAN_DYE -> ChameleonVariant.CYAN_GLASS.getKey();
                    case Material.GRAY_DYE -> ChameleonVariant.GRAY_GLASS.getKey();
                    case Material.GREEN_DYE -> ChameleonVariant.GREEN_GLASS.getKey();
                    case Material.LIGHT_BLUE_DYE -> ChameleonVariant.LIGHT_BLUE_GLASS.getKey();
                    case Material.LIGHT_GRAY_DYE -> ChameleonVariant.LIGHT_GRAY_GLASS.getKey();
                    case Material.LIME_DYE -> ChameleonVariant.LIME_GLASS.getKey();
                    case Material.MAGENTA_DYE -> ChameleonVariant.MAGENTA_GLASS.getKey();
                    case Material.ORANGE_DYE -> ChameleonVariant.ORANGE_GLASS.getKey();
                    case Material.PINK_DYE -> ChameleonVariant.PINK_GLASS.getKey();
                    case Material.PURPLE_DYE -> ChameleonVariant.PURPLE_GLASS.getKey();
                    case Material.RED_DYE -> ChameleonVariant.RED_GLASS.getKey();
                    case Material.WHITE_DYE -> ChameleonVariant.WHITE_GLASS.getKey();
                    case Material.YELLOW_DYE -> ChameleonVariant.YELLOW_GLASS.getKey();
                    case Material.LEATHER_HORSE_ARMOR -> ColouredVariant.TINTED_GLASS.getKey();
                    case Material.CYAN_STAINED_GLASS_PANE -> ChameleonVariant.TENNANT_GLASS.getKey();
                    case Material.GRAY_STAINED_GLASS_PANE -> ChameleonVariant.WEEPING_ANGEL_GLASS.getKey();
                    case Material.GREEN_STAINED_GLASS_PANE -> ChameleonVariant.SIDRAT_GLASS.getKey();
                    case Material.RED_STAINED_GLASS_PANE -> ChameleonVariant.BATTLE_GLASS.getKey();
                    case Material.ENDER_PEARL -> ChameleonVariant.PANDORICA_GLASS.getKey();
                    default -> new NamespacedKey((Plugin)this.plugin, BuilderUtility.getCustomModelPath(dye.toString()) + "_glass");
                };
                light.setBlockData(TARDISConstants.AIR);
            } else {
                model = switch (dye) {
                    case Material.BLACK_DYE -> ChameleonVariant.BLACK_CLOSED.getKey();
                    case Material.BLUE_DYE -> ChameleonVariant.BLUE_CLOSED.getKey();
                    case Material.BROWN_DYE -> ChameleonVariant.BROWN_CLOSED.getKey();
                    case Material.CYAN_DYE -> ChameleonVariant.CYAN_CLOSED.getKey();
                    case Material.GRAY_DYE -> ChameleonVariant.GRAY_CLOSED.getKey();
                    case Material.GREEN_DYE -> ChameleonVariant.GREEN_CLOSED.getKey();
                    case Material.LIGHT_BLUE_DYE -> ChameleonVariant.LIGHT_BLUE_CLOSED.getKey();
                    case Material.LIGHT_GRAY_DYE -> ChameleonVariant.LIGHT_GRAY_CLOSED.getKey();
                    case Material.LIME_DYE -> ChameleonVariant.LIME_CLOSED.getKey();
                    case Material.MAGENTA_DYE -> ChameleonVariant.MAGENTA_CLOSED.getKey();
                    case Material.ORANGE_DYE -> ChameleonVariant.ORANGE_CLOSED.getKey();
                    case Material.PINK_DYE -> ChameleonVariant.PINK_CLOSED.getKey();
                    case Material.PURPLE_DYE -> ChameleonVariant.PURPLE_CLOSED.getKey();
                    case Material.RED_DYE -> ChameleonVariant.RED_CLOSED.getKey();
                    case Material.WHITE_DYE -> ChameleonVariant.WHITE_CLOSED.getKey();
                    case Material.YELLOW_DYE -> ChameleonVariant.YELLOW_CLOSED.getKey();
                    case Material.CYAN_STAINED_GLASS_PANE -> ChameleonVariant.TENNANT_CLOSED.getKey();
                    case Material.GRAY_STAINED_GLASS_PANE -> ChameleonVariant.WEEPING_ANGEL_CLOSED.getKey();
                    case Material.GREEN_STAINED_GLASS_PANE -> ChameleonVariant.SIDRAT_CLOSED.getKey();
                    case Material.RED_STAINED_GLASS_PANE -> ChameleonVariant.BATTLE_CLOSED.getKey();
                    case Material.ENDER_PEARL -> ChameleonVariant.PANDORICA_CLOSED.getKey();
                    case Material.LEATHER_HORSE_ARMOR -> ColouredVariant.TINTED_CLOSED.getKey();
                    default -> new NamespacedKey((Plugin)this.plugin, BuilderUtility.getCustomModelPath(dye.toString()) + "_closed");
                };
                Levelled levelled = TARDISConstants.LIGHT;
                levelled.setLevel(this.dd.getExteriorLampLevel());
                light.setBlockData((BlockData)levelled);
            }
            ++this.i;
            if (this.i == 1) {
                UUID uuid;
                ResultSetParticlePrefs rspp;
                Interaction interaction = TARDISDisplayItemUtils.getInteraction(this.dd.getLocation());
                if (interaction != null) {
                    interaction.remove();
                }
                boolean found = false;
                for (Entity e : world.getNearbyEntities(this.dd.getLocation(), 1.0, 1.0, 1.0)) {
                    ItemFrame f;
                    if (e instanceof ArmorStand) {
                        ArmorStand a;
                        this.stand = a = (ArmorStand)e;
                        found = true;
                        break;
                    }
                    if (!(e instanceof ItemFrame)) continue;
                    this.frame = f = (ItemFrame)e;
                    found = true;
                }
                if (!found || this.stand == null && this.frame != null) {
                    if (this.frame != null) {
                        this.frame.remove();
                    }
                    this.stand = (ArmorStand)world.spawnEntity(this.dd.getLocation().clone().add(0.5, 0.0, 0.5), EntityType.ARMOR_STAND);
                }
                this.stand.setRotation(this.dd.getDirection().getYaw(), 0.0f);
                this.is = ItemStack.of((Material)dye, (int)1);
                if (this.dd.isOutside()) {
                    ResultSetPlayerPrefs rsp = new ResultSetPlayerPrefs(this.plugin, this.dd.getPlayer().getUniqueId().toString());
                    boolean minecart = false;
                    SpaceTimeThrottle spaceTimeThrottle = SpaceTimeThrottle.NORMAL;
                    if (rsp.resultSet()) {
                        minecart = rsp.isMinecartOn();
                        spaceTimeThrottle = SpaceTimeThrottle.getByDelay().get(rsp.getThrottle());
                    }
                    if (!minecart) {
                        String sound = switch (spaceTimeThrottle) {
                            case SpaceTimeThrottle.WARP, SpaceTimeThrottle.RAPID, SpaceTimeThrottle.FASTER -> "tardis_takeoff_" + spaceTimeThrottle.toString().toLowerCase(Locale.ROOT);
                            default -> "tardis_takeoff";
                        };
                        TARDISSounds.playTARDISSound(this.dd.getLocation(), sound);
                    } else {
                        world.playSound(this.dd.getLocation(), Sound.ENTITY_MINECART_INSIDE, 1.0f, 0.0f);
                    }
                }
                if (this.dd.hasParticles() && (rspp = new ResultSetParticlePrefs(this.plugin)).fromUUID((uuid = this.dd.getPlayer().getUniqueId()).toString())) {
                    ParticleData data = rspp.getData();
                    Emitter emitter = new Emitter(this.plugin, uuid, this.dd.getLocation(), data, this.dd.getThrottle().getFlightTime());
                    int task = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)emitter, 0L, data.getShape().getPeriod());
                    emitter.setTaskID(task);
                }
            }
            if (this.is != null) {
                ItemMeta im = this.is.getItemMeta();
                im.setItemModel(model);
                this.is.setItemMeta(im);
                this.stand.getEquipment().setHelmet(this.is, true);
                this.stand.setInvulnerable(true);
                this.stand.setInvisible(true);
            }
        } else {
            this.plugin.getServer().getScheduler().cancelTask(this.task);
            this.task = 0;
            light.setBlockData(TARDISConstants.AIR);
            new InstantPresetDestroyer(this.plugin).instaDestroyPreset(this.dd, this.dd.isHide(), this.preset);
        }
    }

    public void setTask(int task) {
        this.task = task;
    }
}

