/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.resultset;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.enumeration.SmelterChest;
import me.eccentric_nz.TARDIS.rooms.smelter.Smelter;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Chest;
import org.bukkit.util.Vector;

public class ResultSetSmelter {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final String where;
    private final String prefix;
    private int smelter_id;
    private int tardis_id;
    private String location;
    private SmelterChest type;
    private List<Chest> fuelChests;
    private List<Chest> oreChests;

    public ResultSetSmelter(TARDIS plugin, String where) {
        this.plugin = plugin;
        this.where = where;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resultSet() {
        block17: {
            Statement statement = null;
            ResultSet rs = null;
            String query = "SELECT * FROM " + this.prefix + "vaults WHERE location = ? AND x = 0 AND y = 0 AND z = 0 AND chest_type != 'LIBRARY'";
            try {
                this.service.testConnection(this.connection);
                statement = this.connection.prepareStatement(query);
                statement.setString(1, this.where);
                rs = statement.executeQuery();
                if (rs.isBeforeFirst()) {
                    while (rs.next()) {
                        this.smelter_id = rs.getInt("v_id");
                        this.tardis_id = rs.getInt("tardis_id");
                        this.location = rs.getString("location");
                        this.type = SmelterChest.valueOf(rs.getString("chest_type"));
                        this.fuelChests = this.getChests(this.location, true);
                        this.oreChests = this.getChests(this.location, false);
                    }
                    break block17;
                }
                boolean bl = false;
                return bl;
            }
            catch (SQLException e) {
                this.plugin.debug("ResultSet error for smelter record! " + e.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException e) {
                    this.plugin.debug("Error closing smelter record! " + e.getMessage());
                }
            }
        }
        return true;
    }

    public SmelterChest getType() {
        return this.type;
    }

    public List<Chest> getFuelChests() {
        return this.fuelChests;
    }

    public List<Chest> getOreChests() {
        return this.oreChests;
    }

    private List<Chest> getChests(String location, boolean fuel) {
        Location l = TARDISStaticLocationGetters.getLocationFromBukkitString(location);
        int offset = l.getBlockY() - 68;
        ArrayList<Chest> chests = new ArrayList<Chest>();
        List<Vector> vectors = fuel ? Smelter.getFuelVectors() : Smelter.getOreVectors();
        vectors.forEach(v -> {
            Block b;
            if (offset > 0) {
                v.setY(4.0 - (double)offset);
            }
            if ((b = l.clone().add(v).getBlock()).getType().equals((Object)Material.CHEST) || b.getType().equals((Object)Material.TRAPPED_CHEST)) {
                Chest chest = (Chest)b.getState();
                chests.add(chest);
            }
        });
        return chests;
    }
}

