/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.resultset;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.database.data.Hidden;
import org.bukkit.Location;

public class ResultSetFindHidden {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final String prefix;
    private final List<Hidden> data = new ArrayList<Hidden>();

    public ResultSetFindHidden(TARDIS plugin) {
        this.plugin = plugin;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Hidden> search(Location location, int range) {
        int maxX = location.getBlockX() + range;
        int minX = location.getBlockX() - range;
        int maxZ = location.getBlockZ() + range;
        int minZ = location.getBlockZ() - range;
        Statement statement = null;
        ResultSet rs = null;
        String query = "SELECT " + this.prefix + "current.*, " + this.prefix + "tardis.hidden, " + this.prefix + "tardis.owner FROM " + this.prefix + "current, " + this.prefix + "tardis WHERE (" + this.prefix + "tardis.hidden = 1 OR " + this.prefix + "tardis.chameleon_preset = 'INVISIBLE') AND " + this.prefix + "current.world = '" + location.getWorld().getName() + "' AND " + this.prefix + "current.x < " + maxX + " AND " + this.prefix + "current.x > " + minX + " AND " + this.prefix + "current.z < " + maxZ + " AND " + this.prefix + "current.z > " + minZ + " AND " + this.prefix + "current.tardis_id = " + this.prefix + "tardis.tardis_id";
        try {
            this.service.testConnection(this.connection);
            statement = this.connection.prepareStatement(query);
            rs = statement.executeQuery();
            while (rs.next()) {
                String status = rs.getBoolean("hidden") ? "HIDDEN" : "INVISIBLE";
                this.data.add(new Hidden(rs.getString("owner"), status, rs.getInt("x"), rs.getInt("y"), rs.getInt("z")));
            }
        }
        catch (SQLException e) {
            this.plugin.debug("ResultSet error for find hidden! " + e.getMessage());
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing find hidden! " + e.getMessage());
            }
        }
        return this.data;
    }
}

