/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.resultset;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;

public class ResultSetBlueprint {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final String prefix;

    public ResultSetBlueprint(TARDIS plugin) {
        this.plugin = plugin;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getPerm(String uuid, String node) {
        Statement statement = null;
        ResultSet rs = null;
        String query = "SELECT * FROM " + this.prefix + "blueprint WHERE uuid = ? AND permission = ?";
        try {
            this.service.testConnection(this.connection);
            statement = this.connection.prepareStatement(query);
            statement.setString(1, uuid);
            statement.setString(2, node);
            rs = statement.executeQuery();
            boolean bl = rs.isBeforeFirst();
            return bl;
        }
        catch (SQLException e) {
            this.plugin.debug("ResultSet error for blueprint table! " + e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing blueprint table! " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRecordId(String uuid, String node) {
        Statement statement = null;
        ResultSet rs = null;
        String query = "SELECT bp_id FROM " + this.prefix + "blueprint WHERE uuid = ? AND permission = ?";
        try {
            this.service.testConnection(this.connection);
            statement = this.connection.prepareStatement(query);
            statement.setString(1, uuid);
            statement.setString(2, node);
            rs = statement.executeQuery();
            if (rs.isBeforeFirst()) {
                rs.next();
                int n = rs.getInt("bp_id");
                return n;
            }
            int n = -1;
            return n;
        }
        catch (SQLException e) {
            this.plugin.debug("ResultSet error for blueprint table! " + e.getMessage());
            int n = -1;
            return n;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing blueprint table! " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getRoomBlueprints(String uuid) {
        ArrayList<String> rooms = new ArrayList<String>();
        Statement statement = null;
        ResultSet rs = null;
        String query = "SELECT permission FROM " + this.prefix + "blueprint WHERE uuid = ? AND permission LIKE 'tardis.room.%'";
        try {
            this.service.testConnection(this.connection);
            statement = this.connection.prepareStatement(query);
            statement.setString(1, uuid);
            rs = statement.executeQuery();
            if (rs.isBeforeFirst()) {
                while (rs.next()) {
                    rooms.add(rs.getString("permission"));
                }
            }
        }
        catch (SQLException e) {
            this.plugin.debug("ResultSet error for blueprint table! " + e.getMessage());
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing blueprint table! " + e.getMessage());
            }
        }
        if (rooms.size() > 1) {
            Collections.sort(rooms);
        }
        return rooms;
    }
}

