/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.converters;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import org.bukkit.command.CommandSender;

public class SaveIconUpdate {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final String prefix;

    public SaveIconUpdate(TARDIS plugin) {
        this.plugin = plugin;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIcons() {
        Statement statement = null;
        Statement ps = null;
        ResultSet rs = null;
        try {
            this.service.testConnection(this.connection);
            statement = this.connection.createStatement();
            this.connection.setAutoCommit(false);
            String select = "SELECT dest_id, slot FROM " + this.prefix + "destinations";
            rs = statement.executeQuery(select);
            String query = "UPDATE " + this.prefix + "destinations SET icon = ? WHERE dest_id = ?";
            ps = this.connection.prepareStatement(query);
            int i = 0;
            while (rs.next()) {
                int slot = rs.getInt("slot");
                if (slot == -1) continue;
                ps.setString(1, TARDISConstants.GUI_IDS.get(slot).toString());
                ps.setInt(2, rs.getInt("dest_id"));
                ps.addBatch();
                ++i;
            }
            if (i > 0) {
                ps.executeBatch();
                this.connection.commit();
                this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Added " + i + " saved destination icons");
            }
        }
        catch (SQLException e) {
            this.plugin.debug("Update error for lowercase world name update! " + e.getMessage());
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
                this.connection.setAutoCommit(true);
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing lowercase world name update associated tables! " + e.getMessage());
            }
        }
    }
}

