/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;

public class InteractionStateSaver {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final String prefix;

    public InteractionStateSaver(TARDIS plugin) {
        this.plugin = plugin;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String which, int state, int id) {
        Statement statement = null;
        String query = "UPDATE " + this.prefix + "interactions SET state = ? WHERE tardis_id = ? AND control = ?";
        try {
            this.service.testConnection(this.connection);
            statement = this.connection.prepareStatement(query);
            statement.setInt(1, state);
            statement.setInt(2, id);
            statement.setString(3, which);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.debug("Update error for interactions state! " + e.getMessage());
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing interactions state! " + e.getMessage());
            }
        }
    }
}

