/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.control;

import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisID;
import me.eccentric_nz.TARDIS.desktop.PluginThemeInventory;
import me.eccentric_nz.TARDIS.desktop.UpgradeData;
import me.eccentric_nz.TARDIS.enumeration.Schematic;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.floodgate.FloodgateDestinationTerminalForm;
import me.eccentric_nz.TARDIS.floodgate.TARDISFloodgate;
import me.eccentric_nz.TARDIS.upgrades.SystemTree;
import me.eccentric_nz.TARDIS.upgrades.SystemUpgradeChecker;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TARDISThemeButton {
    private final TARDIS plugin;
    private final Player player;
    private final Schematic current_console;
    private final int level;
    private final int id;

    public TARDISThemeButton(TARDIS plugin, Player player, Schematic current_console, int level, int id) {
        this.plugin = plugin;
        this.player = player;
        this.current_console = current_console;
        this.level = level;
        this.id = id;
    }

    public static int getTardisId(String uuid) {
        int tid = 0;
        ResultSetTardisID rs = new ResultSetTardisID(TARDIS.plugin);
        if (rs.fromUUID(uuid)) {
            tid = rs.getTardisId();
        }
        return tid;
    }

    public void clickButton() {
        UUID uuid = this.player.getUniqueId();
        int p_tid = TARDISThemeButton.getTardisId(uuid.toString());
        if (p_tid != this.id) {
            this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "UPGRADE_OWN");
            return;
        }
        if (this.plugin.getTrackerKeeper().getIsGrowingRooms().contains(this.id)) {
            this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "NO_UPGRADE_WHILE_GROWING");
            return;
        }
        if (this.plugin.getConfig().getBoolean("difficulty.system_upgrades") && !new SystemUpgradeChecker(this.plugin).has(uuid.toString(), SystemTree.DESKTOP_THEME)) {
            this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "SYS_NEED", "Desktop Theme");
            return;
        }
        UpgradeData tud = new UpgradeData();
        tud.setPrevious(this.current_console);
        tud.setLevel(this.level);
        this.plugin.getTrackerKeeper().getUpgrades().put(uuid, tud);
        if (TARDISFloodgate.isFloodgateEnabled() && TARDISFloodgate.isBedrockPlayer(uuid)) {
            new FloodgateDestinationTerminalForm(this.plugin, uuid).send();
        } else {
            this.player.openInventory(new PluginThemeInventory(this.plugin, this.player, this.current_console.getPermission(), this.level).getInventory());
        }
    }
}

