/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.console;

import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.console.ConsoleInteraction;
import me.eccentric_nz.TARDIS.custommodels.keys.ConsolePart;
import me.eccentric_nz.TARDIS.custommodels.keys.DirectionVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.ModelledControl;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetPlayerPrefs;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Interaction;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ConsoleBuilder {
    private final TARDIS plugin;
    private UUID right;
    private UUID wxyz;

    public ConsoleBuilder(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void create(Block block, String colour, int id, String playerUuid) {
        float yaw;
        UUID uuid;
        String display;
        ItemMeta im;
        ItemStack shard;
        int i;
        StringBuilder builder = new StringBuilder();
        String prefix = "~";
        Block up = block.getRelative(BlockFace.UP);
        if (id > 0) {
            HashMap<String, Object> setb = new HashMap<String, Object>();
            setb.put("tardis_id", id);
            setb.put("uuid", TARDISStaticLocationGetters.makeLocationStr(block.getLocation()));
            setb.put("control", "CENTRE");
            setb.put("state", 0);
            this.plugin.getQueryFactory().doInsert("interactions", setb);
        }
        UUID centre = this.spawnCentreDisplay(up.getLocation(), colour);
        builder.append(centre);
        for (i = 0; i < 6; ++i) {
            shard = ItemStack.of((Material)Material.AMETHYST_SHARD);
            im = shard.getItemMeta();
            switch (colour) {
                case "console_rustic": {
                    im.setItemModel(ConsolePart.CONSOLE_RUSTIC.getKey());
                    break;
                }
                case "console_brown": {
                    im.setItemModel(ConsolePart.CONSOLE_BROWN.getKey());
                    break;
                }
                case "console_pink": {
                    im.setItemModel(ConsolePart.CONSOLE_PINK.getKey());
                    break;
                }
                case "console_magenta": {
                    im.setItemModel(ConsolePart.CONSOLE_MAGENTA.getKey());
                    break;
                }
                case "console_purple": {
                    im.setItemModel(ConsolePart.CONSOLE_PURPLE.getKey());
                    break;
                }
                case "console_blue": {
                    im.setItemModel(ConsolePart.CONSOLE_BLUE.getKey());
                    break;
                }
                case "console_light_blue": {
                    im.setItemModel(ConsolePart.CONSOLE_LIGHT_BLUE.getKey());
                    break;
                }
                case "console_light_gray": {
                    im.setItemModel(ConsolePart.CONSOLE_LIGHT_GRAY.getKey());
                    break;
                }
                case "console_cyan": {
                    im.setItemModel(ConsolePart.CONSOLE_CYAN.getKey());
                    break;
                }
                case "console_green": {
                    im.setItemModel(ConsolePart.CONSOLE_GREEN.getKey());
                    break;
                }
                case "console_lime": {
                    im.setItemModel(ConsolePart.CONSOLE_LIME.getKey());
                    break;
                }
                case "console_yellow": {
                    im.setItemModel(ConsolePart.CONSOLE_YELLOW.getKey());
                    break;
                }
                case "console_orange": {
                    im.setItemModel(ConsolePart.CONSOLE_ORANGE.getKey());
                    break;
                }
                case "console_red": {
                    im.setItemModel(ConsolePart.CONSOLE_RED.getKey());
                    break;
                }
                case "console_white": {
                    im.setItemModel(ConsolePart.CONSOLE_WHITE.getKey());
                    break;
                }
                case "console_black": {
                    im.setItemModel(ConsolePart.CONSOLE_BLACK.getKey());
                    break;
                }
                case "console_gray": {
                    im.setItemModel(ConsolePart.CONSOLE_GRAY.getKey());
                    break;
                }
                default: {
                    NamespacedKey side = new NamespacedKey((Plugin)this.plugin, colour.replace("_", "_side_"));
                    im.setItemModel(side);
                }
            }
            im.getPersistentDataContainer().set(this.plugin.getCustomBlockKey(), PersistentDataType.INTEGER, (Object)i);
            shard.setItemMeta(im);
            display = (ItemDisplay)block.getWorld().spawnEntity(up.getLocation().add(0.5, 0.25, 0.5), EntityType.ITEM_DISPLAY);
            display.setItemStack(shard);
            display.setItemDisplayTransform(ItemDisplay.ItemDisplayTransform.HEAD);
            uuid = display.getUniqueId();
            builder.append(prefix).append(uuid);
            display.getPersistentDataContainer().set(this.plugin.getInteractionUuidKey(), this.plugin.getPersistentDataTypeUUID(), (Object)uuid);
            display.setPersistent(true);
            display.setInvulnerable(true);
            yaw = (float)i * 60.0f;
            yaw = Location.normalizeYaw((float)yaw);
            display.setRotation(yaw, 0.0f);
        }
        for (i = 30; i < 360; i += 60) {
            shard = ItemStack.of((Material)Material.AMETHYST_SHARD);
            im = shard.getItemMeta();
            switch (colour) {
                case "console_rustic": {
                    im.setItemModel(ConsolePart.CONSOLE_DIVISION_RUSTIC.getKey());
                    break;
                }
                case "console_brown": {
                    im.setItemModel(ConsolePart.CONSOLE_DIVISION_BROWN.getKey());
                    break;
                }
                case "console_pink": {
                    im.setItemModel(ConsolePart.CONSOLE_DIVISION_PINK.getKey());
                    break;
                }
                case "console_magenta": {
                    im.setItemModel(ConsolePart.CONSOLE_DIVISION_MAGENTA.getKey());
                    break;
                }
                case "console_purple": {
                    im.setItemModel(ConsolePart.CONSOLE_DIVISION_PURPLE.getKey());
                    break;
                }
                case "console_blue": {
                    im.setItemModel(ConsolePart.CONSOLE_DIVISION_BLUE.getKey());
                    break;
                }
                case "console_light_blue": {
                    im.setItemModel(ConsolePart.CONSOLE_DIVISION_LIGHT_BLUE.getKey());
                    break;
                }
                case "console_light_gray": {
                    im.setItemModel(ConsolePart.CONSOLE_DIVISION_LIGHT_GRAY.getKey());
                    break;
                }
                case "console_cyan": {
                    im.setItemModel(ConsolePart.CONSOLE_DIVISION_CYAN.getKey());
                    break;
                }
                case "console_green": {
                    im.setItemModel(ConsolePart.CONSOLE_DIVISION_GREEN.getKey());
                    break;
                }
                case "console_lime": {
                    im.setItemModel(ConsolePart.CONSOLE_DIVISION_LIME.getKey());
                    break;
                }
                case "console_yellow": {
                    im.setItemModel(ConsolePart.CONSOLE_DIVISION_YELLOW.getKey());
                    break;
                }
                case "console_orange": {
                    im.setItemModel(ConsolePart.CONSOLE_DIVISION_ORANGE.getKey());
                    break;
                }
                case "console_red": {
                    im.setItemModel(ConsolePart.CONSOLE_DIVISION_RED.getKey());
                    break;
                }
                case "console_white": {
                    im.setItemModel(ConsolePart.CONSOLE_DIVISION_WHITE.getKey());
                    break;
                }
                case "console_black": {
                    im.setItemModel(ConsolePart.CONSOLE_DIVISION_BLACK.getKey());
                    break;
                }
                case "console_gray": {
                    im.setItemModel(ConsolePart.CONSOLE_DIVISION_GRAY.getKey());
                    break;
                }
                default: {
                    NamespacedKey division = new NamespacedKey((Plugin)this.plugin, colour.replace("_", "_division_"));
                    im.setItemModel(division);
                }
            }
            im.getPersistentDataContainer().set(this.plugin.getCustomBlockKey(), PersistentDataType.INTEGER, (Object)i);
            shard.setItemMeta(im);
            display = (ItemDisplay)block.getWorld().spawnEntity(up.getLocation().add(0.5, 0.25, 0.5), EntityType.ITEM_DISPLAY);
            display.setItemStack(shard);
            display.setItemDisplayTransform(ItemDisplay.ItemDisplayTransform.HEAD);
            uuid = display.getUniqueId();
            builder.append(prefix).append(uuid);
            display.getPersistentDataContainer().set(this.plugin.getInteractionUuidKey(), this.plugin.getPersistentDataTypeUUID(), (Object)uuid);
            display.setPersistent(true);
            display.setInvulnerable(true);
            yaw = Location.normalizeYaw((float)i);
            display.setRotation(yaw, 0.0f);
        }
        for (ConsoleInteraction i2 : ConsoleInteraction.values()) {
            uuid = this.spawnControl(i2, block.getLocation(), i2.getYaw(), id, playerUuid);
            double x = i2.getRelativePosition().getX();
            double z = i2.getRelativePosition().getZ();
            Location location = block.getLocation().clone().add(x, 0.75, z);
            Interaction interaction = (Interaction)location.getWorld().spawnEntity(location, EntityType.INTERACTION);
            interaction.getPersistentDataContainer().set(this.plugin.getInteractionUuidKey(), this.plugin.getPersistentDataTypeUUID(), (Object)interaction.getUniqueId());
            if (i2 == ConsoleInteraction.THROTTLE) {
                interaction.getPersistentDataContainer().set(this.plugin.getUnaryKey(), PersistentDataType.INTEGER, (Object)-1);
            }
            if (i2 == ConsoleInteraction.EXTERIOR_LAMP_LEVEL_SWITCH || i2 == ConsoleInteraction.INTERIOR_LIGHT_LEVEL_SWITCH) {
                interaction.getPersistentDataContainer().set(this.plugin.getUnaryKey(), PersistentDataType.INTEGER, (Object)1);
                if (id > 0) {
                    int cid = i2 == ConsoleInteraction.EXTERIOR_LAMP_LEVEL_SWITCH ? 49 : 50;
                    this.plugin.getQueryFactory().insertControl(id, cid, location.toString(), 0);
                }
            }
            if (i2 == ConsoleInteraction.HANDBRAKE && id > 0) {
                this.plugin.getQueryFactory().insertControl(id, 0, location.toString(), 0);
            }
            if (i2 == ConsoleInteraction.SCREEN_RIGHT || i2 == ConsoleInteraction.SCREEN_LEFT) {
                interaction.getPersistentDataContainer().set(this.plugin.getUnaryKey(), PersistentDataType.STRING, (Object)builder.toString());
            }
            interaction.getPersistentDataContainer().set(this.plugin.getModelUuidKey(), this.plugin.getPersistentDataTypeUUID(), (Object)uuid);
            interaction.setInteractionWidth(i2.getWidth());
            interaction.setInteractionHeight(i2.getHeight());
            interaction.setPersistent(true);
            interaction.setInvulnerable(true);
            if (id <= 0) continue;
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("tardis_id", id);
            data.put("uuid", interaction.getUniqueId());
            data.put("control", i2.toString());
            data.put("state", i2.getDefaultState());
            this.plugin.getQueryFactory().doInsert("interactions", data);
        }
    }

    private UUID spawnControl(ConsoleInteraction interaction, Location location, float angle, int id, String playerUuid) {
        ResultSetPlayerPrefs rsp;
        if (interaction == ConsoleInteraction.SCREEN_LEFT && this.right != null) {
            return this.right;
        }
        if ((interaction == ConsoleInteraction.X || interaction == ConsoleInteraction.Z || interaction == ConsoleInteraction.MULTIPLIER) && this.wxyz != null) {
            return this.wxyz;
        }
        Material material = interaction.getMaterial();
        NamespacedKey key = interaction.getCustomModel();
        if (interaction == ConsoleInteraction.DIRECTION && id > 0) {
            ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, id);
            NamespacedKey namespacedKey = key = rsc.resultSet() ? this.getKey(rsc.getCurrent().direction()) : DirectionVariant.DIRECTION_NORTH.getKey();
        }
        if ((interaction == ConsoleInteraction.THROTTLE || interaction == ConsoleInteraction.RELATIVITY_DIFFERENTIATOR) && (rsp = new ResultSetPlayerPrefs(this.plugin, playerUuid)).resultSet()) {
            key = interaction == ConsoleInteraction.THROTTLE ? ModelledControl.values()[70 + rsp.getThrottle()].getKey() : ModelledControl.values()[50 + rsp.getFlightMode()].getKey();
        }
        ItemStack is = ItemStack.of((Material)material);
        ItemMeta im = is.getItemMeta();
        im.setItemModel(key);
        im.getPersistentDataContainer().set(this.plugin.getCustomBlockKey(), PersistentDataType.STRING, (Object)key.getKey());
        is.setItemMeta(im);
        ItemDisplay display = (ItemDisplay)location.getWorld().spawnEntity(location.add(0.5, 1.25, 0.5), EntityType.ITEM_DISPLAY);
        display.setItemStack(is);
        display.setItemDisplayTransform(ItemDisplay.ItemDisplayTransform.HEAD);
        display.setPersistent(true);
        display.setInvulnerable(true);
        UUID uuid = display.getUniqueId();
        display.getPersistentDataContainer().set(this.plugin.getInteractionUuidKey(), this.plugin.getPersistentDataTypeUUID(), (Object)uuid);
        float yaw = Location.normalizeYaw((float)angle);
        display.setRotation(yaw, 0.0f);
        if (interaction == ConsoleInteraction.SCREEN_RIGHT) {
            this.right = uuid;
        }
        if (interaction == ConsoleInteraction.WORLD) {
            this.wxyz = uuid;
        }
        return uuid;
    }

    private NamespacedKey getKey(COMPASS direction) {
        return switch (direction) {
            case COMPASS.NORTH_EAST -> DirectionVariant.DIRECTION_NORTH_EAST.getKey();
            case COMPASS.EAST -> DirectionVariant.DIRECTION_EAST.getKey();
            case COMPASS.SOUTH_EAST -> DirectionVariant.DIRECTION_SOUTH_EAST.getKey();
            case COMPASS.SOUTH -> DirectionVariant.DIRECTION_SOUTH.getKey();
            case COMPASS.SOUTH_WEST -> DirectionVariant.DIRECTION_SOUTH_WEST.getKey();
            case COMPASS.WEST -> DirectionVariant.DIRECTION_WEST.getKey();
            case COMPASS.NORTH_WEST -> DirectionVariant.DIRECTION_NORTH_WEST.getKey();
            default -> DirectionVariant.DIRECTION_NORTH.getKey();
        };
    }

    private UUID spawnCentreDisplay(Location up, String type) {
        ItemStack shard = ItemStack.of((Material)Material.AMETHYST_SHARD);
        ItemMeta im = shard.getItemMeta();
        NamespacedKey model = switch (type) {
            case "console_rustic" -> ConsolePart.CONSOLE_CENTRE_RUSTIC.getKey();
            case "console_brown" -> ConsolePart.CONSOLE_CENTRE_BROWN.getKey();
            case "console_pink" -> ConsolePart.CONSOLE_CENTRE_PINK.getKey();
            case "console_magenta" -> ConsolePart.CONSOLE_CENTRE_MAGENTA.getKey();
            case "console_purple" -> ConsolePart.CONSOLE_CENTRE_PURPLE.getKey();
            case "console_blue" -> ConsolePart.CONSOLE_CENTRE_BLUE.getKey();
            case "console_light_blue" -> ConsolePart.CONSOLE_CENTRE_LIGHT_BLUE.getKey();
            case "console_light_gray" -> ConsolePart.CONSOLE_CENTRE_LIGHT_GRAY.getKey();
            case "console_cyan" -> ConsolePart.CONSOLE_CENTRE_CYAN.getKey();
            case "console_green" -> ConsolePart.CONSOLE_CENTRE_GREEN.getKey();
            case "console_lime" -> ConsolePart.CONSOLE_CENTRE_LIME.getKey();
            case "console_yellow" -> ConsolePart.CONSOLE_CENTRE_YELLOW.getKey();
            case "console_orange" -> ConsolePart.CONSOLE_CENTRE_ORANGE.getKey();
            case "console_red" -> ConsolePart.CONSOLE_CENTRE_RED.getKey();
            case "console_white" -> ConsolePart.CONSOLE_CENTRE_WHITE.getKey();
            case "console_black" -> ConsolePart.CONSOLE_CENTRE_BLACK.getKey();
            case "console_gray" -> ConsolePart.CONSOLE_CENTRE_GRAY.getKey();
            default -> new NamespacedKey((Plugin)this.plugin, type.replace("_", "_centre_"));
        };
        im.setItemModel(model);
        im.getPersistentDataContainer().set(this.plugin.getCustomBlockKey(), PersistentDataType.STRING, (Object)model.getKey());
        shard.setItemMeta(im);
        ItemDisplay display = (ItemDisplay)up.getWorld().spawnEntity(up.add(0.5, 0.25, 0.5), EntityType.ITEM_DISPLAY);
        display.setItemStack(shard);
        display.setItemDisplayTransform(ItemDisplay.ItemDisplayTransform.HEAD);
        UUID uuid = display.getUniqueId();
        display.getPersistentDataContainer().set(this.plugin.getInteractionUuidKey(), this.plugin.getPersistentDataTypeUUID(), (Object)uuid);
        display.setPersistent(true);
        display.setInvulnerable(true);
        return uuid;
    }
}

