/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.utils;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.commands.TARDISCompleter;
import me.eccentric_nz.TARDIS.commands.tardis.SaveIconCommand;
import me.eccentric_nz.TARDIS.commands.utils.ArgumentParser;
import me.eccentric_nz.TARDIS.commands.utils.Arguments;
import me.eccentric_nz.TARDIS.database.converters.WorldNameConverter;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.planets.RoomsWorld;
import me.eccentric_nz.TARDIS.planets.TARDISAcidWater;
import me.eccentric_nz.TARDIS.planets.TARDISAliasResolver;
import me.eccentric_nz.TARDIS.planets.TARDISGallifreySpawnListener;
import me.eccentric_nz.TARDIS.planets.TARDISSiluriaSpawnListener;
import me.eccentric_nz.TARDIS.planets.TARDISSkaroSpawnListener;
import me.eccentric_nz.TARDIS.planets.TARDISTelosSpawnListener;
import me.eccentric_nz.TARDIS.planets.TARDISVastialListener;
import me.eccentric_nz.TARDIS.planets.WorldLoader;
import me.eccentric_nz.TARDIS.utility.TARDISStringUtils;
import me.eccentric_nz.tardischunkgenerator.helpers.TARDISPlanetData;
import org.bukkit.GameMode;
import org.bukkit.GameRule;
import org.bukkit.GameRules;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.WorldType;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class TARDISWorldCommand
extends TARDISCompleter
implements CommandExecutor,
TabCompleter {
    private final TARDIS plugin;
    private final List<String> ROOT_SUBS = List.of("load", "unload", "enable", "disable", "gm", "rename", "update_name", "info", "dimensionicon");
    private final List<String> WORLD_SUBS = new ArrayList<String>();
    private final List<String> TYPE_SUBS = new ArrayList<String>();
    private final List<String> ENV_SUBS = new ArrayList<String>();
    private final List<String> GM_SUBS = new ArrayList<String>();
    private final List<String> PLANET_SUBS = List.of("gallifrey", "siluria", "skaro", "telos");

    public TARDISWorldCommand(TARDIS plugin) {
        this.plugin = plugin;
        this.WORLD_SUBS.addAll(plugin.getTardisAPI().getWorlds());
        for (WorldType worldType : WorldType.values()) {
            this.TYPE_SUBS.add(worldType.toString());
        }
        for (WorldType worldType : World.Environment.values()) {
            this.ENV_SUBS.add(worldType.toString());
        }
        for (WorldType worldType : GameMode.values()) {
            this.GM_SUBS.add(worldType.toString());
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("tardisworld")) {
            if (sender == null) {
                this.plugin.debug("Sender was null!");
                return true;
            }
            if (args.length < 1 || !this.ROOT_SUBS.contains(args[0])) {
                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "ARG_LOAD_UNLOAD");
                return false;
            }
            if (args[0].equalsIgnoreCase("dimensionicon")) {
                return new SaveIconCommand(this.plugin).changeIcon(sender, args);
            }
            if (args[0].equalsIgnoreCase("info") && sender instanceof Player) {
                Player player = (Player)sender;
                World world = player.getWorld();
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "WORLD_INFO", world.getName());
                this.plugin.getMessenger().message((CommandSender)player, "Gamemode -> " + this.plugin.getPlanetsConfig().getString("planets." + world.getName() + ".gamemode"));
                this.plugin.getMessenger().message((CommandSender)player, "Environment -> " + String.valueOf(world.getEnvironment()));
                this.plugin.getMessenger().message((CommandSender)player, "Generator -> " + this.plugin.getPlanetsConfig().getString("planets." + world.getName() + ".generator"));
                this.plugin.getMessenger().message((CommandSender)player, "Difficulty -> " + String.valueOf(world.getDifficulty()));
                this.plugin.getMessenger().message((CommandSender)player, "Gamerules -> ");
                for (String s : world.getGameRules()) {
                    GameRule rule = (GameRule)Registry.GAME_RULE.getOrThrow(NamespacedKey.minecraft((String)s.toLowerCase(Locale.ROOT)));
                    if (rule == null) continue;
                    this.plugin.getMessenger().message((CommandSender)player, "     " + s + " -> " + String.valueOf(world.getGameRuleValue(rule)));
                }
                this.plugin.getMessenger().message((CommandSender)player, "Spawn chunk radius -> " + this.plugin.getPlanetsConfig().getInt("planets." + world.getName() + ".spawn_chunk_radius"));
                this.plugin.getMessenger().message((CommandSender)player, "Time travel -> " + this.plugin.getPlanetsConfig().getString("planets." + world.getName() + ".time_travel"));
                return true;
            }
            if (args.length < 2) {
                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "TOO_FEW_ARGS");
                return false;
            }
            ArgumentParser parser = new ArgumentParser();
            String command = parser.join(args);
            Arguments arguments = parser.parse(command);
            if (args[0].equalsIgnoreCase("update_name")) {
                String world = arguments.getArguments().get(1).toLowerCase(Locale.ROOT);
                if (!this.PLANET_SUBS.contains(world)) {
                    this.plugin.getMessenger().sendColouredCommand(sender, "WORLD_NOT_FOUND", "/tardisworld load", this.plugin);
                    return true;
                }
                new WorldNameConverter(this.plugin, world).update();
                return true;
            }
            World world = TARDISAliasResolver.getWorldFromAlias(arguments.getArguments().get(1));
            if (world != null) {
                if (args[0].equalsIgnoreCase("disable")) {
                    if (!this.plugin.getPlanetsConfig().contains("planets." + arguments.getArguments().get(1))) {
                        this.plugin.getMessenger().sendColouredCommand(sender, "WORLD_NOT_FOUND", "/tardisworld load", this.plugin);
                        return true;
                    }
                    this.plugin.getPlanetsConfig().set("planets." + arguments.getArguments().get(1) + ".enabled", (Object)false);
                    this.plugin.savePlanetsConfig();
                    this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "WORLD_DISABLED", arguments.getArguments().get(1));
                    if (TARDISConstants.isTARDISPlanetExact(arguments.getArguments().get(1))) {
                        this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "WORLD_DISABLED_RESTART");
                    }
                    Location spawn = ((World)this.plugin.getServer().getWorlds().getFirst()).getSpawnLocation();
                    for (Player player : world.getPlayers()) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "WORLD_DISABLED_TELEPORT");
                        player.teleport(spawn);
                    }
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.plugin.getServer().unloadWorld(world, true), 5L);
                    return true;
                }
                if (args[0].equalsIgnoreCase("rename")) {
                    if (args.length < 3) {
                        this.plugin.getMessenger().sendColouredCommand(sender, "ARG_WORLD_RENAME", "/tardisworld rename [old name] [new name]", this.plugin);
                        return true;
                    }
                    List players = world.getPlayers();
                    Location spawn = ((World)this.plugin.getServer().getWorlds().getFirst()).getSpawnLocation();
                    players.forEach(p -> {
                        this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "WORLD_RENAME");
                        p.teleport(spawn);
                    });
                    this.plugin.getServer().unloadWorld(world, true);
                    this.plugin.getTardisHelper().setLevelName(arguments.getArguments().get(1), arguments.getArguments().get(2));
                    ConfigurationSection section = this.plugin.getPlanetsConfig().getConfigurationSection("planets." + arguments.getArguments().get(1));
                    if (section != null) {
                        Map map = section.getValues(true);
                        this.plugin.getPlanetsConfig().set("planets." + arguments.getArguments().get(2), (Object)map);
                        this.plugin.getPlanetsConfig().set("planets." + arguments.getArguments().get(1), null);
                        this.plugin.savePlanetsConfig();
                    }
                    new WorldLoader(this.plugin).loadWorld(arguments.getArguments().get(2));
                    this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "WORLD_RENAME_SUCCESS", arguments.getArguments().get(2));
                    return true;
                }
                if (args[0].equalsIgnoreCase("gm")) {
                    if (args.length == 3) {
                        try {
                            GameMode gm = GameMode.valueOf((String)arguments.getArguments().get(2).toUpperCase(Locale.ROOT));
                            this.plugin.getTardisHelper().setWorldGameMode(arguments.getArguments().get(1), gm);
                            this.plugin.getPlanetsConfig().set("planets." + arguments.getArguments().get(1) + ".gamemode", (Object)gm.toString());
                            this.plugin.savePlanetsConfig();
                            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "WORLD_GM_SET", arguments.getArguments().get(1), arguments.getArguments().get(2));
                            return true;
                        }
                        catch (IllegalArgumentException e) {
                            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "ARG_GM", arguments.getArguments().get(2));
                            return true;
                        }
                    }
                    TARDISPlanetData data = this.plugin.getTardisHelper().getLevelData(arguments.getArguments().get(1));
                    this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "WORLD_GM", data.gameMode().toString());
                    return true;
                }
                if (args[0].equalsIgnoreCase("load")) {
                    this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "WORLD_LOADED", arguments.getArguments().get(1));
                } else {
                    this.plugin.getServer().unloadWorld(world, true);
                    this.plugin.getPlanetsConfig().set("planets." + arguments.getArguments().get(1) + ".enabled", (Object)false);
                    this.plugin.getPlanetsConfig().set("planets." + arguments.getArguments().get(1) + ".time_travel", (Object)false);
                    this.plugin.savePlanetsConfig();
                    this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "WORLD_UNLOAD_SUCCESS", arguments.getArguments().get(1));
                }
            } else {
                if (args[0].equalsIgnoreCase("enable")) {
                    if (!this.plugin.getPlanetsConfig().contains("planets." + arguments.getArguments().get(1))) {
                        this.plugin.getMessenger().sendColouredCommand(sender, "WORLD_NOT_FOUND", "/tardisworld load", this.plugin);
                        return true;
                    }
                    this.plugin.getPlanetsConfig().set("planets." + arguments.getArguments().get(1) + ".enabled", (Object)true);
                    this.plugin.savePlanetsConfig();
                    this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "WORLD_ENABLED", arguments.getArguments().get(1));
                    if (TARDISConstants.isTARDISPlanetExact(arguments.getArguments().get(1))) {
                        switch (arguments.getArguments().get(1)) {
                            case "rooms": {
                                this.plugin.debug("Rooms world enabled, checking transmat location");
                                new RoomsWorld().check(this.plugin);
                                break;
                            }
                            case "gallifrey": {
                                this.plugin.debug("Gallifrey enabled, registering planet event listeners");
                                this.plugin.getPM().registerEvents((Listener)new TARDISGallifreySpawnListener(this.plugin), (Plugin)this.plugin);
                                this.plugin.getTardisHelper().addCustomBiome("gallifrey");
                                break;
                            }
                            case "siluria": {
                                this.plugin.debug("Siluria enabled, registering planet event listeners");
                                if (!this.plugin.getConfig().getBoolean("modules.weeping_angels")) break;
                                this.plugin.getPM().registerEvents((Listener)new TARDISSiluriaSpawnListener(this.plugin), (Plugin)this.plugin);
                                break;
                            }
                            case "skaro": {
                                this.plugin.debug("Skaro enabled, registering planet event listeners");
                                if (this.plugin.getPlanetsConfig().getBoolean("planets.skaro.acid")) {
                                    this.plugin.getPM().registerEvents((Listener)new TARDISAcidWater(this.plugin), (Plugin)this.plugin);
                                }
                                if (this.plugin.getConfig().getBoolean("modules.weeping_angels")) {
                                    this.plugin.getPM().registerEvents((Listener)new TARDISSkaroSpawnListener(this.plugin), (Plugin)this.plugin);
                                }
                                this.plugin.getTardisHelper().addCustomBiome("skaro");
                                break;
                            }
                            default: {
                                this.plugin.debug("Telos enabled, registering planet event listeners");
                                if (this.plugin.getPlanetsConfig().getBoolean("planets.telos.vastial.enabled")) {
                                    this.plugin.getPM().registerEvents((Listener)new TARDISVastialListener(this.plugin), (Plugin)this.plugin);
                                }
                                this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                                    if (this.plugin.getPlanetsConfig().getBoolean("planets.telos.twilight")) {
                                        World telos = this.plugin.getServer().getWorld("telos");
                                        if (telos != null) {
                                            telos.setTime(13000L);
                                            telos.setGameRule(GameRules.ADVANCE_TIME, (Object)false);
                                            this.plugin.getPlanetsConfig().set("planets.telos.gamerules.advance_time", (Object)false);
                                        }
                                    } else {
                                        this.plugin.getPlanetsConfig().set("planets.telos.gamerules.advance_time", (Object)true);
                                    }
                                    String planetsPath = String.valueOf(this.plugin.getDataFolder()) + File.separator + "planets.yml";
                                    try {
                                        this.plugin.getPlanetsConfig().save(new File(planetsPath));
                                    }
                                    catch (IOException iOException) {
                                        // empty catch block
                                    }
                                }, 300L);
                                if (!this.plugin.getConfig().getBoolean("modules.weeping_angels")) break;
                                this.plugin.getPM().registerEvents((Listener)new TARDISTelosSpawnListener(this.plugin), (Plugin)this.plugin);
                            }
                        }
                    }
                    new WorldLoader(this.plugin).loadWorld(arguments.getArguments().get(1));
                    return true;
                }
                if (args[0].equalsIgnoreCase("rename")) {
                    if (args.length < 3) {
                        this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "ARG_WORLD_RENAME");
                        return true;
                    }
                    this.plugin.getTardisHelper().setLevelName(arguments.getArguments().get(1), arguments.getArguments().get(2));
                    this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "WORLD_RENAME_SUCCESS", arguments.getArguments().get(2));
                    return true;
                }
                if (args[0].equalsIgnoreCase("gm")) {
                    this.plugin.getMessenger().sendColouredCommand(sender, "WORLD_NOT_FOUND", "/tardisworld load", this.plugin);
                    return true;
                }
                if (args[0].equalsIgnoreCase("load")) {
                    WorldType worldType = WorldType.NORMAL;
                    World.Environment environment = World.Environment.NORMAL;
                    String name = arguments.getArguments().get(1).toLowerCase(Locale.ROOT);
                    WorldCreator creator = new WorldCreator(name);
                    if (args.length > 2) {
                        try {
                            worldType = WorldType.valueOf((String)arguments.getArguments().get(2).toUpperCase(Locale.ROOT));
                        }
                        catch (IllegalArgumentException e) {
                            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "WORLD_TYPE", arguments.getArguments().get(2));
                            return true;
                        }
                    }
                    creator.type(worldType);
                    if (args.length > 3) {
                        try {
                            environment = World.Environment.valueOf((String)arguments.getArguments().get(3).toUpperCase(Locale.ROOT));
                        }
                        catch (IllegalArgumentException e) {
                            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "WORLD_ENV", arguments.getArguments().get(3));
                            return true;
                        }
                    }
                    creator.environment(environment);
                    if (args.length > 4) {
                        String[] split = arguments.getArguments().get(4).split(":", 2);
                        Plugin gen = this.plugin.getPM().getPlugin(split[0]);
                        if (gen == null) {
                            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "WORLD_GEN", arguments.getArguments().get(4));
                            return true;
                        }
                        creator.generator(arguments.getArguments().get(4));
                    }
                    if (creator.createWorld() == null) {
                        this.plugin.getMessenger().sendColouredCommand(sender, "WORLD_NOT_FOUND", "/tardisworld load", this.plugin);
                        return true;
                    }
                    this.plugin.getPlanetsConfig().set("planets." + name + ".enabled", (Object)true);
                    this.plugin.getPlanetsConfig().set("planets." + name + ".resource_pack", (Object)"default");
                    this.plugin.getPlanetsConfig().set("planets." + name + ".gamemode", (Object)"SURVIVAL");
                    this.plugin.getPlanetsConfig().set("planets." + name + ".time_travel", (Object)false);
                    this.plugin.getPlanetsConfig().set("planets." + name + ".world_type", (Object)worldType.toString());
                    this.plugin.getPlanetsConfig().set("planets." + name + ".environment", (Object)environment.toString());
                    this.plugin.getPlanetsConfig().set("planets." + name + ".spawn_chunk_radius", (Object)0);
                    this.plugin.getPlanetsConfig().set("planets." + name + ".spawn_other_mobs", (Object)true);
                    this.plugin.getPlanetsConfig().set("planets." + name + ".gamerules", List.of());
                    this.plugin.getPlanetsConfig().set("planets." + name + ".allow_portals", (Object)true);
                    this.plugin.getPlanetsConfig().set("planets." + name + ".alias", (Object)TARDISStringUtils.uppercaseFirst(name));
                    this.plugin.getPlanetsConfig().set("planets." + name + ".icon", (Object)(switch (environment) {
                        case World.Environment.NETHER -> "NETHERRACK";
                        case World.Environment.THE_END -> "END_STONE";
                        default -> "STONE";
                    }));
                    this.plugin.getPlanetsConfig().set("planets." + name + ".helmic_regulator_order", (Object)-1);
                    if (!TARDISConstants.isTARDISPlanetExact(name)) {
                        this.plugin.getPlanetsConfig().set("planets." + name + ".generator", (Object)(args.length > 4 ? arguments.getArguments().get(4) : "DEFAULT"));
                    }
                    this.plugin.savePlanetsConfig();
                } else {
                    this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "WORLD_UNLOADED", arguments.getArguments().get(1));
                }
            }
            return true;
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        String lastArg = args[args.length - 1];
        if (args.length == 1) {
            List<String> part = this.partial(args[0], this.ROOT_SUBS);
            return !part.isEmpty() ? part : null;
        }
        if (args.length == 2) {
            if (args[0].equalsIgnoreCase("enable") || args[0].equalsIgnoreCase("disable") || args[0].equalsIgnoreCase("update_name")) {
                return this.partial(lastArg, this.PLANET_SUBS);
            }
            return this.partial(lastArg, this.WORLD_SUBS);
        }
        if (args.length == 3) {
            if (args[0].equalsIgnoreCase("gm")) {
                return this.partial(lastArg, this.GM_SUBS);
            }
            return this.partial(lastArg, this.TYPE_SUBS);
        }
        if (args.length == 4) {
            return this.partial(lastArg, this.ENV_SUBS);
        }
        return ImmutableList.of();
    }
}

