/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.travel;

import java.util.HashMap;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.advanced.CircuitChecker;
import me.eccentric_nz.TARDIS.advanced.CircuitDamager;
import me.eccentric_nz.TARDIS.api.Parameters;
import me.eccentric_nz.TARDIS.api.event.TARDISTravelEvent;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.enumeration.DiskCircuit;
import me.eccentric_nz.TARDIS.enumeration.Flag;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.enumeration.TravelType;
import me.eccentric_nz.TARDIS.flight.TARDISLand;
import me.eccentric_nz.TARDIS.travel.TARDISStructureLocation;
import me.eccentric_nz.TARDIS.travel.TARDISStructureTravel;
import me.eccentric_nz.TARDIS.travel.TravelCostAndType;
import me.eccentric_nz.TARDIS.upgrades.SystemTree;
import me.eccentric_nz.TARDIS.upgrades.SystemUpgradeChecker;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class StructureCommand {
    private final TARDIS plugin;

    public StructureCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    public boolean action(Player player, String[] args, int id) {
        TARDISStructureLocation randomStructure;
        if (!this.plugin.getConfig().getBoolean("allow.village_travel")) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TRAVEL_NO_VILLAGE");
            return true;
        }
        if (!TARDISPermission.hasPermission(player, "tardis.timetravel.village")) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TRAVEL_NO_PERM_VILLAGE");
            return true;
        }
        if (this.plugin.getConfig().getBoolean("difficulty.system_upgrades") && !new SystemUpgradeChecker(this.plugin).has(player.getUniqueId().toString(), SystemTree.TELEPATHIC_CIRCUIT)) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SYS_NEED", "Telepathic Circuit");
            return true;
        }
        CircuitChecker tcc = new CircuitChecker(this.plugin, id);
        tcc.getCircuits();
        if (this.plugin.getConfig().getBoolean("difficulty.circuits") && !this.plugin.getUtils().inGracePeriod(player, true) && !tcc.hasTelepathic()) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_TELEPATHIC_CIRCUIT");
            return true;
        }
        if (this.plugin.getConfig().getBoolean("circuits.damage") && this.plugin.getConfig().getInt("circuits.uses.telepathic") > 0) {
            int uses_left = tcc.getTelepathicUses();
            new CircuitDamager(this.plugin, DiskCircuit.TELEPATHIC, uses_left, id, player).damage();
        }
        if ((randomStructure = new TARDISStructureTravel(this.plugin).getRandom(player, id, args)) == null) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "VILLAGE_NOT_FOUND");
            return true;
        }
        Location village = randomStructure.getLocation();
        if (!this.plugin.getPluginRespect().getRespect(village, new Parameters(player, Flag.getDefaultFlags()))) {
            if (this.plugin.getConfig().getBoolean("travel.no_destination_malfunctions")) {
                this.plugin.getTrackerKeeper().getMalfunction().put(id, true);
            } else {
                return true;
            }
        }
        HashMap<String, Object> set = new HashMap<String, Object>();
        set.put("world", village.getWorld().getName());
        set.put("x", village.getBlockX());
        set.put("y", village.getBlockY());
        set.put("z", village.getBlockZ());
        set.put("submarine", 0);
        TravelType travelType = switch (village.getWorld().getEnvironment()) {
            case World.Environment.THE_END -> TravelType.VILLAGE_THE_END;
            case World.Environment.NETHER -> TravelType.VILLAGE_NETHER;
            default -> TravelType.VILLAGE_OVERWORLD;
        };
        HashMap<String, Object> tid = new HashMap<String, Object>();
        tid.put("tardis_id", id);
        this.plugin.getQueryFactory().doSyncUpdate("next", set, tid);
        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TRAVEL_LOADED", randomStructure.getWhich(), !this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(id));
        this.plugin.getTrackerKeeper().getHasDestination().put(id, new TravelCostAndType(this.plugin.getArtronConfig().getInt("travel"), travelType));
        this.plugin.getTrackerKeeper().getRescue().remove(id);
        if (this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(id)) {
            new TARDISLand(this.plugin, id, player).exitVortex();
            this.plugin.getPM().callEvent((Event)new TARDISTravelEvent(player, null, travelType, id));
        }
        return true;
    }
}

