/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.travel;

import java.util.HashMap;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.api.event.TARDISTravelEvent;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetAreas;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.enumeration.TravelType;
import me.eccentric_nz.TARDIS.flight.TARDISLand;
import me.eccentric_nz.TARDIS.travel.TravelCostAndType;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class AreaCommand {
    private final TARDIS plugin;

    public AreaCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    public boolean action(Player player, String[] args, int id, ChameleonPreset preset) {
        Location l;
        HashMap<String, Object> wherea = new HashMap<String, Object>();
        wherea.put("area_name", args[1]);
        ResultSetAreas rsa = new ResultSetAreas(this.plugin, wherea, false, false);
        if (!rsa.resultSet()) {
            this.plugin.getMessenger().sendColouredCommand((CommandSender)player, "AREA_NOT_FOUND", "/tardis list areas", this.plugin);
            return true;
        }
        if (!TARDISPermission.hasPermission(player, "tardis.area." + args[1]) && !TARDISPermission.hasPermission(player, "tardis.area.*") || !player.isPermissionSet("tardis.area." + args[1]) && !player.isPermissionSet("tardis.area.*")) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TRAVEL_NO_AREA_PERM", args[1]);
            return true;
        }
        if (this.plugin.getConfig().getBoolean("difficulty.disks") && !this.plugin.getUtils().inGracePeriod(player, false)) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ADV_AREA");
            return true;
        }
        String invisibility = rsa.getArea().invisibility();
        if (invisibility.equals("DENY") && preset.equals((Object)ChameleonPreset.INVISIBLE)) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "AREA_NO_INVISIBLE");
            return true;
        }
        if (!invisibility.equals("ALLOW")) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "AREA_FORCE_PRESET", invisibility);
            HashMap<String, Object> wherei = new HashMap<String, Object>();
            wherei.put("tardis_id", id);
            HashMap<String, Object> seti = new HashMap<String, Object>();
            seti.put("chameleon_preset", invisibility);
            seti.put("adapti_on", 0);
            this.plugin.getQueryFactory().doSyncUpdate("tardis", seti, wherei);
        }
        if ((l = rsa.getArea().grid() ? this.plugin.getTardisArea().getNextSpot(rsa.getArea().areaName()) : this.plugin.getTardisArea().getSemiRandomLocation(rsa.getArea().areaId())) == null) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_MORE_SPOTS");
            return true;
        }
        HashMap<String, Object> set = new HashMap<String, Object>();
        set.put("world", l.getWorld().getName());
        set.put("x", l.getBlockX());
        set.put("y", l.getBlockY());
        set.put("z", l.getBlockZ());
        if (!rsa.getArea().direction().isEmpty()) {
            set.put("direction", rsa.getArea().direction());
        } else {
            ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, id);
            if (!rsc.resultSet()) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CURRENT_NOT_FOUND");
                return true;
            }
            set.put("direction", rsc.getCurrent().direction().forPreset().toString());
        }
        set.put("submarine", 0);
        HashMap<String, Object> tid = new HashMap<String, Object>();
        tid.put("tardis_id", id);
        this.plugin.getQueryFactory().doSyncUpdate("next", set, tid);
        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TRAVEL_APPROVED", args[1]);
        this.plugin.getTrackerKeeper().getHasDestination().put(id, new TravelCostAndType(this.plugin.getArtronConfig().getInt("travel"), TravelType.AREA));
        this.plugin.getTrackerKeeper().getRescue().remove(id);
        if (this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(id)) {
            new TARDISLand(this.plugin, id, player).exitVortex();
            this.plugin.getPM().callEvent((Event)new TARDISTravelEvent(player, null, TravelType.AREA, id));
        }
        return true;
    }
}

