/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.tardis;

import java.util.HashMap;
import java.util.UUID;
import java.util.regex.Pattern;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

class RemoveCompanionCommand {
    private static final Pattern LETTERS_NUMBERS = Pattern.compile("[A-Za-z0-9_*.]{2,16}");
    private final TARDIS plugin;

    RemoveCompanionCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean doRemoveCompanion(Player player, String[] args) {
        if (!TARDISPermission.hasPermission(player, "tardis.add")) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_PERMS");
            return false;
        }
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("uuid", player.getUniqueId().toString());
        ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
        if (!rs.resultSet()) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_TARDIS");
            return false;
        }
        Tardis tardis = rs.getTardis();
        String comps = tardis.getCompanions();
        if (comps == null || comps.isEmpty()) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "COMPANIONS_NONE");
            return true;
        }
        int id = tardis.getTardisId();
        String data = tardis.getChunk();
        String owner = tardis.getOwner();
        if (args.length < 2) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TOO_FEW_ARGS");
            return false;
        }
        if (!LETTERS_NUMBERS.matcher(args[1]).matches()) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "PLAYER_NOT_VALID");
            return true;
        }
        String newList = "";
        String message = "COMPANIONS_REMOVE_ALL";
        if (!args[1].equals("all")) {
            World w;
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)args[1]);
            if (offlinePlayer.getName() == null) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "COULD_NOT_FIND_NAME");
                return true;
            }
            UUID oluuid = offlinePlayer.getUniqueId();
            String[] split = comps.split(":");
            StringBuilder sb = new StringBuilder();
            if (split.length > 1) {
                for (String c : split) {
                    if (c.equals(oluuid.toString())) continue;
                    sb.append(c).append(":");
                }
                if (!sb.isEmpty()) {
                    newList = sb.substring(0, sb.length() - 1);
                }
            }
            message = "COMPANIONS_REMOVE_ONE";
            if (this.plugin.isWorldGuardOnServer() && this.plugin.getConfig().getBoolean("preferences.use_worldguard") && (w = TARDISStaticLocationGetters.getWorldFromSplitString(data)) != null) {
                this.plugin.getWorldGuardUtils().removeMemberFromRegion(w, owner, oluuid);
            }
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, message, args[1]);
        } else {
            World w;
            if (this.plugin.isWorldGuardOnServer() && this.plugin.getConfig().getBoolean("preferences.use_worldguard") && (w = TARDISStaticLocationGetters.getWorldFromSplitString(data)) != null && args[1].equals("all")) {
                this.plugin.getWorldGuardUtils().removeAllMembersFromRegion(w, owner, player.getUniqueId());
                this.plugin.getWorldGuardUtils().setEntryExitFlags(w.getName(), player.getName(), false);
            }
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, message);
        }
        HashMap<String, Object> tid = new HashMap<String, Object>();
        HashMap<String, Object> set = new HashMap<String, Object>();
        tid.put("tardis_id", id);
        set.put("companions", newList);
        this.plugin.getQueryFactory().doUpdate("tardis", set, tid);
        return true;
    }
}

