/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.tardis;

import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.advanced.CircuitChecker;
import me.eccentric_nz.TARDIS.advanced.CircuitDamager;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.builders.exterior.BuildData;
import me.eccentric_nz.TARDIS.database.data.Current;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTravellers;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.enumeration.DiskCircuit;
import me.eccentric_nz.TARDIS.enumeration.SpaceTimeThrottle;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class RebuildCommand {
    private final TARDIS plugin;

    public RebuildCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    public boolean rebuildPreset(OfflinePlayer player) {
        if (TARDISPermission.hasPermission(player, "tardis.rebuild")) {
            int rebuild;
            UUID uuid = player.getUniqueId();
            if (this.plugin.getTrackerKeeper().getRebuildCooldown().containsKey(uuid)) {
                long now = System.currentTimeMillis();
                long cooldown = this.plugin.getConfig().getLong("police_box.rebuild_cooldown");
                long then = this.plugin.getTrackerKeeper().getRebuildCooldown().get(uuid) + cooldown;
                if (now < then) {
                    this.plugin.getMessenger().send((CommandSender)player.getPlayer(), TardisModule.TARDIS, "COOLDOWN", String.format("%d", cooldown / 1000L));
                    return true;
                }
            }
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("uuid", uuid.toString());
            ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
            if (!rs.resultSet()) {
                this.plugin.getMessenger().send((CommandSender)player.getPlayer(), TardisModule.TARDIS, "NO_TARDIS");
                return true;
            }
            Tardis tardis = rs.getTardis();
            if (this.plugin.getConfig().getBoolean("allow.power_down") && !tardis.isPoweredOn()) {
                this.plugin.getMessenger().send((CommandSender)player.getPlayer(), TardisModule.TARDIS, "POWER_DOWN");
                return true;
            }
            if (tardis.getPreset().equals((Object)ChameleonPreset.INVISIBLE) && tardis.getDemat().equals((Object)ChameleonPreset.INVISIBLE)) {
                this.plugin.getMessenger().send((CommandSender)player.getPlayer(), TardisModule.TARDIS, "INVISIBILITY_ENGAGED");
                return true;
            }
            int id = tardis.getTardisId();
            CircuitChecker tcc = new CircuitChecker(this.plugin, id);
            tcc.getCircuits();
            if (this.plugin.getConfig().getBoolean("difficulty.circuits") && !this.plugin.getUtils().inGracePeriod(player.getPlayer(), true) && !tcc.hasMaterialisation()) {
                this.plugin.getMessenger().send((CommandSender)player.getPlayer(), TardisModule.TARDIS, "NO_MAT_CIRCUIT");
                return true;
            }
            if (this.plugin.getConfig().getBoolean("circuits.damage") && this.plugin.getConfig().getInt("circuits.uses.materialisation") > 0) {
                int uses_left = tcc.getMaterialisationUses();
                new CircuitDamager(this.plugin, DiskCircuit.MATERIALISATION, uses_left, id, player.getPlayer()).damage();
            }
            HashMap<String, Object> wherein = new HashMap<String, Object>();
            wherein.put("uuid", uuid.toString());
            ResultSetTravellers rst = new ResultSetTravellers(this.plugin, wherein, false);
            if (rst.resultSet() && this.plugin.getTrackerKeeper().getHasDestination().containsKey(id)) {
                this.plugin.getMessenger().send((CommandSender)player.getPlayer(), TardisModule.TARDIS, "TARDIS_NO_REBUILD");
                return true;
            }
            if (this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(id)) {
                this.plugin.getMessenger().send((CommandSender)player.getPlayer(), TardisModule.TARDIS, "NOT_IN_VORTEX");
                return true;
            }
            if (this.plugin.getTrackerKeeper().getInVortex().contains(id) || this.plugin.getTrackerKeeper().getMaterialising().contains(id) || this.plugin.getTrackerKeeper().getDematerialising().contains(id)) {
                this.plugin.getMessenger().send((CommandSender)player.getPlayer(), TardisModule.TARDIS, "NOT_WHILE_MAT");
                return true;
            }
            if (this.plugin.getTrackerKeeper().getDispersed().containsKey(uuid)) {
                this.plugin.getMessenger().send((CommandSender)player.getPlayer(), TardisModule.TARDIS, "NOT_WHILE_DISPERSED");
                return true;
            }
            ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, id);
            if (!rsc.resultSet()) {
                this.plugin.getMessenger().send((CommandSender)player.getPlayer(), TardisModule.TARDIS, "CURRENT_NOT_FOUND");
                this.plugin.getMessenger().sendColouredCommand((CommandSender)player.getPlayer(), "REBUILD_FAIL", "/tardis comehere", this.plugin);
                return true;
            }
            int level = tardis.getArtronLevel();
            if (level < (rebuild = this.plugin.getArtronConfig().getInt("random"))) {
                this.plugin.getMessenger().send((CommandSender)player.getPlayer(), TardisModule.TARDIS, "ENERGY_NO_REBUILD");
                return false;
            }
            this.plugin.getTrackerKeeper().getRebuildCooldown().put(uuid, System.currentTimeMillis());
            Current current = rsc.getCurrent();
            BuildData bd = new BuildData(uuid.toString());
            bd.setDirection(current.direction());
            bd.setLocation(current.location());
            bd.setMalfunction(false);
            bd.setOutside(false);
            bd.setPlayer(player);
            bd.setRebuild(true);
            bd.setSubmarine(current.submarine());
            bd.setTardisID(id);
            bd.setThrottle(SpaceTimeThrottle.REBUILD);
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                this.plugin.getTrackerKeeper().getDematerialising().add(id);
                this.plugin.getPresetBuilder().buildPreset(bd);
                this.plugin.getTrackerKeeper().getInVortex().add(id);
            }, 10L);
            this.plugin.getMessenger().send((CommandSender)player.getPlayer(), TardisModule.TARDIS, "TARDIS_REBUILT");
            HashMap<String, Object> wheret = new HashMap<String, Object>();
            wheret.put("tardis_id", id);
            this.plugin.getQueryFactory().alterEnergyLevel("tardis", -rebuild, wheret, player.getPlayer());
            if (tardis.isHidden()) {
                HashMap<String, Object> whereh = new HashMap<String, Object>();
                whereh.put("tardis_id", id);
                HashMap<String, Object> seth = new HashMap<String, Object>();
                seth.put("hidden", 0);
                this.plugin.getQueryFactory().doUpdate("tardis", seth, whereh);
            }
            return true;
        }
        this.plugin.getMessenger().send((CommandSender)player.getPlayer(), TardisModule.TARDIS, "NO_PERMS");
        return false;
    }
}

