/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.dev;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.util.Locale;
import java.util.Map;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.custommodels.GUIArchive;
import me.eccentric_nz.TARDIS.custommodels.GUIArs;
import me.eccentric_nz.TARDIS.custommodels.GUIArtronStorage;
import me.eccentric_nz.TARDIS.custommodels.GUIAutonomous;
import me.eccentric_nz.TARDIS.custommodels.GUIChameleon;
import me.eccentric_nz.TARDIS.custommodels.GUIChameleonConstructor;
import me.eccentric_nz.TARDIS.custommodels.GUIChameleonHelp;
import me.eccentric_nz.TARDIS.custommodels.GUIChameleonPoliceBoxes;
import me.eccentric_nz.TARDIS.custommodels.GUIChameleonPresets;
import me.eccentric_nz.TARDIS.custommodels.GUIChameleonTemplate;
import me.eccentric_nz.TARDIS.custommodels.GUIChemistry;
import me.eccentric_nz.TARDIS.custommodels.GUICompanion;
import me.eccentric_nz.TARDIS.custommodels.GUIControlCentre;
import me.eccentric_nz.TARDIS.custommodels.GUIData;
import me.eccentric_nz.TARDIS.custommodels.GUIFarming;
import me.eccentric_nz.TARDIS.custommodels.GUIGeneticManipulator;
import me.eccentric_nz.TARDIS.custommodels.GUIInteriorSounds;
import me.eccentric_nz.TARDIS.custommodels.GUIKeyPreferences;
import me.eccentric_nz.TARDIS.custommodels.GUILights;
import me.eccentric_nz.TARDIS.custommodels.GUIMap;
import me.eccentric_nz.TARDIS.custommodels.GUIParticle;
import me.eccentric_nz.TARDIS.custommodels.GUISavedPrograms;
import me.eccentric_nz.TARDIS.custommodels.GUISaves;
import me.eccentric_nz.TARDIS.custommodels.GUISonicActivator;
import me.eccentric_nz.TARDIS.custommodels.GUISonicConfigurator;
import me.eccentric_nz.TARDIS.custommodels.GUISonicGenerator;
import me.eccentric_nz.TARDIS.custommodels.GUISonicPreferences;
import me.eccentric_nz.TARDIS.custommodels.GUITelevision;
import me.eccentric_nz.TARDIS.custommodels.GUITemporalLocator;
import me.eccentric_nz.TARDIS.custommodels.GUITransmat;
import me.eccentric_nz.TARDIS.custommodels.GUIUpgrade;
import me.eccentric_nz.TARDIS.custommodels.GUIWallFloor;
import me.eccentric_nz.TARDIS.custommodels.GUIWeather;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.meta.ItemMeta;

public class ResourcePackConverterCommand {
    private final TARDIS plugin;
    private Gson gson;

    public ResourcePackConverterCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    private static String uppercaseFirst(String s) {
        if (s.equalsIgnoreCase("ii") || s.equalsIgnoreCase("iii") || s.equalsIgnoreCase("iv")) {
            return s.toUpperCase(Locale.ROOT);
        }
        return s.substring(0, 1).toUpperCase(Locale.ROOT) + s.substring(1).toLowerCase(Locale.ROOT).replace("tardis", "TARDIS");
    }

    /*
     * WARNING - void declaration
     */
    public void process(CommandSender sender, String[] args) {
        this.gson = new GsonBuilder().setPrettyPrinting().create();
        if (args.length > 2) {
            File[] fileArray = new File(String.valueOf(this.plugin.getDataFolder()) + File.separator + "component").listFiles();
            if (fileArray != null) {
                void var6_78;
                File[] fileArray2 = fileArray;
                int n = fileArray2.length;
                boolean bl = false;
                while (var6_78 < n) {
                    File child = fileArray2[var6_78];
                    if (!child.isDirectory() && child.getName().endsWith(".json")) {
                        try {
                            JsonReader reader = new JsonReader((Reader)new FileReader(child));
                            JsonObject root = JsonParser.parseReader((JsonReader)reader).getAsJsonObject();
                            JsonObject model = root.get("model").getAsJsonObject();
                            JsonObject select = new JsonObject();
                            select.addProperty("type", "minecraft:select");
                            select.addProperty("property", "component");
                            select.addProperty("component", "minecraft:custom_name");
                            JsonObject fallback = new JsonObject();
                            fallback.addProperty("type", "minecraft:model");
                            String name = this.hasEntry(child.getName()) ? this.getEntry(child.getName()) : this.convertFilename(child.getName());
                            String material = this.getMaterial(name);
                            fallback.addProperty("model", "minecraft:item/" + material);
                            select.add("fallback", (JsonElement)fallback);
                            JsonArray cases = new JsonArray();
                            JsonObject matcher = new JsonObject();
                            JsonObject when = new JsonObject();
                            when.addProperty("text", "");
                            JsonArray extra = new JsonArray();
                            JsonObject conditions = new JsonObject();
                            conditions.addProperty("bold", Boolean.valueOf(false));
                            conditions.addProperty("color", "white");
                            conditions.addProperty("italic", Boolean.valueOf(false));
                            conditions.addProperty("obfuscated", Boolean.valueOf(false));
                            conditions.addProperty("strikethrough", Boolean.valueOf(false));
                            conditions.addProperty("text", name);
                            conditions.addProperty("underlined", Boolean.valueOf(false));
                            extra.add((JsonElement)conditions);
                            when.add("extra", (JsonElement)extra);
                            matcher.add("when", (JsonElement)when);
                            matcher.add("model", (JsonElement)model);
                            cases.add((JsonElement)matcher);
                            select.add("cases", (JsonElement)cases);
                            String output = String.valueOf(this.plugin.getDataFolder()) + File.separator + "component" + File.separator + "processed" + File.separator + material + "_" + child.getName();
                            File file = new File(output);
                            try (FileWriter writer = new FileWriter(file);){
                                this.gson.toJson((JsonElement)select, (Appendable)writer);
                            }
                            catch (IOException e) {
                                sender.sendMessage("File write error for " + child.getName());
                                sender.sendMessage(e.getMessage());
                            }
                        }
                        catch (FileNotFoundException e) {
                            sender.sendMessage("File read error for " + child.getName());
                        }
                    }
                    ++var6_78;
                }
            }
        } else {
            int n;
            ShapedRecipe sr;
            for (Map.Entry<String, ShapedRecipe> entry : this.plugin.getTardisAPI().getShapedRecipes().entrySet()) {
                sr = entry.getValue();
                ItemStack itemStack = sr.getResult();
                this.writeFile(sender, itemStack);
            }
            for (Map.Entry<String, ShapelessRecipe> entry : this.plugin.getTardisAPI().getShapelessRecipes().entrySet()) {
                sr = entry.getValue();
                ItemStack itemStack = sr.getResult();
                this.writeFile(sender, itemStack);
            }
            Field[] fieldArray = GUIArchive.class.getDeclaredFields();
            int n2 = fieldArray.length;
            for (n = 0; n < n2; ++n) {
                Field field = fieldArray[n];
                this.writeFromField(sender, field);
            }
            Field[] fieldArray2 = GUIChameleonPoliceBoxes.class.getDeclaredFields();
            int n3 = fieldArray2.length;
            for (n = 0; n < n3; ++n) {
                Field field = fieldArray2[n];
                this.writeFromField(sender, field);
            }
            GUIFarming[] gUIFarmingArray = GUIFarming.values();
            int n4 = gUIFarmingArray.length;
            for (n = 0; n < n4; ++n) {
                GUIFarming gUIFarming = gUIFarmingArray[n];
                if (gUIFarming.getModel() == null) continue;
                this.writeShortFile(sender, gUIFarming.getMaterial().toString().toLowerCase(Locale.ROOT), gUIFarming.getModel().getKey());
            }
            GUISavedPrograms[] gUISavedProgramsArray = GUISavedPrograms.values();
            int n5 = gUISavedProgramsArray.length;
            for (n = 0; n < n5; ++n) {
                GUISavedPrograms gUISavedPrograms = gUISavedProgramsArray[n];
                if (gUISavedPrograms.getModel() == null) continue;
                this.writeShortFile(sender, gUISavedPrograms.getMaterial().toString().toLowerCase(Locale.ROOT), gUISavedPrograms.getModel().getKey());
            }
            Field[] fieldArray3 = GUITransmat.class.getDeclaredFields();
            int n6 = fieldArray3.length;
            for (n = 0; n < n6; ++n) {
                Field field = fieldArray3[n];
                this.writeFromField(sender, field);
            }
            Field[] fieldArray4 = GUIChameleonPresets.class.getDeclaredFields();
            int n7 = fieldArray4.length;
            for (n = 0; n < n7; ++n) {
                Field field = fieldArray4[n];
                this.writeFromField(sender, field);
            }
            Field[] fieldArray5 = GUIGeneticManipulator.class.getDeclaredFields();
            int n8 = fieldArray5.length;
            for (n = 0; n < n8; ++n) {
                Field field = fieldArray5[n];
                this.writeFromField(sender, field);
            }
            Field[] fieldArray6 = GUISaves.class.getDeclaredFields();
            int n9 = fieldArray6.length;
            for (n = 0; n < n9; ++n) {
                Field field = fieldArray6[n];
                this.writeFromField(sender, field);
            }
            Field[] fieldArray7 = GUIUpgrade.class.getDeclaredFields();
            int n10 = fieldArray7.length;
            for (n = 0; n < n10; ++n) {
                Field field = fieldArray7[n];
                this.writeFromField(sender, field);
            }
            Field[] fieldArray8 = GUIArs.class.getDeclaredFields();
            int n11 = fieldArray8.length;
            for (n = 0; n < n11; ++n) {
                Field field = fieldArray8[n];
                this.writeFromField(sender, field);
            }
            Field[] fieldArray9 = GUIChameleonTemplate.class.getDeclaredFields();
            int n12 = fieldArray9.length;
            for (n = 0; n < n12; ++n) {
                Field field = fieldArray9[n];
                this.writeFromField(sender, field);
            }
            Field[] fieldArray10 = GUIInteriorSounds.class.getDeclaredFields();
            int n13 = fieldArray10.length;
            for (n = 0; n < n13; ++n) {
                Field field = fieldArray10[n];
                this.writeFromField(sender, field);
            }
            Field[] fieldArray11 = GUISonicActivator.class.getDeclaredFields();
            int n14 = fieldArray11.length;
            for (n = 0; n < n14; ++n) {
                Field field = fieldArray11[n];
                this.writeFromField(sender, field);
            }
            Field[] fieldArray12 = GUIWallFloor.class.getDeclaredFields();
            int n15 = fieldArray12.length;
            for (n = 0; n < n15; ++n) {
                Field field = fieldArray12[n];
                this.writeFromField(sender, field);
            }
            Field[] fieldArray13 = GUIArtronStorage.class.getDeclaredFields();
            int n16 = fieldArray13.length;
            for (n = 0; n < n16; ++n) {
                Field field = fieldArray13[n];
                this.writeFromField(sender, field);
            }
            Field[] fieldArray14 = GUIChemistry.class.getDeclaredFields();
            int n17 = fieldArray14.length;
            for (n = 0; n < n17; ++n) {
                Field field = fieldArray14[n];
                this.writeFromField(sender, field);
            }
            GUIKeyPreferences[] gUIKeyPreferencesArray = GUIKeyPreferences.values();
            int n18 = gUIKeyPreferencesArray.length;
            for (n = 0; n < n18; ++n) {
                GUIKeyPreferences gUIKeyPreferences = gUIKeyPreferencesArray[n];
                if (gUIKeyPreferences.getModel() == null) continue;
                this.writeShortFile(sender, gUIKeyPreferences.getMaterial().toString().toLowerCase(Locale.ROOT), gUIKeyPreferences.getModel().getKey());
            }
            GUISonicConfigurator[] gUISonicConfiguratorArray = GUISonicConfigurator.values();
            int n19 = gUISonicConfiguratorArray.length;
            for (n = 0; n < n19; ++n) {
                GUISonicConfigurator gUISonicConfigurator = gUISonicConfiguratorArray[n];
                if (gUISonicConfigurator.getModel() == null) continue;
                this.writeShortFile(sender, gUISonicConfigurator.getMaterial().toString().toLowerCase(Locale.ROOT), gUISonicConfigurator.getModel().getKey());
            }
            Field[] fieldArray15 = GUIWeather.class.getDeclaredFields();
            int n20 = fieldArray15.length;
            for (n = 0; n < n20; ++n) {
                Field field = fieldArray15[n];
                this.writeFromField(sender, field);
            }
            GUIAutonomous[] gUIAutonomousArray = GUIAutonomous.values();
            int n21 = gUIAutonomousArray.length;
            for (n = 0; n < n21; ++n) {
                GUIAutonomous gUIAutonomous = gUIAutonomousArray[n];
                if (gUIAutonomous.getModel() == null) continue;
                this.writeShortFile(sender, gUIAutonomous.getMaterial().toString().toLowerCase(Locale.ROOT), gUIAutonomous.getModel().getKey());
            }
            Field[] fieldArray16 = GUICompanion.class.getDeclaredFields();
            int n22 = fieldArray16.length;
            for (n = 0; n < n22; ++n) {
                Field field = fieldArray16[n];
                this.writeFromField(sender, field);
            }
            Field[] fieldArray17 = GUILights.class.getDeclaredFields();
            int n23 = fieldArray17.length;
            for (n = 0; n < n23; ++n) {
                Field field = fieldArray17[n];
                this.writeFromField(sender, field);
            }
            GUISonicGenerator[] gUISonicGeneratorArray = GUISonicGenerator.values();
            int n24 = gUISonicGeneratorArray.length;
            for (n = 0; n < n24; ++n) {
                GUISonicGenerator gUISonicGenerator = gUISonicGeneratorArray[n];
                if (gUISonicGenerator.getModel() == null) continue;
                this.writeShortFile(sender, gUISonicGenerator.getMaterial().toString().toLowerCase(Locale.ROOT), gUISonicGenerator.getModel().getKey());
            }
            Field[] fieldArray18 = GUIChameleon.class.getDeclaredFields();
            int n25 = fieldArray18.length;
            for (n = 0; n < n25; ++n) {
                Field field = fieldArray18[n];
                this.writeFromField(sender, field);
            }
            Field[] fieldArray19 = GUIMap.class.getDeclaredFields();
            int n26 = fieldArray19.length;
            for (n = 0; n < n26; ++n) {
                Field field = fieldArray19[n];
                this.writeFromField(sender, field);
            }
            GUISonicPreferences[] gUISonicPreferencesArray = GUISonicPreferences.values();
            int n27 = gUISonicPreferencesArray.length;
            for (n = 0; n < n27; ++n) {
                GUISonicPreferences gUISonicPreferences = gUISonicPreferencesArray[n];
                if (gUISonicPreferences.getModel() == null) continue;
                this.writeShortFile(sender, gUISonicPreferences.getMaterial().toString().toLowerCase(Locale.ROOT), gUISonicPreferences.getModel().getKey());
            }
            Field[] fieldArray20 = GUIChameleonConstructor.class.getDeclaredFields();
            int n28 = fieldArray20.length;
            for (n = 0; n < n28; ++n) {
                Field field = fieldArray20[n];
                this.writeFromField(sender, field);
            }
            Field[] fieldArray21 = GUIControlCentre.class.getDeclaredFields();
            int n29 = fieldArray21.length;
            for (n = 0; n < n29; ++n) {
                Field field = fieldArray21[n];
                this.writeFromField(sender, field);
            }
            Field[] fieldArray22 = GUIParticle.class.getDeclaredFields();
            int n30 = fieldArray22.length;
            for (n = 0; n < n30; ++n) {
                Field field = fieldArray22[n];
                this.writeFromField(sender, field);
            }
            Field[] fieldArray23 = GUITelevision.class.getDeclaredFields();
            int n31 = fieldArray23.length;
            for (n = 0; n < n31; ++n) {
                Field field = fieldArray23[n];
                this.writeFromField(sender, field);
            }
            Field[] fieldArray24 = GUIChameleonHelp.class.getDeclaredFields();
            int n32 = fieldArray24.length;
            for (n = 0; n < n32; ++n) {
                Field field = fieldArray24[n];
                this.writeFromField(sender, field);
            }
            for (GUITemporalLocator gUITemporalLocator : GUITemporalLocator.values()) {
                if (gUITemporalLocator.getModel() == null) continue;
                this.writeShortFile(sender, gUITemporalLocator.getMaterial().toString().toLowerCase(Locale.ROOT), gUITemporalLocator.getModel().getKey());
            }
        }
        sender.sendMessage("Pack conversion complete!");
    }

    private void writeFromField(CommandSender sender, Field field) {
        field.setAccessible(true);
        try {
            GUIData data = (GUIData)field.get(this);
            String material = data.material().toString().toLowerCase(Locale.ROOT);
            String key = data.key().getKey();
            this.writeShortFile(sender, material, key);
        }
        catch (IllegalAccessException e) {
            sender.sendMessage(field.getName());
        }
    }

    private void writeFile(CommandSender sender, ItemStack result) {
        JsonObject model;
        ItemMeta im = result.getItemMeta();
        String name = ComponentUtils.stripColour(im.displayName());
        String material = result.getType().toString().toLowerCase(Locale.ROOT);
        String lowercaseName = name.toLowerCase(Locale.ROOT).replace(" ", "_");
        String filename = material + "_" + lowercaseName;
        JsonObject select = new JsonObject();
        select.addProperty("type", "minecraft:select");
        select.addProperty("property", "component");
        select.addProperty("component", "minecraft:custom_name");
        JsonObject fallback = new JsonObject();
        fallback.addProperty("type", "minecraft:model");
        fallback.addProperty("model", "minecraft:" + (result.getType().isBlock() ? "block" : "item") + "/" + material);
        select.add("fallback", (JsonElement)fallback);
        JsonArray cases = new JsonArray();
        JsonObject matcher = new JsonObject();
        JsonObject when = new JsonObject();
        when.addProperty("text", "");
        JsonArray extra = new JsonArray();
        JsonObject conditions = new JsonObject();
        conditions.addProperty("bold", Boolean.valueOf(false));
        conditions.addProperty("color", "white");
        conditions.addProperty("italic", Boolean.valueOf(false));
        conditions.addProperty("obfuscated", Boolean.valueOf(false));
        conditions.addProperty("strikethrough", Boolean.valueOf(false));
        conditions.addProperty("text", name);
        conditions.addProperty("underlined", Boolean.valueOf(false));
        extra.add((JsonElement)conditions);
        when.add("extra", (JsonElement)extra);
        matcher.add("when", (JsonElement)when);
        NamespacedKey nsk = im.getItemModel();
        String key = nsk != null ? nsk.getKey() + ".json" : lowercaseName + ".json";
        File child = new File(String.valueOf(this.plugin.getDataFolder()) + File.separator + key);
        try {
            JsonReader reader = new JsonReader((Reader)new FileReader(child));
            JsonObject root = JsonParser.parseReader((JsonReader)reader).getAsJsonObject();
            model = root.get("model").getAsJsonObject();
        }
        catch (FileNotFoundException e) {
            model = new JsonObject();
            model.addProperty("type", "minecraft:model");
            model.addProperty("model", "tardis:item/" + lowercaseName);
        }
        matcher.add("model", (JsonElement)model);
        cases.add((JsonElement)matcher);
        select.add("cases", (JsonElement)cases);
        String output = String.valueOf(this.plugin.getDataFolder()) + File.separator + "processed" + File.separator + filename + ".json";
        File file = new File(output);
        try (FileWriter writer = new FileWriter(file);){
            this.gson.toJson((JsonElement)select, (Appendable)writer);
        }
        catch (IOException e) {
            sender.sendMessage("File write error for " + filename);
            sender.sendMessage(e.getMessage());
        }
    }

    private void writeFile(CommandSender sender, String material, String key) {
        JsonObject model;
        String filename = material + "_" + key;
        JsonObject select = new JsonObject();
        select.addProperty("type", "minecraft:select");
        select.addProperty("property", "component");
        select.addProperty("component", "minecraft:custom_name");
        JsonObject fallback = new JsonObject();
        fallback.addProperty("type", "minecraft:model");
        fallback.addProperty("model", "minecraft:item/" + material);
        select.add("fallback", (JsonElement)fallback);
        JsonArray cases = new JsonArray();
        JsonObject matcher = new JsonObject();
        JsonObject when = new JsonObject();
        when.addProperty("text", "");
        JsonArray extra = new JsonArray();
        JsonObject conditions = new JsonObject();
        conditions.addProperty("bold", Boolean.valueOf(false));
        conditions.addProperty("color", "white");
        conditions.addProperty("italic", Boolean.valueOf(false));
        conditions.addProperty("obfuscated", Boolean.valueOf(false));
        conditions.addProperty("strikethrough", Boolean.valueOf(false));
        String name = this.hasEntry(key) ? this.getEntry(key) : this.convertFilename(key);
        conditions.addProperty("text", name);
        conditions.addProperty("underlined", Boolean.valueOf(false));
        extra.add((JsonElement)conditions);
        when.add("extra", (JsonElement)extra);
        matcher.add("when", (JsonElement)when);
        try {
            String path = String.valueOf(this.plugin.getDataFolder()) + File.separator + key + ".json";
            sender.sendMessage(path);
            File child = new File(path);
            JsonReader reader = new JsonReader((Reader)new FileReader(child));
            JsonObject root = JsonParser.parseReader((JsonReader)reader).getAsJsonObject();
            model = root.get("model").getAsJsonObject();
        }
        catch (FileNotFoundException e) {
            model = new JsonObject();
            model.addProperty("type", "minecraft:model");
            model.addProperty("model", "tardis:item/" + key);
        }
        matcher.add("model", (JsonElement)model);
        cases.add((JsonElement)matcher);
        select.add("cases", (JsonElement)cases);
        String output = String.valueOf(this.plugin.getDataFolder()) + File.separator + "processed" + File.separator + filename + ".json";
        File file = new File(output);
        try (FileWriter writer = new FileWriter(file);){
            this.gson.toJson((JsonElement)select, (Appendable)writer);
        }
        catch (IOException e) {
            sender.sendMessage("File write error for " + filename);
            sender.sendMessage(e.getMessage());
        }
    }

    private void writeShortFile(CommandSender sender, String material, String key) {
        JsonObject model;
        String filename = material + "_" + key;
        String name = this.hasEntry(key) ? this.getEntry(key) : this.convertFilename(key);
        JsonObject select = new JsonObject();
        select.addProperty("type", "minecraft:select");
        select.addProperty("property", "component");
        select.addProperty("component", "minecraft:custom_name");
        JsonObject fallback = new JsonObject();
        fallback.addProperty("type", "minecraft:model");
        fallback.addProperty("model", "minecraft:item/" + material);
        select.add("fallback", (JsonElement)fallback);
        JsonArray cases = new JsonArray();
        JsonObject matcher = new JsonObject();
        JsonObject when = new JsonObject();
        when.addProperty("text", "");
        JsonArray extra = new JsonArray();
        extra.add(name);
        when.add("extra", (JsonElement)extra);
        matcher.add("when", (JsonElement)when);
        try {
            String path = String.valueOf(this.plugin.getDataFolder()) + File.separator + "component" + File.separator + key + ".json";
            sender.sendMessage(path);
            File child = new File(path);
            JsonReader reader = new JsonReader((Reader)new FileReader(child));
            JsonObject root = JsonParser.parseReader((JsonReader)reader).getAsJsonObject();
            model = root.get("model").getAsJsonObject();
        }
        catch (FileNotFoundException e) {
            model = new JsonObject();
            model.addProperty("type", "minecraft:model");
            model.addProperty("model", "tardis:item/" + key);
        }
        matcher.add("model", (JsonElement)model);
        cases.add((JsonElement)matcher);
        select.add("cases", (JsonElement)cases);
        String output = String.valueOf(this.plugin.getDataFolder()) + File.separator + "component" + File.separator + "processed" + File.separator + filename + ".json";
        File file = new File(output);
        try (FileWriter writer = new FileWriter(file);){
            this.gson.toJson((JsonElement)select, (Appendable)writer);
        }
        catch (IOException e) {
            sender.sendMessage("File write error for " + filename);
            sender.sendMessage(e.getMessage());
        }
    }

    private String convertFilename(String s) {
        String[] parts = s.split("\\.");
        String[] split = parts[0].replace("button_", "").replace("switch_", "").split("_");
        StringBuilder builder = new StringBuilder();
        for (String str : split) {
            builder.append(ResourcePackConverterCommand.uppercaseFirst(str)).append(" ");
        }
        return builder.toString().trim();
    }

    public String getMaterial(String name) {
        this.plugin.debug(name);
        if (this.plugin.getFigura().getShapedRecipes().containsKey(name)) {
            ShapedRecipe recipe = this.plugin.getFigura().getShapedRecipes().get(name);
            return recipe.getResult().getType().toString().toLowerCase(Locale.ROOT);
        }
        if (this.plugin.getIncomposita().getShapelessRecipes().containsKey(name)) {
            ShapelessRecipe recipe = this.plugin.getIncomposita().getShapelessRecipes().get(name);
            return recipe.getResult().getType().toString().toLowerCase(Locale.ROOT);
        }
        return "bowl";
    }

    public boolean hasEntry(String s) {
        String[] parts = s.split("\\.");
        String upper = parts[0].toUpperCase(Locale.ROOT);
        return this.plugin.getLanguage().getString(upper) != null;
    }

    public String getEntry(String s) {
        String[] parts = s.split("\\.");
        String upper = parts[0].toUpperCase(Locale.ROOT);
        return this.plugin.getLanguage().getString(upper);
    }
}

