/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.chameleon.construct;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.chameleon.construct.ChameleonConstructorInventory;
import me.eccentric_nz.TARDIS.chameleon.construct.ConstructBuilder;
import me.eccentric_nz.TARDIS.chameleon.gui.ChameleonHelpInventory;
import me.eccentric_nz.TARDIS.chameleon.gui.ChameleonInventory;
import me.eccentric_nz.TARDIS.chameleon.utils.StainedGlassLookup;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetChameleon;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTravellers;
import me.eccentric_nz.TARDIS.enumeration.Adaption;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.listeners.TARDISMenuListener;
import me.eccentric_nz.TARDIS.utility.TARDISMaterials;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.type.Door;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ChameleonConstructorListener
extends TARDISMenuListener {
    private final TARDIS plugin;
    private final List<Material> doors = new ArrayList<Material>();
    private final List<Material> lamps = new ArrayList<Material>();
    private final HashMap<UUID, Integer> currentDoor = new HashMap();
    private final HashMap<UUID, Integer> currentLamp = new HashMap();
    private final int dn;
    private final int ln;

    public ChameleonConstructorListener(TARDIS plugin) {
        super(plugin);
        this.plugin = plugin;
        this.doors.addAll(Tag.DOORS.getValues());
        this.dn = this.doors.size();
        plugin.getBlocksConfig().getStringList("lamp_blocks").forEach(s -> {
            try {
                this.lamps.add(Material.valueOf((String)s));
            }
            catch (IllegalArgumentException e) {
                plugin.debug("Invalid Material in lamp_blocks section.");
            }
        });
        this.ln = this.lamps.size();
    }

    @EventHandler(ignoreCancelled=true)
    public void onChameleonConstructorClick(InventoryClickEvent event) {
        if (!(event.getInventory().getHolder(false) instanceof ChameleonConstructorInventory)) {
            return;
        }
        InventoryView view = event.getView();
        int slot = event.getRawSlot();
        Player player = (Player)event.getWhoClicked();
        if (slot >= 0 && (slot < 18 || slot == 26 || slot == 43 || slot == 52)) {
            event.setCancelled(true);
            ItemStack is = view.getItem(slot);
            if (is == null) {
                return;
            }
            HashMap<String, Object> wheres = new HashMap<String, Object>();
            wheres.put("uuid", player.getUniqueId().toString());
            ResultSetTravellers rst = new ResultSetTravellers(this.plugin, wheres, false);
            if (!rst.resultSet()) {
                return;
            }
            int id = rst.getTardis_id();
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("tardis_id", id);
            ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
            if (!rs.resultSet()) {
                return;
            }
            UUID uuid = player.getUniqueId();
            Tardis tardis = rs.getTardis();
            ChameleonPreset preset = tardis.getPreset();
            Adaption adapt = tardis.getAdaption();
            switch (slot) {
                case 0: {
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> player.openInventory(new ChameleonInventory(this.plugin, adapt, preset, tardis.getItemPreset()).getInventory()), 2L);
                    break;
                }
                case 2: {
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> player.openInventory(new ChameleonHelpInventory(this.plugin).getInventory()), 2L);
                    break;
                }
                case 5: {
                    this.close(player);
                    break;
                }
                case 7: {
                    HashMap<String, Object> wherecl = new HashMap<String, Object>();
                    wherecl.put("tardis_id", id);
                    ResultSetChameleon rscl = new ResultSetChameleon(this.plugin, wherecl);
                    if (!rscl.resultSet()) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CHAM_NO_SAVE");
                        return;
                    }
                    new ConstructBuilder(this.plugin).build(tardis.getPreset().toString(), id, player);
                    break;
                }
                case 8: {
                    String air = TARDISConstants.AIR.getAsString();
                    String[][] blue = new String[10][4];
                    String[][] stain = new String[10][4];
                    String[][] glass = new String[10][4];
                    int first = 0;
                    int nullcount = 0;
                    for (int s = 18; s < 27; ++s) {
                        int second = 0;
                        for (int c = 27; c >= 0; c -= 9) {
                            ItemStack d = view.getItem(s + c);
                            if (d != null) {
                                Material type = d.getType();
                                if (!this.plugin.getConfig().getBoolean("allow.all_blocks") && TARDISMaterials.precious.contains(type) || Tag.WOOL_CARPETS.isTagged((Keyed)type)) {
                                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CHAM_NOT_CUSTOM");
                                    player.getWorld().dropItemNaturally(player.getLocation(), d);
                                    event.getClickedInventory().clear(s + c);
                                    return;
                                }
                                Material mat = d.getType();
                                BlockData blockData = mat.createBlockData();
                                blue[first][second] = blockData.getAsString();
                                if (this.doors.contains(d.getType())) {
                                    String dataStr;
                                    BlockData did = d.getType().createBlockData();
                                    Door door = (Door)did;
                                    door.setFacing(BlockFace.EAST);
                                    door.setHinge(Door.Hinge.RIGHT);
                                    if (s + c == 52) {
                                        door.setHalf(Bisected.Half.BOTTOM);
                                    } else {
                                        door.setHalf(Bisected.Half.TOP);
                                    }
                                    blue[first][second] = dataStr = door.getAsString();
                                    stain[first][second] = dataStr;
                                    glass[first][second] = dataStr;
                                } else if (mat.equals((Object)Material.TORCH) || mat.equals((Object)Material.REDSTONE_TORCH)) {
                                    if (view.getItem(35) == null) {
                                        blue[first][second] = air;
                                        glass[first][second] = air;
                                        stain[first][second] = air;
                                    } else {
                                        blue[first][second] = blockData.getAsString();
                                        glass[first][second] = TARDISConstants.GLASS.getAsString();
                                        stain[first][second] = mat.equals((Object)Material.TORCH) ? Material.YELLOW_STAINED_GLASS.createBlockData().getAsString() : Material.RED_STAINED_GLASS.createBlockData().getAsString();
                                    }
                                } else if (blockData instanceof Directional) {
                                    Directional directional = (Directional)blockData;
                                    directional.setFacing(BlockFace.WEST);
                                    blue[first][second] = directional.getAsString();
                                    glass[first][second] = TARDISConstants.GLASS.getAsString();
                                    stain[first][second] = StainedGlassLookup.stainedGlassFromMaterial(null, mat).createBlockData().getAsString();
                                } else {
                                    blue[first][second] = blockData.getAsString();
                                    glass[first][second] = TARDISConstants.GLASS.getAsString();
                                    stain[first][second] = StainedGlassLookup.stainedGlassFromMaterial(null, mat).createBlockData().getAsString();
                                }
                            } else {
                                blue[first][second] = air;
                                glass[first][second] = air;
                                stain[first][second] = air;
                                ++nullcount;
                            }
                            ++second;
                        }
                        ++first;
                    }
                    if (nullcount == 33) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CHAM_NOT_EMPTY");
                        return;
                    }
                    BlockData sign = Material.OAK_WALL_SIGN.createBlockData();
                    Directional directional = (Directional)sign;
                    directional.setFacing(BlockFace.WEST);
                    String[] signData = new String[]{air, air, directional.getAsString(), air};
                    blue[9] = signData;
                    stain[9] = signData;
                    glass[9] = signData;
                    Gson gson = new GsonBuilder().disableHtmlEscaping().create();
                    String jsonBlue = gson.toJson((Object)blue);
                    String jsonStain = gson.toJson((Object)stain);
                    String jsonGlass = gson.toJson((Object)glass);
                    HashMap<String, Object> seti = new HashMap<String, Object>();
                    seti.put("active", 0);
                    HashMap<String, Object> wherei = new HashMap<String, Object>();
                    wherei.put("tardis_id", id);
                    this.plugin.getQueryFactory().doSyncUpdate("chameleon", seti, wherei);
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                        HashMap<String, Object> setc = new HashMap<String, Object>();
                        setc.put("tardis_id", id);
                        setc.put("blueprintData", jsonBlue);
                        setc.put("stainData", jsonStain);
                        setc.put("glassData", jsonGlass);
                        setc.put("active", 1);
                        this.plugin.getQueryFactory().doSyncInsert("chameleon", setc);
                        new ConstructBuilder(this.plugin).build(tardis.getPreset().toString(), id, player);
                    }, 5L);
                    break;
                }
                case 26: {
                    if (!this.currentLamp.containsKey(uuid)) {
                        this.currentLamp.put(uuid, 0);
                    }
                    this.nextLamp(uuid, view);
                    break;
                }
                case 43: 
                case 52: {
                    if (!this.currentDoor.containsKey(uuid)) {
                        this.currentDoor.put(uuid, 0);
                    }
                    this.nextDoor(uuid, view);
                    break;
                }
            }
        } else {
            ClickType click = event.getClick();
            if (click.equals((Object)ClickType.SHIFT_RIGHT) || click.equals((Object)ClickType.SHIFT_LEFT) || click.equals((Object)ClickType.DOUBLE_CLICK)) {
                this.plugin.debug("TARDISChameleonConstructorListener");
                event.setCancelled(true);
            }
        }
    }

    private void nextLamp(UUID uuid, InventoryView view) {
        int l = this.currentLamp.get(uuid);
        l = l < this.ln - 1 ? ++l : 0;
        view.setItem(26, ItemStack.of((Material)this.lamps.get(l)));
        this.currentLamp.put(uuid, l);
    }

    private void nextDoor(UUID uuid, InventoryView view) {
        int d = this.currentDoor.get(uuid);
        d = d < this.dn - 1 ? ++d : 0;
        view.setItem(43, ItemStack.of((Material)this.doors.get(d)));
        view.setItem(52, ItemStack.of((Material)this.doors.get(d)));
        this.currentDoor.put(uuid, d);
    }
}

