/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardisshop.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import me.eccentric_nz.tardisshop.TARDISShopItem;

public class ResultSetShopItem {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final String prefix;
    private TARDISShopItem shopItem;

    public ResultSetShopItem(TARDIS plugin) {
        this.plugin = plugin;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean itemFromBlock(String location) {
        PreparedStatement statement = null;
        ResultSet rs = null;
        String query = "SELECT * FROM " + this.prefix + "items WHERE location = ?";
        try {
            statement = this.connection.prepareStatement(query);
            statement.setString(1, location);
            rs = statement.executeQuery();
            if (rs.isBeforeFirst()) {
                rs.next();
                this.shopItem = new TARDISShopItem(rs.getInt("item_id"), rs.getString("item"), TARDISStaticLocationGetters.getLocationFromBukkitString(rs.getString("location")), rs.getDouble("cost"));
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (SQLException e) {
            this.plugin.debug("ResultSet error for items table! " + e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing items table! " + e.getMessage());
            }
        }
    }

    public TARDISShopItem getShopItem() {
        return this.shopItem;
    }
}

