/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.utility.update;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.StringReader;
import java.lang.module.ModuleDescriptor;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Properties;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.utility.update.UpdateTARDISPlugins;
import me.eccentric_nz.TARDIS.utility.update.UpdateTracker;
import org.bukkit.command.CommandSender;

public class TARDISUpdateChecker
implements Runnable {
    private final TARDIS plugin;
    private final CommandSender sender;

    public TARDISUpdateChecker(TARDIS plugin, CommandSender sender) {
        this.plugin = plugin;
        this.sender = sender;
    }

    @Override
    public void run() {
        ModuleDescriptor.Version serverVersion;
        ModuleDescriptor.Version updateVersion;
        if (!this.plugin.getGeneralKeeper().getPluginYAML().contains("version")) {
            return;
        }
        String build = this.plugin.getGeneralKeeper().getPluginYAML().getString("version");
        if (build.contains("local")) {
            if (this.sender == null) {
                this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Server is running a custom or dev version!");
            } else {
                this.plugin.getMessenger().message(this.sender, TardisModule.TARDIS, "You are running a custom or dev version!");
            }
            return;
        }
        String commit = build.split("-b")[1];
        JsonObject lastBuild = this.fetchLatestCommit();
        if (lastBuild == null || !lastBuild.has("sha")) {
            if (this.sender == null) {
                this.plugin.getMessenger().sendWithColour((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Couldn't retrieve GitHub commit info!", "#FF5555");
            } else {
                this.plugin.getMessenger().sendWithColour(this.sender, TardisModule.TARDIS, "Couldn't retrieve GitHub commit info!", "#FF5555");
            }
            return;
        }
        String latestCommit = lastBuild.get("sha").getAsString().substring(0, 8);
        if (commit.equals(latestCommit)) {
            if (this.sender == null) {
                this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Server is running the latest version!");
            } else {
                this.plugin.getMessenger().message(this.sender, TardisModule.TARDIS, "You are running the latest version!");
            }
            return;
        }
        String currentServer = this.getLastestServerVersion();
        if (!currentServer.isEmpty() && (updateVersion = ModuleDescriptor.Version.parse(currentServer)).compareTo(serverVersion = ModuleDescriptor.Version.parse(this.plugin.getServerStr())) > 0) {
            String message = "A new version is available, but requires a server update to " + currentServer;
            if (this.sender == null) {
                this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, message);
            } else {
                this.plugin.getMessenger().message(this.sender, TardisModule.TARDIS, message);
            }
            return;
        }
        UpdateTracker.setUpdateFound(true);
        UpdateTracker.setCurrentCommit(commit);
        UpdateTracker.setLatestCommit(latestCommit);
        if (this.sender == null) {
            this.plugin.getMessenger().sendGitHubUpdateReady((CommandSender)this.plugin.getConsole(), commit, latestCommit);
            if (this.plugin.getConfig().getBoolean("preferences.update.auto_download")) {
                new UpdateTARDISPlugins(this.plugin).fetchFromGitHub((CommandSender)this.plugin.getConsole());
            } else {
                this.plugin.getMessenger().sendUpdateCommand((CommandSender)this.plugin.getConsole());
            }
        } else {
            this.plugin.getMessenger().send(this.sender, TardisModule.TARDIS, "", latestCommit);
        }
    }

    private JsonObject fetchLatestCommit() {
        try {
            URI uri = URI.create("https://api.github.com/repos/eccentricdevotion/TARDIS/commits");
            HttpClient client = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).connectTimeout(Duration.ofSeconds(10L)).build();
            HttpRequest request = HttpRequest.newBuilder().GET().uri(uri).header("User-Agent", "TARDISPlugin").build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            JsonElement root = JsonParser.parseString((String)response.body());
            return root.getAsJsonArray().get(0).getAsJsonObject();
        }
        catch (Exception ex) {
            this.plugin.debug("Failed to check for a commit update on TARDIS GitHub.");
            return null;
        }
    }

    private String getLastestServerVersion() {
        try {
            URI uri = URI.create("https://raw.githubusercontent.com/eccentricdevotion/TARDIS/master/gradle.properties");
            HttpClient client = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).connectTimeout(Duration.ofSeconds(10L)).build();
            HttpRequest request = HttpRequest.newBuilder().GET().uri(uri).header("User-Agent", "TARDISPlugin").build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            StringReader reader = new StringReader(response.body());
            Properties props = new Properties();
            props.load(reader);
            reader.close();
            return props.getProperty("paperVersion");
        }
        catch (IOException | InterruptedException e) {
            return "1.21.11";
        }
    }
}

