/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.travel;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.database.data.Area;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetAreaLocations;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetAreas;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentLocation;
import me.eccentric_nz.TARDIS.planets.TARDISAliasResolver;
import me.eccentric_nz.TARDIS.travel.TARDISAreaCheck;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionAttachmentInfo;

public class TARDISArea {
    private final TARDIS plugin;

    public TARDISArea(TARDIS plugin) {
        this.plugin = plugin;
    }

    public boolean isInExistingArea(int id, int area) {
        ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, id);
        if (rsc.resultSet()) {
            return this.isInExistingArea(rsc.getCurrent().location(), area);
        }
        return false;
    }

    public boolean isInExistingArea(Location rsc, int area) {
        HashMap<String, Object> wherea = new HashMap<String, Object>();
        wherea.put("area_id", area);
        ResultSetAreas rsa = new ResultSetAreas(this.plugin, wherea, false, false);
        if (rsa.resultSet()) {
            Area a = rsa.getArea();
            if (!a.grid()) {
                ResultSetAreaLocations rsal = new ResultSetAreaLocations(this.plugin, a.areaId());
                if (rsal.resultSet()) {
                    for (Location s : rsal.getLocations()) {
                        if (s.getBlockX() != rsc.getBlockX() || s.getBlockY() != rsc.getBlockY() || s.getBlockZ() != rsc.getBlockZ()) continue;
                        return true;
                    }
                }
            } else {
                return rsc.getX() <= (double)a.maxX() && rsc.getZ() <= (double)a.maxZ() && rsc.getX() >= (double)a.minX() && rsc.getZ() >= (double)a.minZ();
            }
        }
        return false;
    }

    public boolean isInExistingArea(Location l) {
        String w = l.getWorld().getName();
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("world", w);
        ResultSetAreas rsa = new ResultSetAreas(this.plugin, where, true, false);
        if (rsa.resultSet()) {
            for (Area a : rsa.getData()) {
                if (!a.grid()) {
                    ResultSetAreaLocations rsal = new ResultSetAreaLocations(this.plugin, a.areaId());
                    if (!rsal.resultSet()) continue;
                    for (Location s : rsal.getLocations()) {
                        if (s.getBlockX() != l.getBlockX() || s.getBlockY() != l.getBlockY() || s.getBlockZ() != l.getBlockZ()) continue;
                        return true;
                    }
                    continue;
                }
                if (!(l.getX() <= (double)a.maxX()) || !(l.getZ() <= (double)a.maxZ()) || !(l.getX() >= (double)a.minX()) || !(l.getZ() >= (double)a.minZ())) continue;
                return true;
            }
        }
        return false;
    }

    public TARDISAreaCheck isSaveInArea(Location l) {
        String w = l.getWorld().getName();
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("world", w);
        ResultSetAreas rsa = new ResultSetAreas(this.plugin, where, true, false);
        if (rsa.resultSet()) {
            for (Area a : rsa.getData()) {
                if (!a.grid()) {
                    ResultSetAreaLocations rsal = new ResultSetAreaLocations(this.plugin, a.areaId());
                    if (!rsal.resultSet()) continue;
                    for (Location s : rsal.getLocations()) {
                        if (s.getBlockX() != l.getBlockX() || s.getBlockY() != l.getBlockY() || s.getBlockZ() != l.getBlockZ()) continue;
                        return new TARDISAreaCheck(a, true);
                    }
                    continue;
                }
                if (!(l.getX() <= (double)a.maxX()) || !(l.getZ() <= (double)a.maxZ()) || !(l.getX() >= (double)a.minX()) || !(l.getZ() >= (double)a.minZ())) continue;
                return new TARDISAreaCheck(a, true);
            }
        }
        return new TARDISAreaCheck(null, false);
    }

    public boolean areaCheckInExile(String area, Location l) {
        boolean chk = true;
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("area_name", area);
        ResultSetAreas rsa = new ResultSetAreas(this.plugin, where, false, false);
        if (rsa.resultSet()) {
            Area a = rsa.getArea();
            String lw = l.getWorld().getName();
            if (a.world().equals(lw) && l.getBlockX() <= a.maxX() && l.getZ() <= (double)a.maxZ() && l.getX() >= (double)a.minX() && l.getZ() >= (double)a.minZ()) {
                chk = false;
            }
        }
        return chk;
    }

    public boolean areaCheckLocPlayer(Player p, Location l) {
        boolean chk = false;
        String w = l.getWorld().getName();
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("world", w);
        ResultSetAreas rsa = new ResultSetAreas(this.plugin, where, true, false);
        if (rsa.resultSet()) {
            for (Area a : rsa.getData()) {
                String n = a.areaName();
                if (!(l.getX() <= (double)a.maxX()) || !(l.getZ() <= (double)a.maxZ()) || !(l.getX() >= (double)a.minX()) || !(l.getZ() >= (double)a.minZ()) || TARDISPermission.hasPermission(p, "tardis.area." + n) && p.isPermissionSet("tardis.area." + n)) continue;
                this.plugin.getTrackerKeeper().getPerm().put(p.getUniqueId(), "tardis.area." + n);
                chk = true;
                break;
            }
        }
        return chk;
    }

    public Location getNextSpot(String area) {
        Location location = null;
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("area_name", area);
        ResultSetAreas rsa = new ResultSetAreas(this.plugin, where, false, false);
        if (rsa.resultSet()) {
            World w;
            int xx;
            Area a = rsa.getArea();
            int park = a.parkingDistance() + 3;
            int zz = 0;
            int minx = a.minX();
            int x = minx + 2;
            int minz = a.minZ();
            int z = minz + 2;
            int maxx = a.maxX();
            int maxz = a.maxZ();
            String wStr = a.world();
            boolean chk = false;
            block0: for (xx = x; xx <= maxx; xx += park) {
                for (zz = z; zz <= maxz; zz += park) {
                    HashMap<String, Object> wherec = new HashMap<String, Object>();
                    wherec.put("world", wStr);
                    wherec.put("x", xx);
                    wherec.put("z", zz);
                    ResultSetCurrentLocation rs = new ResultSetCurrentLocation(this.plugin, wherec);
                    if (rs.resultSet()) continue;
                    chk = true;
                    break block0;
                }
            }
            if (chk && (w = TARDISAliasResolver.getWorldFromAlias(wStr)) != null) {
                int y = a.y();
                if (y == 0) {
                    y = w.getHighestBlockYAt(xx, zz) + 1;
                }
                location = w.getBlockAt(xx, y, zz).getLocation();
            }
        }
        return location;
    }

    public String getExileArea(Player p) {
        Set perms = p.getEffectivePermissions();
        String area = "";
        for (PermissionAttachmentInfo pai : perms) {
            if (!pai.getPermission().contains("tardis.area")) continue;
            int len = pai.getPermission().length();
            area = pai.getPermission().substring(12, len);
        }
        return area;
    }

    public Location getSemiRandomLocation(int id) {
        ResultSetAreaLocations rs = new ResultSetAreaLocations(this.plugin, id);
        if (rs.resultSet()) {
            List<Location> locations = rs.getLocations();
            Collections.shuffle(locations);
            for (Location l : locations) {
                HashMap<String, Object> wherec = new HashMap<String, Object>();
                wherec.put("world", l.getWorld().getName());
                wherec.put("x", l.getBlockX());
                wherec.put("z", l.getBlockZ());
                ResultSetCurrentLocation rsc = new ResultSetCurrentLocation(this.plugin, wherec);
                if (rsc.resultSet()) continue;
                return l;
            }
        }
        return null;
    }
}

