/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.sonic.actions;

import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetArtronLeveID;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.utility.TARDISSounds;
import net.kyori.adventure.text.Component;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class SonicRecharge
implements Runnable {
    private final TARDIS plugin;
    private final UUID display_uuid;
    private final ItemFrame frame;
    private final int id;
    private final Player player;
    private final int full;
    private final int amount;
    private int task;

    public SonicRecharge(TARDIS plugin, UUID display_uuid, ItemFrame frame, int id, Player player) {
        this.plugin = plugin;
        this.display_uuid = display_uuid;
        this.frame = frame;
        this.id = id;
        this.player = player;
        this.full = this.plugin.getConfig().getInt("sonic.charge_level");
        this.amount = (int)Math.ceil(this.plugin.getConfig().getDouble("sonic.charge_level") / this.plugin.getConfig().getDouble("sonic.charge_interval"));
    }

    @Override
    public void run() {
        Entity entity = this.plugin.getServer().getEntity(this.display_uuid);
        if (entity instanceof ItemDisplay) {
            ResultSetArtronLeveID rsa;
            ItemDisplay display = (ItemDisplay)entity;
            ItemStack is = display.getItemStack();
            if (is == null || !is.hasItemMeta()) {
                this.cancel();
            }
            if (!(rsa = new ResultSetArtronLeveID(this.plugin, this.id)).resultset() || rsa.getArtronLevel() < this.amount) {
                TARDISSounds.playTARDISSound(this.frame.getLocation(), "charge_fail");
                this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "DOCK_ENERGY");
                this.cancel();
            } else {
                HashMap<String, Object> where = new HashMap<String, Object>();
                where.put("tardis_id", this.id);
                this.plugin.getQueryFactory().alterEnergyLevel("tardis", -this.amount, where, null);
            }
            ItemMeta im = is.getItemMeta();
            PersistentDataContainer pdc = im.getPersistentDataContainer();
            if (!pdc.has(this.plugin.getSonicChargeKey(), PersistentDataType.INTEGER)) {
                pdc.set(this.plugin.getSonicChargeKey(), PersistentDataType.INTEGER, (Object)this.amount);
                is.setItemMeta(im);
                display.setItemStack(is);
                this.setFrameDisplay(this.frame, this.amount);
            } else {
                int current = (Integer)pdc.get(this.plugin.getSonicChargeKey(), PersistentDataType.INTEGER);
                if (current < this.full - this.amount) {
                    int charge = current + this.amount;
                    pdc.set(this.plugin.getSonicChargeKey(), PersistentDataType.INTEGER, (Object)charge);
                    is.setItemMeta(im);
                    display.setItemStack(is);
                    this.setFrameDisplay(this.frame, charge);
                } else {
                    pdc.set(this.plugin.getSonicChargeKey(), PersistentDataType.INTEGER, (Object)this.full);
                    is.setItemMeta(im);
                    display.setItemStack(is);
                    this.setFrameDisplay(this.frame, this.full);
                    TARDISSounds.playTARDISSound(this.frame.getLocation(), "charge_done");
                    this.cancel();
                }
            }
        } else {
            this.cancel();
        }
    }

    public void setTask(int task) {
        this.task = task;
    }

    private void cancel() {
        this.plugin.getServer().getScheduler().cancelTask(this.task);
        this.task = 0;
    }

    private void setFrameDisplay(ItemFrame frame, int amount) {
        if (frame.isValid()) {
            ItemStack dock = frame.getItem();
            ItemMeta dim = dock.getItemMeta();
            Object name = amount > 0 ? "Sonic Dock: " + amount : "Sonic Dock";
            dim.displayName((Component)Component.text((String)name));
            dock.setItemMeta(dim);
            frame.setItem(dock);
        }
    }
}

