/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.rooms.games.tictactoe;

import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.listeners.TARDISMenuListener;
import me.eccentric_nz.TARDIS.rooms.games.GameOutcome;
import me.eccentric_nz.TARDIS.rooms.games.tictactoe.MatchData;
import me.eccentric_nz.TARDIS.rooms.games.tictactoe.MatchState;
import me.eccentric_nz.TARDIS.rooms.games.tictactoe.NoughtsAndCrossesInventory;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class NoughtsAndCrossesListener
extends TARDISMenuListener {
    private final TARDIS plugin;
    private final HashMap<UUID, MatchData> matches = new HashMap();
    private final int[][] winPos = new int[][]{{0, 1, 2}, {3, 4, 5}, {6, 7, 8}, {2, 4, 6}, {0, 4, 8}, {0, 3, 6}, {1, 4, 7}, {2, 5, 8}};
    private final HashMap<Integer, Integer> slotToIndex = new HashMap<Integer, Integer>(){
        {
            this.put(3, 0);
            this.put(4, 1);
            this.put(5, 2);
            this.put(12, 3);
            this.put(13, 4);
            this.put(14, 5);
            this.put(21, 6);
            this.put(22, 7);
            this.put(23, 8);
        }
    };
    private final HashMap<Integer, Integer> indexToSlot = new HashMap<Integer, Integer>(){
        {
            this.put(0, 3);
            this.put(1, 4);
            this.put(2, 5);
            this.put(3, 12);
            this.put(4, 13);
            this.put(5, 14);
            this.put(6, 21);
            this.put(7, 22);
            this.put(8, 23);
        }
    };
    private final ItemStack player;
    private final ItemStack tardis;
    private final ItemStack nought;
    private final ItemStack cross;
    long delay = 20L;

    public NoughtsAndCrossesListener(TARDIS plugin) {
        super(plugin);
        this.plugin = plugin;
        this.player = ItemStack.of((Material)Material.CYAN_GLAZED_TERRACOTTA);
        ItemMeta pim = this.player.getItemMeta();
        pim.displayName((Component)Component.text((String)"Player"));
        this.player.setItemMeta(pim);
        this.tardis = ItemStack.of((Material)Material.RED_GLAZED_TERRACOTTA);
        ItemMeta tim = this.tardis.getItemMeta();
        tim.displayName((Component)Component.text((String)"TARDIS"));
        this.tardis.setItemMeta(tim);
        this.nought = ItemStack.of((Material)Material.CYAN_GLAZED_TERRACOTTA);
        ItemMeta nim = this.nought.getItemMeta();
        nim.displayName((Component)Component.text((String)"Nought"));
        this.nought.setItemMeta(nim);
        this.cross = ItemStack.of((Material)Material.RED_GLAZED_TERRACOTTA);
        ItemMeta cim = this.cross.getItemMeta();
        cim.displayName((Component)Component.text((String)"Cross"));
        this.cross.setItemMeta(cim);
    }

    @EventHandler
    public void onTicTacToeClick(InventoryClickEvent event) {
        if (!(event.getInventory().getHolder(false) instanceof NoughtsAndCrossesInventory)) {
            return;
        }
        event.setCancelled(true);
        int slot = event.getRawSlot();
        if (slot < 0 || slot > 54) {
            return;
        }
        InventoryView view = event.getView();
        if (view.getItem(slot) == null) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        UUID uuid = player.getUniqueId();
        MatchData match = this.matches.getOrDefault(uuid, new MatchData());
        switch (slot) {
            case 3: 
            case 4: 
            case 5: 
            case 12: 
            case 13: 
            case 14: 
            case 21: 
            case 22: 
            case 23: {
                if (match.getMatchState().isNotPlayerTurn()) {
                    return;
                }
                ItemStack is = view.getItem(slot);
                if (is == null || is.getType() != MatchState.NOT_STARTED.getSymbol()) break;
                this.turn(view, this.slotToIndex.get(slot), match);
                break;
            }
            case 45: {
                view.getTopInventory().setContents(new NoughtsAndCrossesInventory(this.plugin).getInventory().getContents());
                this.matches.put(uuid, new MatchData());
                break;
            }
            case 53: {
                this.close(player);
                break;
            }
        }
    }

    public void switchTurn(InventoryView view, MatchData match) {
        if (match.getMatchState() == MatchState.NOT_STARTED || match.getMatchState() == MatchState.PLAYER_TURN) {
            match.setMatchState(MatchState.TARDIS_TURN);
            view.setItem(8, null);
            view.setItem(17, this.tardis);
        } else {
            match.setMatchState(MatchState.PLAYER_TURN);
            view.setItem(8, this.player);
            view.setItem(17, null);
        }
        this.checkWinner(view, match);
    }

    public void turn(InventoryView view, int n, MatchData match) {
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
            Material symbol = match.getMatchState() == MatchState.NOT_STARTED ? MatchState.PLAYER_TURN.getSymbol() : match.getMatchState().getSymbol();
            ItemStack noughtOrCross = match.getMatchState() == MatchState.NOT_STARTED || match.getMatchState() == MatchState.PLAYER_TURN ? this.nought : this.cross;
            view.setItem(this.indexToSlot.get(n).intValue(), noughtOrCross);
            match.getBoard()[n] = symbol;
            match.getUsed()[n] = true;
            this.switchTurn(view, match);
            match.setCount(match.getCount() + 1);
            if (match.getMatchState() == MatchState.TARDIS_TURN) {
                match.setTurn(match.getTurn() + 1);
                this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.tardisTurn(view, match), this.delay);
            }
        }, 5L);
    }

    public void checkWinner(InventoryView view, MatchData match) {
        boolean chk = false;
        for (int i = 0; i < 8; ++i) {
            int j;
            if (match.getBoard()[this.winPos[i][0]].equals((Object)MatchState.PLAYER_TURN.getSymbol()) && match.getBoard()[this.winPos[i][0]].equals((Object)match.getBoard()[this.winPos[i][1]]) && match.getBoard()[this.winPos[i][1]].equals((Object)match.getBoard()[this.winPos[i][2]])) {
                this.setBannerSlots(GameOutcome.WIN, view);
                match.setMatchState(MatchState.PLAYER_WON);
                chk = true;
                for (j = 0; j < 9; ++j) {
                    match.getUsed()[j] = true;
                }
                continue;
            }
            if (!match.getBoard()[this.winPos[i][0]].equals((Object)MatchState.TARDIS_TURN.getSymbol()) || !match.getBoard()[this.winPos[i][0]].equals((Object)match.getBoard()[this.winPos[i][1]]) || !match.getBoard()[this.winPos[i][1]].equals((Object)match.getBoard()[this.winPos[i][2]])) continue;
            this.setBannerSlots(GameOutcome.LOSE, view);
            match.setMatchState(MatchState.TARDIS_WON);
            chk = true;
            for (j = 0; j < 9; ++j) {
                match.getUsed()[j] = true;
            }
        }
        if (match.getCount() == 8 && !chk) {
            this.setBannerSlots(GameOutcome.DRAW, view);
            match.setMatchState(MatchState.DRAW);
            for (int j = 0; j < 9; ++j) {
                match.getUsed()[j] = true;
            }
        }
    }

    public void tardisTurn(InventoryView view, MatchData match) {
        if (match.getMatchState().isGameOver()) {
            return;
        }
        int rand = TARDISConstants.RANDOM.nextInt(9);
        boolean test = true;
        if (match.getC() < 9) {
            if (!match.getUsed()[4]) {
                rand = 4;
            } else if (match.getUsed()[0] && match.getUsed()[1] && !match.getUsed()[2] && (match.getBoard()[0] == MatchState.PLAYER_TURN.getSymbol() && match.getBoard()[1] == MatchState.PLAYER_TURN.getSymbol() || match.getBoard()[0] == MatchState.TARDIS_TURN.getSymbol() && match.getBoard()[1] == MatchState.TARDIS_TURN.getSymbol())) {
                rand = 2;
            } else if (match.getUsed()[1] && match.getUsed()[2] && !match.getUsed()[0] && (match.getBoard()[1] == MatchState.PLAYER_TURN.getSymbol() && match.getBoard()[2] == MatchState.PLAYER_TURN.getSymbol() || match.getBoard()[1] == MatchState.TARDIS_TURN.getSymbol() && match.getBoard()[2] == MatchState.TARDIS_TURN.getSymbol())) {
                rand = 0;
            } else if (match.getUsed()[0] && match.getUsed()[2] && !match.getUsed()[1] && (match.getBoard()[0] == MatchState.PLAYER_TURN.getSymbol() && match.getBoard()[2] == MatchState.PLAYER_TURN.getSymbol() || match.getBoard()[0] == MatchState.TARDIS_TURN.getSymbol() && match.getBoard()[2] == MatchState.TARDIS_TURN.getSymbol())) {
                rand = 1;
            } else if (match.getUsed()[3] && match.getUsed()[4] && !match.getUsed()[5] && (match.getBoard()[3] == MatchState.PLAYER_TURN.getSymbol() && match.getBoard()[4] == MatchState.PLAYER_TURN.getSymbol() || match.getBoard()[3] == MatchState.TARDIS_TURN.getSymbol() && match.getBoard()[4] == MatchState.TARDIS_TURN.getSymbol())) {
                rand = 5;
            } else if (match.getUsed()[4] && match.getUsed()[5] && !match.getUsed()[3] && (match.getBoard()[4] == MatchState.PLAYER_TURN.getSymbol() && match.getBoard()[5] == MatchState.PLAYER_TURN.getSymbol() || match.getBoard()[4] == MatchState.TARDIS_TURN.getSymbol() && match.getBoard()[5] == MatchState.TARDIS_TURN.getSymbol())) {
                rand = 3;
            } else if (match.getUsed()[3] && match.getUsed()[5] && !match.getUsed()[4] && (match.getBoard()[3] == MatchState.PLAYER_TURN.getSymbol() && match.getBoard()[5] == MatchState.PLAYER_TURN.getSymbol() || match.getBoard()[3] == MatchState.TARDIS_TURN.getSymbol() && match.getBoard()[5] == MatchState.TARDIS_TURN.getSymbol())) {
                rand = 4;
            } else if (match.getUsed()[6] && match.getUsed()[7] && !match.getUsed()[8] && (match.getBoard()[6] == MatchState.PLAYER_TURN.getSymbol() && match.getBoard()[7] == MatchState.PLAYER_TURN.getSymbol() || match.getBoard()[6] == MatchState.TARDIS_TURN.getSymbol() && match.getBoard()[7] == MatchState.TARDIS_TURN.getSymbol())) {
                rand = 8;
            } else if (match.getUsed()[7] && match.getUsed()[8] && !match.getUsed()[6] && (match.getBoard()[7] == MatchState.PLAYER_TURN.getSymbol() && match.getBoard()[8] == MatchState.PLAYER_TURN.getSymbol() || match.getBoard()[7] == MatchState.TARDIS_TURN.getSymbol() && match.getBoard()[8] == MatchState.TARDIS_TURN.getSymbol())) {
                rand = 6;
            } else if (match.getUsed()[6] && match.getUsed()[8] && !match.getUsed()[7] && (match.getBoard()[6] == MatchState.PLAYER_TURN.getSymbol() && match.getBoard()[8] == MatchState.PLAYER_TURN.getSymbol() || match.getBoard()[6] == MatchState.TARDIS_TURN.getSymbol() && match.getBoard()[8] == MatchState.TARDIS_TURN.getSymbol())) {
                rand = 7;
            } else if (match.getUsed()[0] && match.getUsed()[3] && !match.getUsed()[6] && (match.getBoard()[0] == MatchState.PLAYER_TURN.getSymbol() && match.getBoard()[3] == MatchState.PLAYER_TURN.getSymbol() || match.getBoard()[0] == MatchState.TARDIS_TURN.getSymbol() && match.getBoard()[3] == MatchState.TARDIS_TURN.getSymbol())) {
                rand = 6;
            } else if (match.getUsed()[3] && match.getUsed()[6] && !match.getUsed()[0] && (match.getBoard()[3] == MatchState.PLAYER_TURN.getSymbol() && match.getBoard()[6] == MatchState.PLAYER_TURN.getSymbol() || match.getBoard()[3] == MatchState.TARDIS_TURN.getSymbol() && match.getBoard()[6] == MatchState.TARDIS_TURN.getSymbol())) {
                rand = 0;
            } else if (match.getUsed()[0] && match.getUsed()[6] && !match.getUsed()[3] && (match.getBoard()[0] == MatchState.PLAYER_TURN.getSymbol() && match.getBoard()[6] == MatchState.PLAYER_TURN.getSymbol() || match.getBoard()[0] == MatchState.TARDIS_TURN.getSymbol() && match.getBoard()[6] == MatchState.TARDIS_TURN.getSymbol())) {
                rand = 3;
            } else if (match.getUsed()[1] && match.getUsed()[4] && !match.getUsed()[7] && (match.getBoard()[1] == MatchState.PLAYER_TURN.getSymbol() && match.getBoard()[4] == MatchState.PLAYER_TURN.getSymbol() || match.getBoard()[1] == MatchState.TARDIS_TURN.getSymbol() && match.getBoard()[4] == MatchState.TARDIS_TURN.getSymbol())) {
                rand = 7;
            } else if (match.getUsed()[4] && match.getUsed()[7] && !match.getUsed()[1] && (match.getBoard()[4] == MatchState.PLAYER_TURN.getSymbol() && match.getBoard()[7] == MatchState.PLAYER_TURN.getSymbol() || match.getBoard()[4] == MatchState.TARDIS_TURN.getSymbol() && match.getBoard()[7] == MatchState.TARDIS_TURN.getSymbol())) {
                rand = 1;
            } else if (match.getUsed()[1] && match.getUsed()[7] && !match.getUsed()[4] && (match.getBoard()[1] == MatchState.PLAYER_TURN.getSymbol() && match.getBoard()[7] == MatchState.PLAYER_TURN.getSymbol() || match.getBoard()[1] == MatchState.TARDIS_TURN.getSymbol() && match.getBoard()[7] == MatchState.TARDIS_TURN.getSymbol())) {
                rand = 4;
            } else if (match.getUsed()[2] && match.getUsed()[5] && !match.getUsed()[8] && (match.getBoard()[2] == MatchState.PLAYER_TURN.getSymbol() && match.getBoard()[5] == MatchState.PLAYER_TURN.getSymbol() || match.getBoard()[2] == MatchState.TARDIS_TURN.getSymbol() && match.getBoard()[5] == MatchState.TARDIS_TURN.getSymbol())) {
                rand = 8;
            } else if (match.getUsed()[5] && match.getUsed()[8] && !match.getUsed()[2] && (match.getBoard()[5] == MatchState.PLAYER_TURN.getSymbol() && match.getBoard()[8] == MatchState.PLAYER_TURN.getSymbol() || match.getBoard()[5] == MatchState.TARDIS_TURN.getSymbol() && match.getBoard()[8] == MatchState.TARDIS_TURN.getSymbol())) {
                rand = 2;
            } else if (match.getUsed()[2] && match.getUsed()[8] && !match.getUsed()[5] && (match.getBoard()[2] == MatchState.PLAYER_TURN.getSymbol() && match.getBoard()[8] == MatchState.PLAYER_TURN.getSymbol() || match.getBoard()[2] == MatchState.TARDIS_TURN.getSymbol() && match.getBoard()[8] == MatchState.TARDIS_TURN.getSymbol())) {
                rand = 5;
            } else if (match.getUsed()[0] && match.getUsed()[4] && !match.getUsed()[8] && (match.getBoard()[0] == MatchState.PLAYER_TURN.getSymbol() && match.getBoard()[4] == MatchState.PLAYER_TURN.getSymbol() || match.getBoard()[0] == MatchState.TARDIS_TURN.getSymbol() && match.getBoard()[4] == MatchState.TARDIS_TURN.getSymbol())) {
                rand = 8;
            } else if (match.getUsed()[4] && match.getUsed()[8] && !match.getUsed()[0] && (match.getBoard()[4] == MatchState.PLAYER_TURN.getSymbol() && match.getBoard()[8] == MatchState.PLAYER_TURN.getSymbol() || match.getBoard()[4] == MatchState.TARDIS_TURN.getSymbol() && match.getBoard()[8] == MatchState.TARDIS_TURN.getSymbol())) {
                rand = 0;
            } else if (match.getUsed()[0] && match.getUsed()[8] && !match.getUsed()[4] && (match.getBoard()[0] == MatchState.PLAYER_TURN.getSymbol() && match.getBoard()[8] == MatchState.PLAYER_TURN.getSymbol() || match.getBoard()[0] == MatchState.TARDIS_TURN.getSymbol() && match.getBoard()[8] == MatchState.TARDIS_TURN.getSymbol())) {
                rand = 4;
            } else if (match.getUsed()[2] && match.getUsed()[4] && !match.getUsed()[6] && (match.getBoard()[2] == MatchState.PLAYER_TURN.getSymbol() && match.getBoard()[4] == MatchState.PLAYER_TURN.getSymbol() || match.getBoard()[2] == MatchState.TARDIS_TURN.getSymbol() && match.getBoard()[4] == MatchState.TARDIS_TURN.getSymbol())) {
                rand = 6;
            } else if (match.getUsed()[4] && match.getUsed()[6] && !match.getUsed()[2] && (match.getBoard()[4] == MatchState.PLAYER_TURN.getSymbol() && match.getBoard()[6] == MatchState.PLAYER_TURN.getSymbol() || match.getBoard()[4] == MatchState.TARDIS_TURN.getSymbol() && match.getBoard()[6] == MatchState.TARDIS_TURN.getSymbol())) {
                rand = 2;
            } else if (match.getUsed()[2] && match.getUsed()[6] && !match.getUsed()[4] && (match.getBoard()[2] == MatchState.PLAYER_TURN.getSymbol() && match.getBoard()[6] == MatchState.PLAYER_TURN.getSymbol() || match.getBoard()[2] == MatchState.TARDIS_TURN.getSymbol() && match.getBoard()[6] == MatchState.TARDIS_TURN.getSymbol())) {
                rand = 4;
            } else {
                while (match.getUsed()[rand] || test) {
                    this.plugin.debug("test");
                    test = false;
                    rand = (int)(Math.random() * 9.0);
                    for (int i : match.getCompUsed()) {
                        if (rand != i) continue;
                        test = true;
                        break;
                    }
                    if (test) continue;
                    match.getCompUsed()[match.getC()] = rand;
                }
            }
            match.getCompUsed()[match.getC()] = rand;
            match.setC(match.getC() + 1);
            match.getUsed()[rand] = true;
            this.checkWinner(view, match);
            this.turn(view, rand, match);
        }
    }

    private void debugBoard(MatchData match) {
        this.plugin.debug("[" + String.valueOf(match.getBoard()[0]) + "][" + String.valueOf(match.getBoard()[1]) + "][" + String.valueOf(match.getBoard()[2]) + "]");
        this.plugin.debug("[" + String.valueOf(match.getBoard()[3]) + "][" + String.valueOf(match.getBoard()[4]) + "][" + String.valueOf(match.getBoard()[5]) + "]");
        this.plugin.debug("[" + String.valueOf(match.getBoard()[6]) + "][" + String.valueOf(match.getBoard()[7]) + "][" + String.valueOf(match.getBoard()[8]) + "]");
    }

    @EventHandler
    public void onTicTacOpen(InventoryOpenEvent event) {
        if (event.getInventory().getHolder(false) instanceof NoughtsAndCrossesInventory) {
            Player p = (Player)event.getPlayer();
            this.matches.put(p.getUniqueId(), new MatchData());
        }
    }

    @EventHandler
    public void onTicTacClose(InventoryCloseEvent event) {
        if (event.getInventory().getHolder(false) instanceof NoughtsAndCrossesInventory) {
            Player p = (Player)event.getPlayer();
            this.matches.remove(p.getUniqueId());
        }
    }

    private void setBannerSlots(GameOutcome state, InventoryView view) {
        for (int i = 36; i < 45; ++i) {
            view.setItem(i, state.getBanners()[i - 36]);
        }
    }
}

