/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.rooms.games.tetris;

import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetGames;
import me.eccentric_nz.TARDIS.rooms.games.ArcadeData;
import me.eccentric_nz.TARDIS.rooms.games.ArcadeTracker;
import me.eccentric_nz.TARDIS.rooms.games.GameLocations;
import me.eccentric_nz.TARDIS.rooms.games.GameState;
import me.eccentric_nz.TARDIS.rooms.games.GameUtils;
import me.eccentric_nz.TARDIS.rooms.games.tetris.Board;
import me.eccentric_nz.TARDIS.rooms.games.tetris.GameSound;
import me.eccentric_nz.TARDIS.rooms.games.tetris.NextPiece;
import me.eccentric_nz.TARDIS.rooms.games.tetris.Pieces;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import net.kyori.adventure.text.Component;
import org.bukkit.Input;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.block.sign.Side;
import org.bukkit.block.sign.SignSide;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInputEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Game
implements Listener {
    private final TARDIS plugin;
    private final Board board;
    private final NextPiece nextPiece;
    private final int startLevel;
    private final Player player;
    private final Location boardLocation;
    private final Location signLocation;
    private final World world;
    private GameState state = GameState.INITIALIZING;
    private Pieces current;
    private int level;
    private int linesClearedLevel;
    private long score;
    private long linesClearedTotal;

    public Game(TARDIS plugin, Player player, int startLevel) {
        this.plugin = plugin;
        this.player = player;
        this.world = plugin.getServer().getWorld("TARDIS_Zero_Room");
        GameLocations locations = this.getRoom(player);
        ArcadeTracker.PLAYERS.put(player.getUniqueId(), new ArcadeData(GameUtils.centre(player.getLocation()), player.getAllowFlight(), this, locations.id()));
        player.setFallDistance(0.0f);
        player.teleport(locations.teleport());
        for (Entity e : locations.teleport().getChunk().getEntities()) {
            if (!(e instanceof ArmorStand)) continue;
            ArmorStand stand = (ArmorStand)e;
            stand.setRotation(0.0f, 0.0f);
            stand.addPassenger((Entity)player);
        }
        player.setFallDistance(0.0f);
        this.boardLocation = locations.board();
        this.signLocation = locations.sign();
        this.board = new Board(10, 20, this);
        for (int y = 0; y < this.board.getHeight(); ++y) {
            for (int x = 0; x < this.board.getWidth(); ++x) {
                Block block = this.world.getBlockAt(this.boardLocation.getBlockX() - x, this.boardLocation.getBlockY() - y, this.boardLocation.getBlockZ());
                block.setType(Material.BLACK_WOOL);
            }
        }
        this.nextPiece = new NextPiece();
        this.startLevel = startLevel;
        this.level = startLevel;
        this.updateScoreboard();
        this.start();
    }

    private GameLocations getRoom(Player player) {
        ResultSetGames rsg;
        int id = this.plugin.getTardisAPI().getIdOfTARDISPlayerIsIn(player.getUniqueId());
        if (id != -1 && (rsg = new ResultSetGames(this.plugin)).fromId(id)) {
            String playerLocation = rsg.getPlayerLocation();
            Location first = TARDISStaticLocationGetters.getLocationFromBukkitString(playerLocation);
            String tetrisLocation = rsg.getTetrisBoard();
            Location second = TARDISStaticLocationGetters.getLocationFromBukkitString(tetrisLocation);
            String tetrisSign = rsg.getTetrisSign();
            Location sign = TARDISStaticLocationGetters.getLocationFromBukkitString(tetrisSign);
            return new GameLocations(first, second, sign, id);
        }
        return null;
    }

    private void updateScoreboard() {
        Sign sign = (Sign)this.signLocation.getBlock().getState();
        SignSide front = sign.getSide(Side.FRONT);
        front.line(0, (Component)Component.text((String)("Level: " + this.level)));
        front.line(1, (Component)Component.text((String)("Lines: " + this.linesClearedTotal)));
        front.line(2, (Component)Component.text((String)"Score:"));
        front.line(3, (Component)Component.text((long)this.score));
        sign.update(true);
    }

    public void drawBoard() {
        if (this.board == null) {
            return;
        }
        for (int y = 0; y < this.board.getHeight(); ++y) {
            for (int x = 0; x < this.board.getWidth(); ++x) {
                this.drawBlock(this.board.get(x, y), x, y);
            }
        }
    }

    public void drawCurrent() {
        if (this.current == null) {
            return;
        }
        for (int y = 0; y < this.current.getShape().length; ++y) {
            for (int x = 0; x < this.current.getShape()[y].length; ++x) {
                byte b = this.current.getShape()[y][x];
                if (b == 0) continue;
                this.drawBlock(b, x + this.current.getXOffset(), y + this.current.getYOffset());
            }
        }
    }

    private void drawBlock(int id, int x, int y) {
        this.world.getBlockAt(this.boardLocation.getBlockX() - x, this.boardLocation.getBlockY() - y, this.boardLocation.getBlockZ()).setType(this.makeColor(id));
    }

    private Material makeColor(int id) {
        return switch (id) {
            case 1 -> Material.WHITE_WOOL;
            case 2 -> {
                switch (this.level % 10) {
                    case 1: {
                        yield Material.LIME_WOOL;
                    }
                    case 2: {
                        yield Material.PINK_WOOL;
                    }
                    case 3: 
                    case 4: {
                        yield Material.GREEN_WOOL;
                    }
                    case 5: {
                        yield Material.CYAN_WOOL;
                    }
                    case 6: {
                        yield Material.YELLOW_WOOL;
                    }
                    case 7: 
                    case 8: {
                        yield Material.RED_WOOL;
                    }
                    case 9: {
                        yield Material.ORANGE_WOOL;
                    }
                }
                yield Material.LIGHT_BLUE_WOOL;
            }
            case 3 -> {
                switch (this.level % 10) {
                    case 1: {
                        yield Material.GREEN_WOOL;
                    }
                    case 2: 
                    case 4: {
                        yield Material.MAGENTA_WOOL;
                    }
                    case 5: {
                        yield Material.LIME_WOOL;
                    }
                    case 6: {
                        yield Material.RED_WOOL;
                    }
                    case 7: {
                        yield Material.PURPLE_WOOL;
                    }
                    case 9: {
                        yield Material.ORANGE_WOOL;
                    }
                }
                yield Material.BLUE_WOOL;
            }
            default -> Material.GRAY_WOOL;
        };
    }

    public void start() {
        if (this.state == GameState.INITIALIZING) {
            this.state = GameState.PLAYING;
            this.updateCurrent();
            new BukkitRunnable(){

                public void run() {
                    if (Game.this.state == GameState.PLAYING) {
                        Game.this.drawBoard();
                        Game.this.drawCurrent();
                    } else {
                        this.cancel();
                    }
                }
            }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
            this.startGravity();
        }
    }

    private void updateCurrent() {
        if (this.state == GameState.GAME_OVER) {
            return;
        }
        this.current = this.nextPiece.getAndUpdate();
        this.current.reset();
        this.current.move(this.board.getWidth() / 2, 0);
        if (this.board.isBlocked(this.current)) {
            this.gameOver();
        }
        this.drawCurrent();
    }

    private void startGravity() {
        new BukkitRunnable(){

            public void run() {
                if (Game.this.state == GameState.PLAYING) {
                    Game.this.moveDown();
                } else {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 100L, this.getGravityDelay());
    }

    private long getGravityDelay() {
        return switch (this.level) {
            case 0 -> 48L;
            case 1 -> 43L;
            case 2 -> 38L;
            case 3 -> 33L;
            case 4 -> 28L;
            case 5 -> 23L;
            case 6 -> 18L;
            case 7 -> 13L;
            case 8 -> 8L;
            case 9 -> 6L;
            default -> 10 <= this.level && this.level < 13 ? 5L : (13 <= this.level && this.level < 16 ? 4L : (16 <= this.level && this.level < 19 ? 3L : (19 <= this.level && this.level < 29 ? 2L : 1L)));
        };
    }

    public void rotateClockwise() {
        if (this.state == GameState.PLAYING && this.current != null) {
            this.current.rotateClockwise();
            if (this.board.isBlocked(this.current)) {
                this.current.rotateCounterClockwise();
            } else {
                this.playSound(GameSound.ROTATE);
            }
        }
    }

    public void rotateCounterClockwise() {
        if (this.state == GameState.PLAYING && this.current != null) {
            this.current.rotateCounterClockwise();
            if (this.board.isBlocked(this.current)) {
                this.current.rotateClockwise();
            } else {
                this.playSound(GameSound.ROTATE);
            }
        }
    }

    public void moveLeft() {
        if (this.state == GameState.PLAYING && this.current != null) {
            this.current.move(-1, 0);
            if (this.board.isBlocked(this.current)) {
                this.current.move(1, 0);
            } else {
                this.playSound(GameSound.MOVE);
            }
        }
    }

    public void moveRight() {
        if (this.state == GameState.PLAYING && this.current != null) {
            this.current.move(1, 0);
            if (this.board.isBlocked(this.current)) {
                this.current.move(-1, 0);
            } else {
                this.playSound(GameSound.MOVE);
            }
        }
    }

    public void moveDown() {
        if (this.state == GameState.PLAYING && this.current != null) {
            this.current.move(0, 1);
            if (this.board.isBlocked(this.current)) {
                this.current.move(0, -1);
                new BukkitRunnable(){

                    public void run() {
                        if (Game.this.current != null && Game.this.board.isPlacable(Game.this.current)) {
                            Game.this.placeCurrent();
                        }
                    }
                }.runTaskLater((Plugin)this.plugin, 10L);
            }
        }
    }

    private void placeCurrent() {
        this.board.place(this.current);
        this.current = null;
        this.updateScoreboard();
        int cleared = this.board.clearFullLines();
        this.linesClearedLevel += cleared;
        this.linesClearedTotal += (long)cleared;
        this.updateScoreboard();
        this.checkTransition();
        this.score += (switch (cleared) {
            case 1 -> 40L;
            case 2 -> 100L;
            case 3 -> 300L;
            case 4 -> 1200L;
            default -> 0L;
        }) * (long)(this.level + 1);
        this.updateScoreboard();
        switch (cleared) {
            case 1: 
            case 2: 
            case 3: {
                this.playSound(GameSound.LINE_CLEAR);
                break;
            }
            case 4: {
                this.playSound(GameSound.TETRIS);
            }
        }
        this.updateCurrent();
    }

    private void checkTransition() {
        if (this.startLevel == this.level) {
            if ((long)this.linesClearedLevel >= (long)this.startLevel * 10L + 10L || this.linesClearedLevel >= Math.max(100, this.startLevel * 10 - 50)) {
                this.transition();
            }
        } else if (this.linesClearedLevel >= 10) {
            this.transition();
        }
    }

    private void transition() {
        if (this.state == GameState.PLAYING) {
            this.playSound(GameSound.LEVEL_UP);
            ++this.level;
            this.updateScoreboard();
            this.linesClearedLevel = 0;
            for (int y = 1; y < 4; ++y) {
                for (int x = 0; x < this.board.getWidth(); ++x) {
                    Block block = this.world.getBlockAt(this.boardLocation.getBlockX() - x, this.boardLocation.getBlockY() + y, this.boardLocation.getBlockZ());
                    block.setType(Material.AIR);
                }
            }
        }
    }

    public void gameOver() {
        this.state = GameState.GAME_OVER;
        new BukkitRunnable(){

            public void run() {
                Game.this.current = null;
                Game.this.playSound(GameSound.GAME_OVER);
                Game.this.board.close();
                Game.this.plugin.getMessenger().message((CommandSender)Game.this.player, "Game Over! Sneak to exit.");
            }
        }.runTaskLater((Plugin)this.plugin, 20L);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerInput(PlayerInputEvent event) {
        Player player = event.getPlayer();
        if (!ArcadeTracker.PLAYERS.containsKey(player.getUniqueId())) {
            return;
        }
        Entity entity = player.getVehicle();
        if (entity instanceof ArmorStand) {
            Input input = event.getInput();
            if (input.isSneak()) {
                this.abort();
            }
            if (input.isJump()) {
                this.rotateCounterClockwise();
            }
            if (input.isLeft()) {
                this.moveLeft();
            }
            if (input.isRight()) {
                this.moveRight();
            }
            if (input.isForward()) {
                this.rotateClockwise();
            }
            if (input.isBackward()) {
                this.moveDown();
            }
        }
    }

    public void abort() {
        if (ArcadeTracker.PLAYERS.containsKey(this.player.getUniqueId())) {
            UUID uuid = this.player.getUniqueId();
            ArcadeData data = ArcadeTracker.PLAYERS.get(uuid);
            this.player.setFallDistance(0.0f);
            this.player.teleport(data.backup());
            this.player.setFallDistance(0.0f);
            this.player.setAllowFlight(data.allowFlight());
            HandlerList.unregisterAll((Listener)this);
            ArcadeTracker.PLAYERS.remove(uuid);
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("tardis_id", data.id());
            where.put("uuid", uuid.toString());
            this.plugin.getQueryFactory().doInsert("travellers", where);
        }
    }

    public void playSound(GameSound gameSound) {
        switch (gameSound) {
            case MOVE: {
                this.player.playSound(this.player.getLocation(), Sound.BLOCK_NOTE_BLOCK_XYLOPHONE, 0.2f, 2.0f);
                break;
            }
            case DROP: {
                this.player.playSound(this.player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 0.2f, 0.0f);
                break;
            }
            case ROTATE: {
                this.player.playSound(this.player.getLocation(), Sound.BLOCK_NOTE_BLOCK_SNARE, 0.1f, 0.9f);
                new BukkitRunnable(){

                    public void run() {
                        Game.this.player.playSound(Game.this.player.getLocation(), Sound.BLOCK_NOTE_BLOCK_SNARE, 0.1f, 0.9f);
                    }
                }.runTaskLater((Plugin)this.plugin, 3L);
                break;
            }
            case LINE_CLEAR: {
                this.player.playSound(this.player.getLocation(), Sound.BLOCK_NOTE_BLOCK_XYLOPHONE, 0.3f, 0.7f);
                new BukkitRunnable(){
                    float p = 1.8f;

                    public void run() {
                        Game.this.player.playSound(Game.this.player.getLocation(), Sound.BLOCK_NOTE_BLOCK_XYLOPHONE, 0.2f, this.p);
                        this.p *= 0.9f;
                        if (this.p < 0.5f) {
                            this.cancel();
                        }
                    }
                }.runTaskTimer((Plugin)this.plugin, 3L, 1L);
                break;
            }
            case TETRIS: {
                new BukkitRunnable(){
                    int i = 0;

                    public void run() {
                        Game.this.player.playSound(Game.this.player.getLocation(), Sound.BLOCK_NOTE_BLOCK_XYLOPHONE, 0.2f, 1.4f + (float)(this.i % 2) * 0.4f);
                        ++this.i;
                        if (this.i > 6) {
                            this.cancel();
                        }
                    }
                }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
                break;
            }
            case LEVEL_UP: {
                new BukkitRunnable(){
                    int i = 0;

                    public void run() {
                        Game.this.player.playSound(Game.this.player.getLocation(), Sound.BLOCK_NOTE_BLOCK_XYLOPHONE, 0.3f, 1.0f + (float)(this.i % 2) * 0.4f);
                        ++this.i;
                        if (this.i == 6) {
                            this.cancel();
                        }
                    }
                }.runTaskTimer((Plugin)this.plugin, 0L, 3L);
                new BukkitRunnable(){
                    int i = 1;

                    public void run() {
                        Game.this.player.playSound(Game.this.player.getLocation(), Sound.BLOCK_NOTE_BLOCK_XYLOPHONE, 0.3f, 1.4f + (float)(this.i % 2) * 0.4f);
                        ++this.i;
                        if (this.i == 5) {
                            this.cancel();
                        }
                    }
                }.runTaskTimer((Plugin)this.plugin, 18L, 3L);
                break;
            }
            case GAME_OVER: {
                new BukkitRunnable(){
                    int i = 0;
                    float v = 0.2f;

                    public void run() {
                        Game.this.player.playSound(Game.this.player.getLocation(), Sound.ENTITY_BLAZE_DEATH, this.v, 0.0f);
                        Game.this.player.playSound(Game.this.player.getLocation(), Sound.BLOCK_TUFF_BREAK, this.v, 0.0f);
                        ++this.i;
                        this.v *= 0.6f;
                        if (this.i > 10) {
                            this.cancel();
                        }
                    }
                }.runTaskTimer((Plugin)this.plugin, 0L, 3L);
            }
        }
    }

    public Plugin getPlugin() {
        return this.plugin;
    }
}

