/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.rooms.games.tetris;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import me.eccentric_nz.TARDIS.rooms.games.tetris.Game;
import me.eccentric_nz.TARDIS.rooms.games.tetris.GameSound;
import me.eccentric_nz.TARDIS.rooms.games.tetris.Pieces;
import org.bukkit.scheduler.BukkitRunnable;

public class Board {
    private final int width;
    private final int height;
    private final byte[][] board;
    private final Game game;

    Board(int width, int height, Game game) {
        this.width = width;
        this.height = height;
        this.board = new byte[height][width];
        this.game = game;
    }

    public boolean isInside(int x, int y) {
        return 0 <= x && x < this.width && 0 <= y && y < this.height;
    }

    private boolean isEmpty(int x, int y) {
        return y < 0 || this.isInside(x, y) && this.board[y][x] == 0;
    }

    public boolean isBlocked(Pieces t) {
        for (int y = 0; y < t.getShape().length; ++y) {
            for (int x = 0; x < t.getShape()[y].length; ++x) {
                if (t.getShape()[y][x] == 0 || this.isEmpty(t.getXOffset() + x, t.getYOffset() + y)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isPlacable(Pieces t) {
        t.move(0, 1);
        if (this.isBlocked(t)) {
            t.move(0, -1);
            return true;
        }
        return false;
    }

    public void place(Pieces t) {
        for (int y = 0; y < t.getShape().length; ++y) {
            for (int x = 0; x < t.getShape()[y].length; ++x) {
                if (t.getShape()[y][x] == 0) continue;
                this.board[t.getYOffset() + y][t.getXOffset() + x] = t.getShape()[y][x];
                this.game.playSound(GameSound.DROP);
            }
        }
    }

    private boolean isFull(int line) {
        for (int x = 0; x < this.width; ++x) {
            if (this.board[line][x] != 0) continue;
            return false;
        }
        return true;
    }

    private void moveDown(int line, int nbLines) {
        for (int x = 0; x < this.width; ++x) {
            this.board[line + nbLines][x] = this.board[line][x];
            this.board[line][x] = 0;
        }
    }

    public int clearFullLines() {
        int cleared = 0;
        final ArrayList<Integer> linesToClear = new ArrayList<Integer>();
        final ArrayList<Integer> linesToMoveDown = new ArrayList<Integer>();
        final HashMap<Integer, Integer> downMap = new HashMap<Integer, Integer>();
        for (int y = this.height - 1; y >= 0; --y) {
            if (this.isFull(y)) {
                linesToClear.add(y);
                ++cleared;
                continue;
            }
            if (cleared <= 0) continue;
            linesToMoveDown.add(y);
            downMap.put(y, cleared);
        }
        if (cleared > 0) {
            new BukkitRunnable(){
                int x;
                {
                    this.x = Board.this.width / 2;
                }

                public void run() {
                    Iterator iterator = linesToClear.iterator();
                    while (iterator.hasNext()) {
                        int y2 = (Integer)iterator.next();
                        Board.this.board[y2][this.x] = 0;
                        Board.this.board[y2][Board.this.width - 1 - this.x] = 0;
                        Board.this.game.drawBoard();
                    }
                    --this.x;
                    if (this.x < 0) {
                        linesToMoveDown.forEach(y -> Board.this.moveDown((int)y, (Integer)downMap.get(y)));
                        this.cancel();
                    }
                }
            }.runTaskTimer(this.game.getPlugin(), 0L, 2L);
        }
        return cleared;
    }

    public void clear() {
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                this.board[y][x] = 0;
            }
        }
    }

    public void close() {
        new BukkitRunnable(){
            int y = 0;

            public void run() {
                for (int x = 0; x < Board.this.width; ++x) {
                    Board.this.board[this.y][x] = (byte)(this.y % 3 + 1);
                }
                Board.this.game.drawBoard();
                ++this.y;
                if (this.y >= Board.this.height) {
                    this.cancel();
                }
            }
        }.runTaskTimer(this.game.getPlugin(), 0L, 4L);
    }

    public int get(int x, int y) {
        return this.board[y][x];
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                s.append(this.board[y][x]).append(" ");
            }
            s.append("\n");
        }
        return s.toString();
    }
}

