/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.rooms.games.connect_four;

import java.util.ArrayList;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.rooms.games.connect_four.Grid;
import org.bukkit.Material;

public class Robot {
    private final Grid grid;

    public Robot(Grid grid) {
        this.grid = grid;
    }

    public int chooseColumn() {
        int winningMove = this.findWinningMove();
        if (winningMove != -1) {
            return winningMove;
        }
        int blockMove = this.blockOpponentWinningMove();
        if (blockMove != -1) {
            return blockMove;
        }
        return this.randomMove();
    }

    private int blockOpponentWinningMove() {
        for (int col = 0; col < 7; ++col) {
            if (!this.grid.isValidMove(col)) continue;
            int row = this.grid.getFirstAvailableRow(col);
            this.grid.setToken(row, col, Material.RED_CONCRETE_POWDER);
            if (this.areFourInLine()) {
                this.grid.removeToken(row, col);
                return col;
            }
            this.grid.removeToken(row, col);
        }
        return -1;
    }

    private int findWinningMove() {
        for (int col = 0; col < 7; ++col) {
            if (!this.grid.isValidMove(col)) continue;
            int row = this.grid.getFirstAvailableRow(col);
            this.grid.setToken(row, col, Material.YELLOW_CONCRETE_POWDER);
            if (this.areFourInLine()) {
                this.grid.removeToken(row, col);
                return col;
            }
            this.grid.removeToken(row, col);
        }
        return -1;
    }

    private int randomMove() {
        ArrayList<Integer> availableColumns = new ArrayList<Integer>();
        for (int col = 0; col < 7; ++col) {
            if (this.grid.isColumnFull(col)) continue;
            availableColumns.add(col);
        }
        if (availableColumns.isEmpty()) {
            return -1;
        }
        int randomIndex = TARDISConstants.RANDOM.nextInt(availableColumns.size());
        return (Integer)availableColumns.get(randomIndex);
    }

    private boolean areFourInLine() {
        return this.grid.checkVertically() || this.grid.checkHorizontally() || this.grid.checkDiagonally();
    }
}

