/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.maze;

import java.util.ArrayDeque;
import me.eccentric_nz.TARDIS.TARDISConstants;

public class MazeGenerator {
    private final boolean[][] field;
    private final ArrayDeque<Integer[]> tracker;
    private final int rows;
    private final int cols;
    private final int act_rows;
    private final int act_cols;

    public MazeGenerator() {
        this.act_rows = 5;
        this.act_cols = 5;
        this.rows = 11;
        this.cols = 11;
        this.field = new boolean[this.rows][this.cols];
        this.tracker = new ArrayDeque(this.rows * this.cols);
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                this.field[i][j] = true;
            }
        }
    }

    private static int[] mix(int[] arr) {
        for (int i = 0; i < 7; ++i) {
            int place1 = TARDISConstants.RANDOM.nextInt(arr.length);
            int place2 = TARDISConstants.RANDOM.nextInt(arr.length);
            int temp = arr[place1];
            arr[place1] = arr[place2];
            arr[place2] = temp;
        }
        return arr;
    }

    public void makeMaze() {
        this.start();
        int not_done = this.stackPeek();
        while (not_done > 0) {
            int[] cut_order = this.canCut();
            if (cut_order[0] != 0) {
                cut_order = MazeGenerator.mix(cut_order);
                switch (cut_order[0]) {
                    case 1: {
                        this.cutNextUp();
                        break;
                    }
                    case 2: {
                        this.cutNextRight();
                        break;
                    }
                    case 3: {
                        this.cutNextDown();
                        break;
                    }
                    case 4: {
                        this.cutNextLeft();
                        break;
                    }
                }
            } else {
                this.back();
            }
            not_done = this.stackPeek();
        }
    }

    public boolean[][] getMaze() {
        return this.field;
    }

    private void start() {
        Integer[] loc = new Integer[2];
        int start_row_index = TARDISConstants.RANDOM.nextInt(this.act_rows - 1) * 2 + 1;
        int start_col_index = TARDISConstants.RANDOM.nextInt(this.act_cols - 1) * 2 + 1;
        loc[0] = start_row_index;
        loc[1] = start_col_index;
        this.tracker.addFirst(loc);
        this.field[start_row_index][start_col_index] = false;
    }

    private int stackPeek() {
        if (this.tracker.peekFirst() == null) {
            return -1;
        }
        return 1;
    }

    private int[] canCut() {
        int[] cut = new int[4];
        int place = 0;
        if (this.canUp() != 0) {
            cut[place] = this.canUp();
            ++place;
        }
        if (this.canRight() != 0) {
            cut[place] = this.canRight();
            ++place;
        }
        if (this.canDown() != 0) {
            cut[place] = this.canDown();
            ++place;
        }
        if (this.canLeft() != 0) {
            cut[place] = this.canLeft();
            ++place;
        }
        if (place == 0) {
            for (int i = 0; i < 4; ++i) {
                cut[i] = 0;
            }
            return cut;
        }
        int[] cancut = new int[place];
        System.arraycopy(cut, 0, cancut, 0, place);
        return cancut;
    }

    private int canUp() {
        Integer[] current = this.tracker.peekFirst();
        int nxt_row = current[0] - 2;
        int nxt_col = current[1];
        if (nxt_row < 0 || !this.field[nxt_row][nxt_col]) {
            return 0;
        }
        return 1;
    }

    private int canDown() {
        Integer[] current = this.tracker.peekFirst();
        int nxt_row = current[0] + 2;
        int nxt_col = current[1];
        if (nxt_row > this.rows - 1 || !this.field[nxt_row][nxt_col]) {
            return 0;
        }
        return 3;
    }

    private int canRight() {
        Integer[] current = this.tracker.peekFirst();
        int nxt_row = current[0];
        int nxt_col = current[1] + 2;
        if (nxt_col > this.cols - 1 || !this.field[nxt_row][nxt_col]) {
            return 0;
        }
        return 2;
    }

    private int canLeft() {
        Integer[] current = this.tracker.peekFirst();
        int nxt_row = current[0];
        int nxt_col = current[1] - 2;
        if (nxt_col < 0 || !this.field[nxt_row][nxt_col]) {
            return 0;
        }
        return 4;
    }

    private void cutNextUp() {
        Integer[] current = this.tracker.peekFirst();
        Integer[] loc = new Integer[2];
        int nxt_row = current[0] - 2;
        int nxt_col = current[1];
        this.field[current[0].intValue() - 1][current[1].intValue()] = false;
        this.field[current[0].intValue() - 2][current[1].intValue()] = false;
        loc[0] = nxt_row;
        loc[1] = nxt_col;
        this.tracker.addFirst(loc);
    }

    private void cutNextDown() {
        Integer[] current = this.tracker.peekFirst();
        Integer[] loc = new Integer[2];
        int nxt_row = current[0] + 2;
        int nxt_col = current[1];
        this.field[current[0].intValue() + 1][current[1].intValue()] = false;
        this.field[current[0].intValue() + 2][current[1].intValue()] = false;
        loc[0] = nxt_row;
        loc[1] = nxt_col;
        this.tracker.addFirst(loc);
    }

    private void cutNextRight() {
        Integer[] current = this.tracker.peekFirst();
        Integer[] loc = new Integer[2];
        int nxt_row = current[0];
        int nxt_col = current[1] + 2;
        this.field[current[0].intValue()][current[1].intValue() + 1] = false;
        this.field[current[0].intValue()][current[1].intValue() + 2] = false;
        loc[0] = nxt_row;
        loc[1] = nxt_col;
        this.tracker.addFirst(loc);
    }

    private void cutNextLeft() {
        Integer[] current = this.tracker.peekFirst();
        Integer[] loc = new Integer[2];
        int nxt_row = current[0];
        int nxt_col = current[1] - 2;
        this.field[current[0].intValue()][current[1].intValue() - 1] = false;
        this.field[current[0].intValue()][current[1].intValue() - 2] = false;
        loc[0] = nxt_row;
        loc[1] = nxt_col;
        this.tracker.addFirst(loc);
    }

    private void back() {
        this.tracker.removeFirst();
    }
}

