/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.listeners;

import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.artron.AdaptiveBoxLampToggler;
import me.eccentric_nz.TARDIS.commands.tardis.HideCommand;
import me.eccentric_nz.TARDIS.commands.tardis.RebuildCommand;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetDoors;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisPreset;
import me.eccentric_nz.TARDIS.doors.inner.InnerDisplayDoorCloser;
import me.eccentric_nz.TARDIS.doors.inner.InnerDisplayDoorOpener;
import me.eccentric_nz.TARDIS.doors.inner.InnerDoor;
import me.eccentric_nz.TARDIS.doors.inner.InnerMinecraftDoorCloser;
import me.eccentric_nz.TARDIS.doors.inner.InnerMinecraftDoorOpener;
import me.eccentric_nz.TARDIS.doors.outer.OuterDisplayDoorCloser;
import me.eccentric_nz.TARDIS.doors.outer.OuterDoor;
import me.eccentric_nz.TARDIS.doors.outer.OuterMinecraftDoorCloser;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.TARDIS.utility.TARDISSounds;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import me.eccentric_nz.TARDIS.utility.TARDISStaticUtils;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class TARDISRemoteKeyListener
implements Listener {
    private final TARDIS plugin;
    private final Material material;

    public TARDISRemoteKeyListener(TARDIS plugin) {
        Material material;
        this.plugin = plugin;
        try {
            material = Material.valueOf((String)plugin.getConfig().getString("preferences.key"));
        }
        catch (IllegalArgumentException e) {
            material = Material.GOLD_NUGGET;
        }
        this.material = material;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onInteract(PlayerInteractEvent event) {
        ItemMeta im;
        if (event.getHand() == null || event.getHand().equals((Object)EquipmentSlot.OFF_HAND)) {
            return;
        }
        Action action = event.getAction();
        Player player = event.getPlayer();
        if (!action.equals((Object)Action.LEFT_CLICK_AIR) && !action.equals((Object)Action.RIGHT_CLICK_AIR) || player.isSneaking()) {
            return;
        }
        ItemStack is = player.getInventory().getItemInMainHand();
        if (!is.getType().equals((Object)Material.OMINOUS_TRIAL_KEY) && !is.getType().equals((Object)this.material)) {
            return;
        }
        if (is.hasItemMeta() && (im = is.getItemMeta()).hasDisplayName() && ComponentUtils.endsWith(im.displayName(), "TARDIS Remote Key")) {
            String uuid = player.getUniqueId().toString();
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("uuid", uuid);
            ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
            if (!rs.resultSet()) {
                return;
            }
            Tardis tardis = rs.getTardis();
            int id = tardis.getTardisId();
            boolean powered = tardis.isPoweredOn();
            ChameleonPreset preset = tardis.getPreset();
            if (this.plugin.getTrackerKeeper().getInSiegeMode().contains(id)) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SIEGE_NO_CONTROL");
                return;
            }
            if (this.plugin.getTrackerKeeper().getDispersedTARDII().contains(id)) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_WHILE_DISPERSED");
                return;
            }
            boolean hidden = tardis.isHidden();
            if (action.equals((Object)Action.LEFT_CLICK_AIR)) {
                ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, id);
                if (!rsc.resultSet()) {
                    return;
                }
                HashMap<String, Object> whered = new HashMap<String, Object>();
                whered.put("tardis_id", id);
                ResultSetDoors rsd = new ResultSetDoors(this.plugin, whered, false);
                if (rsd.resultSet()) {
                    int locked = rsd.isLocked() ? 0 : 1;
                    HashMap<String, Object> setl = new HashMap<String, Object>();
                    setl.put("locked", locked);
                    HashMap<String, Object> wherel = new HashMap<String, Object>();
                    wherel.put("tardis_id", id);
                    this.plugin.getQueryFactory().doUpdate("doors", setl, wherel);
                    String message = rsd.isLocked() ? this.plugin.getLanguage().getString("DOOR_UNLOCK") : this.plugin.getLanguage().getString("DOOR_DEADLOCK");
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "DOOR_LOCK", message);
                    AdaptiveBoxLampToggler tpblt = new AdaptiveBoxLampToggler(this.plugin);
                    TARDISSounds.playTARDISSound(rsc.getCurrent().location(), "tardis_lock");
                    tpblt.toggleLamp(id, !powered, preset);
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> tpblt.toggleLamp(id, powered, preset), 6L);
                }
            } else if (preset.equals((Object)ChameleonPreset.INVISIBLE)) {
                HashMap<String, Object> whered = new HashMap<String, Object>();
                whered.put("tardis_id", id);
                whered.put("door_type", 1);
                ResultSetDoors rsd = new ResultSetDoors(this.plugin, whered, false);
                if (rsd.resultSet()) {
                    Block block = TARDISStaticLocationGetters.getLocationFromDB(rsd.getDoor_location()).getBlock();
                    boolean open = TARDISStaticUtils.isDoorOpen(block);
                    ResultSetTardisPreset rsp = new ResultSetTardisPreset(this.plugin);
                    if (rsp.fromID(id)) {
                        boolean outerDisplayDoor = rsp.getPreset().usesArmourStand();
                        UUID playerUUID = player.getUniqueId();
                        if (open) {
                            innerDisplayDoor = new InnerDoor(this.plugin, id).get();
                            if (innerDisplayDoor.display()) {
                                new InnerDisplayDoorCloser(this.plugin).close(innerDisplayDoor.block(), id, playerUUID, true);
                            } else {
                                new InnerMinecraftDoorCloser(this.plugin).close(innerDisplayDoor.block(), id, playerUUID);
                            }
                            if (outerDisplayDoor) {
                                new OuterDisplayDoorCloser(this.plugin).close(new OuterDoor(this.plugin, id).getDisplay(), id, playerUUID, false);
                            } else if (rsp.getPreset().hasDoor()) {
                                new OuterMinecraftDoorCloser(this.plugin).close(new OuterDoor(this.plugin, id).getMinecraft(), id, playerUUID);
                            }
                        } else {
                            innerDisplayDoor = new InnerDoor(this.plugin, id).get();
                            if (innerDisplayDoor.display()) {
                                new InnerDisplayDoorOpener(this.plugin).open(innerDisplayDoor.block(), id, true);
                            } else {
                                new InnerMinecraftDoorOpener(this.plugin).open(innerDisplayDoor.block(), id);
                            }
                            if (outerDisplayDoor) {
                                new OuterDisplayDoorCloser(this.plugin).close(new OuterDoor(this.plugin, id).getDisplay(), id, playerUUID, false);
                            } else if (rsp.getPreset().hasDoor()) {
                                new OuterMinecraftDoorCloser(this.plugin).close(new OuterDoor(this.plugin, id).getMinecraft(), id, playerUUID);
                            }
                        }
                        String message = open ? "DOOR_CLOSED" : "DOOR_OPENED";
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, message);
                    }
                }
            } else {
                if (this.plugin.getTrackerKeeper().getRebuildCooldown().containsKey(player.getUniqueId())) {
                    long now = System.currentTimeMillis();
                    long cooldown = this.plugin.getConfig().getLong("police_box.rebuild_cooldown");
                    long then = this.plugin.getTrackerKeeper().getRebuildCooldown().get(player.getUniqueId()) + cooldown;
                    if (now < then) {
                        this.plugin.getMessenger().send((CommandSender)player.getPlayer(), TardisModule.TARDIS, "COOLDOWN", String.format("%d", cooldown / 1000L));
                        return;
                    }
                }
                if (!powered) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "POWER_DOWN");
                    return;
                }
                if (hidden) {
                    new RebuildCommand(this.plugin).rebuildPreset((OfflinePlayer)player);
                } else {
                    new HideCommand(this.plugin).hide((OfflinePlayer)player);
                }
            }
        }
    }
}

