/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.forcefield;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetForcefield;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisCompanions;
import me.eccentric_nz.TARDIS.forcefield.ForceFieldVisualiser;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Phantom;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class ForceField
implements Runnable {
    private final TARDIS plugin;
    private final int range;
    private final int doubleRange;
    private int dust = 0;

    public ForceField(TARDIS plugin) {
        this.plugin = plugin;
        this.range = this.plugin.getConfig().getInt("allow.force_field");
        plugin.debug("Starting force fields with a range of " + this.range + " blocks.");
        this.doubleRange = this.range * 2;
    }

    public static Vector getTrajectory2d(Location from, Entity to) {
        return to.getLocation().toVector().subtract(from.toVector()).setY(0).normalize();
    }

    public static Vector getTrajectory3d(Location from, Entity to) {
        return to.getLocation().toVector().subtract(from.toVector()).normalize();
    }

    public static void velocity(Entity ent, Vector vec, double strength) {
        if (Double.isNaN(vec.getX()) || Double.isNaN(vec.getY()) || Double.isNaN(vec.getZ()) || vec.length() == 0.0) {
            return;
        }
        vec.normalize();
        vec.multiply(strength);
        ent.setFallDistance(0.0f);
        ent.setVelocity(vec);
    }

    public static boolean addToTracker(Player player) {
        ResultSetForcefield rsff = new ResultSetForcefield(TARDIS.plugin, player.getUniqueId().toString());
        if (rsff.resultSet()) {
            TARDIS.plugin.getTrackerKeeper().getActiveForceFields().put(rsff.getUuid(), rsff.getLocation());
            return true;
        }
        return false;
    }

    @Override
    public void run() {
        for (Map.Entry<UUID, Location> map : this.plugin.getTrackerKeeper().getActiveForceFields().entrySet()) {
            Player player = this.plugin.getServer().getPlayer(map.getKey());
            if (player == null || !player.isOnline()) continue;
            Location location = map.getValue().clone().add(0.5, 0.5, 0.5);
            new ForceFieldVisualiser(this.plugin).showBorder(location.clone(), this.dust);
            for (Entity other : location.getWorld().getNearbyEntities(location, (double)this.doubleRange, (double)this.doubleRange, (double)this.doubleRange)) {
                if (!(other instanceof LivingEntity) || other instanceof Player && (player.equals((Object)other) || ((Player)other).getGameMode() == GameMode.SPECTATOR || other.hasPermission("tardis.admin") || this.isCompanion((Player)other, player)) || this.offset(other, map.getValue()) > (double)this.range) continue;
                while (other.getVehicle() != null) {
                    other = other.getVehicle();
                }
                ForceField.velocity(other, ForceField.getTrajectory3d(map.getValue(), other), other instanceof Phantom ? 1.5 : 0.5);
                other.getWorld().playSound(other.getLocation(), "tardis_force_field", 0.5f, 1.0f);
            }
            ++this.dust;
            if (this.dust <= 11) continue;
            this.dust = 0;
        }
    }

    private double offset(Entity entity, Location location) {
        return entity.getWorld() != location.getWorld() ? (double)this.range + 999.0 : entity.getLocation().toVector().subtract(location.toVector()).length();
    }

    private boolean isCompanion(Player other, Player player) {
        ResultSetTardisCompanions rs = new ResultSetTardisCompanions(this.plugin);
        if (rs.fromUUID(player.getUniqueId().toString()) && rs.getCompanions() != null && !rs.getCompanions().isEmpty()) {
            if (rs.getCompanions().equalsIgnoreCase("everyone")) {
                return true;
            }
            List<String> comps = List.of(rs.getCompanions().split(":"));
            return comps.contains(other.getUniqueId().toString());
        }
        return false;
    }
}

