/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.resultset;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import org.bukkit.Location;

public class ResultSetInnerDoorLocations {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final int id;
    private final String prefix;
    private Location doorLocation;
    private Location teleportLocation;
    private COMPASS direction;

    public ResultSetInnerDoorLocations(TARDIS plugin, int id) {
        this.plugin = plugin;
        this.id = id;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resultSet() {
        block21: {
            Statement statement = null;
            ResultSet rs = null;
            String query = "SELECT * FROM " + this.prefix + "doors WHERE tardis_id = " + this.id + " AND door_type = 1";
            try {
                this.service.testConnection(this.connection);
                statement = this.connection.prepareStatement(query);
                rs = statement.executeQuery();
                if (rs.isBeforeFirst()) {
                    rs.next();
                    this.doorLocation = TARDISStaticLocationGetters.getLocationFromDB(rs.getString("door_location"));
                    this.teleportLocation = this.doorLocation.clone();
                    this.direction = COMPASS.valueOf(rs.getString("door_direction"));
                    int x = this.doorLocation.getBlockX();
                    int z = this.doorLocation.getBlockZ();
                    switch (this.direction) {
                        case NORTH: {
                            this.teleportLocation.setX((double)x + 0.5);
                            this.teleportLocation.setZ((double)z - 0.5);
                            break;
                        }
                        case EAST: {
                            this.teleportLocation.setX((double)x + 1.5);
                            this.teleportLocation.setZ((double)z + 0.5);
                            break;
                        }
                        case SOUTH: {
                            this.teleportLocation.setX((double)x + 0.5);
                            this.teleportLocation.setZ((double)z + 1.5);
                            break;
                        }
                        default: {
                            this.teleportLocation.setX((double)x - 0.5);
                            this.teleportLocation.setZ((double)z + 0.5);
                            break;
                        }
                    }
                    break block21;
                }
                boolean x = false;
                return x;
            }
            catch (SQLException e) {
                this.plugin.debug("ResultSet error for [interior portal] doors table! " + e.getMessage());
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException e) {
                    this.plugin.debug("Error closing doors [interior portal] table! " + e.getMessage());
                }
            }
        }
        return true;
    }

    public Location getDoorLocation() {
        return this.doorLocation;
    }

    public Location getTeleportLocation() {
        return this.teleportLocation;
    }

    public COMPASS getDirection() {
        return this.direction;
    }
}

