/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.resultset;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;

public class ResultSetGames {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final String prefix;
    private final List<UUID> pongUUIDs = new ArrayList<UUID>();
    private int game_id;
    private String playerLocation;
    private String tetrisBoard;
    private String tetrisSign;

    public ResultSetGames(TARDIS plugin) {
        this.plugin = plugin;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fromId(int id) {
        Statement statement = null;
        ResultSet rs = null;
        String query = "SELECT * FROM " + this.prefix + "games WHERE tardis_id = ?";
        try {
            this.service.testConnection(this.connection);
            statement = this.connection.prepareStatement(query);
            statement.setInt(1, id);
            rs = statement.executeQuery();
            if (rs.isBeforeFirst()) {
                rs.next();
                this.game_id = rs.getInt("game_id");
                this.playerLocation = rs.getString("player_location");
                this.tetrisBoard = rs.getString("tetris_board");
                this.tetrisSign = rs.getString("tetris_sign");
                for (String u : rs.getString("pong_uuids").split(":")) {
                    try {
                        this.pongUUIDs.add(UUID.fromString(u));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException e) {
            this.plugin.debug("ResultSet error for games table! " + e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing games table! " + e.getMessage());
            }
        }
        return false;
    }

    public int getGameId() {
        return this.game_id;
    }

    public String getPlayerLocation() {
        return this.playerLocation;
    }

    public String getTetrisBoard() {
        return this.tetrisBoard;
    }

    public String getTetrisSign() {
        return this.tetrisSign;
    }

    public List<UUID> getPongUUIDs() {
        return this.pongUUIDs;
    }
}

