/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.control.actions;

import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.api.event.TARDISTravelEvent;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.database.data.Current;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTravelledTo;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTravellers;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.enumeration.TravelType;
import me.eccentric_nz.TARDIS.enumeration.WorldManager;
import me.eccentric_nz.TARDIS.flight.TARDISLand;
import me.eccentric_nz.TARDIS.planets.TARDISAliasResolver;
import me.eccentric_nz.TARDIS.travel.TARDISTimeTravel;
import me.eccentric_nz.TARDIS.travel.TravelCostAndType;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class RandomDestinationAction {
    private final TARDIS plugin;

    public RandomDestinationAction(TARDIS plugin) {
        this.plugin = plugin;
    }

    public static void setDestination(TARDIS plugin, Player player, int id, COMPASS direction, int cost, String comps, UUID ownerUUID, Location rand) {
        if (rand != null) {
            if (!plugin.getPlanetsConfig().getBoolean("planets." + rand.getWorld().getName() + ".time_travel")) {
                plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_WORLD_TRAVEL");
                return;
            }
            HashMap<String, Object> set = new HashMap<String, Object>();
            set.put("world", rand.getWorld().getName());
            set.put("x", rand.getBlockX());
            set.put("y", rand.getBlockY());
            set.put("z", rand.getBlockZ());
            set.put("direction", direction.toString());
            set.put("submarine", plugin.getTrackerKeeper().getSubmarine().contains(id) ? 1 : 0);
            plugin.getTrackerKeeper().getSubmarine().remove(id);
            String worldname = !plugin.getPlanetsConfig().getBoolean("planets." + rand.getWorld().getName() + ".enabled") && plugin.getWorldManager().equals((Object)WorldManager.MULTIVERSE) ? plugin.getMVHelper().getAlias(rand.getWorld()) : TARDISAliasResolver.getWorldAlias(rand.getWorld());
            String dchat = worldname + " at x: " + rand.getBlockX() + " y: " + rand.getBlockY() + " z: " + rand.getBlockZ();
            boolean isTL = true;
            if (comps != null && !comps.isEmpty()) {
                String[] companions;
                for (String c : companions = comps.split(":")) {
                    UUID cuuid = UUID.fromString(c);
                    if (plugin.getServer().getPlayer(cuuid) != null && !cuuid.equals(ownerUUID)) {
                        HashMap<String, Object> wherec = new HashMap<String, Object>();
                        wherec.put("tardis_id", id);
                        wherec.put("uuid", c);
                        ResultSetTravellers rsv = new ResultSetTravellers(plugin, wherec, false);
                        if (rsv.resultSet() && !plugin.getConfig().getBoolean("preferences.no_coords")) {
                            plugin.getMessenger().sendStatus(plugin.getServer().getPlayer(cuuid), "DEST", dchat);
                        }
                    }
                    if (!c.equalsIgnoreCase(player.getName())) continue;
                    isTL = false;
                }
            }
            if (!plugin.getConfig().getBoolean("preferences.no_coords")) {
                if (isTL) {
                    plugin.getMessenger().sendStatus(player, "DEST", dchat);
                } else if (plugin.getServer().getPlayer(ownerUUID) != null) {
                    plugin.getMessenger().sendStatus(plugin.getServer().getPlayer(ownerUUID), "DEST", dchat);
                }
            }
            HashMap<String, Object> wherel = new HashMap<String, Object>();
            wherel.put("tardis_id", id);
            plugin.getQueryFactory().doSyncUpdate("next", set, wherel);
            plugin.getTrackerKeeper().getHasDestination().put(id, new TravelCostAndType(cost, TravelType.RANDOM));
            plugin.getTrackerKeeper().getRescue().remove(id);
            if (plugin.getTrackerKeeper().getDestinationVortex().containsKey(id)) {
                new TARDISLand(plugin, id, player).exitVortex();
                plugin.getPM().callEvent((Event)new TARDISTravelEvent(player, null, TravelType.RANDOM, id));
            }
        } else if (plugin.getConfig().getBoolean("travel.no_destination_malfunctions")) {
            plugin.getTrackerKeeper().getMalfunction().put(id, true);
        } else {
            plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "PROTECTED");
        }
    }

    public void getRandomDestination(Player player, int id, int[] repeaters, Current current, COMPASS direction, int level, int cost, String comps, UUID ownerUUID) {
        String environment = "THIS";
        int nether_min = this.plugin.getArtronConfig().getInt("nether_min");
        int the_end_min = this.plugin.getArtronConfig().getInt("the_end_min");
        if (repeaters[0] == -1) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "FLIGHT_BAD");
            return;
        }
        if (repeaters[0] == 1) {
            environment = "THIS";
            if (!this.plugin.getPlanetsConfig().getBoolean("planets." + current.location().getWorld().getName() + ".time_travel")) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_WORLD_TRAVEL");
                return;
            }
        }
        if (repeaters[0] == 2) {
            environment = "NORMAL";
        }
        if (repeaters[0] == 3) {
            environment = "NORMAL";
            if (!this.plugin.getConfig().getBoolean("travel.nether")) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ANCIENT", "Nether");
            } else if (!TARDISPermission.hasPermission(player, "tardis.nether")) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_PERM_TRAVEL", "Nether");
            } else if (this.plugin.getConfig().getBoolean("travel.allow_nether_after_visit") && !new ResultSetTravelledTo(this.plugin).resultSet(player.getUniqueId().toString(), "NETHER")) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TRAVEL_NOT_VISITED", "Nether");
            } else if (level < nether_min) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_ENOUGH_TRAVEL_ENERGY", String.format("%d", nether_min), "Nether");
            } else {
                environment = "NETHER";
            }
        }
        if (repeaters[0] == 4) {
            environment = "NORMAL";
            if (!this.plugin.getConfig().getBoolean("travel.the_end")) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ANCIENT", "End");
            } else if (!TARDISPermission.hasPermission(player, "tardis.end")) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_PERM_TRAVEL", "End");
            } else if (this.plugin.getConfig().getBoolean("travel.allow_end_after_visit") && !new ResultSetTravelledTo(this.plugin).resultSet(player.getUniqueId().toString(), "THE_END")) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TRAVEL_NOT_VISITED", "End");
            } else if (level < the_end_min) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_ENOUGH_TRAVEL_ENERGY", String.format("%d", the_end_min), "End");
            } else {
                environment = "THE_END";
            }
        }
        TARDISTimeTravel tt = new TARDISTimeTravel(this.plugin);
        Location rand = tt.randomDestination(player, repeaters[1], repeaters[2], repeaters[3], direction, environment, current.location().getWorld(), false, current.location());
        RandomDestinationAction.setDestination(this.plugin, player, id, direction, cost, comps, ownerUUID, rand);
    }
}

