/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.preferences;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

class SetKeyCommand {
    private final TARDIS plugin;
    private final List<Material> keys = new ArrayList<Material>();

    SetKeyCommand(TARDIS plugin) {
        this.plugin = plugin;
        plugin.getBlocksConfig().getStringList("keys").forEach(m -> {
            try {
                this.keys.add(Material.valueOf((String)m));
            }
            catch (IllegalArgumentException e) {
                plugin.debug("Illegal Key value!");
            }
        });
    }

    boolean setKeyPref(Player player, String[] args) {
        Material go;
        if (args.length < 2) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "KEY_NEED");
            return false;
        }
        String setMaterial = args[1].toUpperCase(Locale.ROOT);
        try {
            go = Material.valueOf((String)setMaterial);
        }
        catch (IllegalArgumentException e) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "MATERIAL_NOT_VALID");
            return false;
        }
        if (go.isBlock()) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "KEY_NO_BLOCK");
            return true;
        }
        if (this.plugin.getConfig().getBoolean("travel.give_key") && !this.plugin.getConfig().getBoolean("allow.all_blocks") && !this.keys.contains(go)) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "MATERIAL_NOT_VALID");
            return true;
        }
        String field = this.plugin.getConfig().getString("storage.database").equals("sqlite") ? "key" : "key_item";
        HashMap<String, Object> setk = new HashMap<String, Object>();
        setk.put(field, setMaterial);
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("uuid", player.getUniqueId().toString());
        this.plugin.getQueryFactory().doUpdate("player_prefs", setk, where);
        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "KEY_SAVED");
        return true;
    }
}

