/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.artron;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetPlayerPrefs;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisArtron;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.TARDIS.utility.TARDISNumberParsers;
import net.kyori.adventure.text.Component;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class TARDISArtronStorageCommand
implements CommandExecutor {
    private final TARDIS plugin;
    private final List<String> firstArgs = new ArrayList<String>();

    public TARDISArtronStorageCommand(TARDIS plugin) {
        this.plugin = plugin;
        this.firstArgs.add("tardis");
        this.firstArgs.add("timelord");
        this.firstArgs.add("combine");
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("tardisartron")) {
            if (!TARDISPermission.hasPermission(sender, "tardis.store")) {
                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "NO_PERMS");
                return true;
            }
            Player player = null;
            if (sender instanceof Player) {
                player = (Player)sender;
            }
            if (player == null) {
                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "CMD_PLAYER");
                return true;
            }
            ItemStack is = player.getInventory().getItemInMainHand();
            if (!is.hasItemMeta()) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CELL_IN_HAND");
                return true;
            }
            if (is.getAmount() > 1) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CELL_ONE");
                return true;
            }
            ItemMeta im = is.getItemMeta();
            if (!im.hasDisplayName() || !ComponentUtils.endsWith(im.displayName(), "Artron Storage Cell")) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CELL_IN_HAND");
                return true;
            }
            String which = args[0].toLowerCase(Locale.ROOT);
            if (!this.firstArgs.contains(which)) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CELL_WHICH");
                return false;
            }
            int max = this.plugin.getArtronConfig().getInt("full_charge");
            if (args.length == 1 && args[0].equalsIgnoreCase("combine")) {
                ItemStack offhand = player.getInventory().getItemInOffHand();
                if (!offhand.hasItemMeta()) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CELL_IN_HAND");
                    return true;
                }
                if (is.getAmount() > 1) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CELL_ONE");
                    return true;
                }
                ItemMeta offMeta = offhand.getItemMeta();
                if (!offMeta.hasDisplayName() || !ComponentUtils.endsWith(offMeta.displayName(), "Artron Storage Cell")) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CELL_IN_HAND");
                    return true;
                }
                int mainLevel = this.getLevel(im);
                int offLevel = this.getLevel(offMeta);
                if (mainLevel <= 0 || offLevel <= 0) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CELL_NOT_CHARGED");
                    return true;
                }
                int combined = mainLevel + offLevel;
                int remainder = 0;
                if (combined > max) {
                    remainder = combined - max;
                    combined = max;
                }
                this.setLevel(is, im, combined, player, true);
                this.setLevel(offhand, offMeta, remainder, player, false);
            } else {
                String table;
                int new_amount;
                List lore;
                int level;
                int amount;
                int current_level;
                if (args.length < 2) {
                    return false;
                }
                String playerUUID = player.getUniqueId().toString();
                if (which.equals("tardis")) {
                    rs = new ResultSetTardisArtron(this.plugin);
                    if (!((ResultSetTardisArtron)rs).fromUUID(playerUUID)) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_TARDIS");
                        return true;
                    }
                    current_level = ((ResultSetTardisArtron)rs).getArtronLevel();
                } else {
                    rs = new ResultSetPlayerPrefs(this.plugin, playerUUID);
                    if (!((ResultSetPlayerPrefs)rs).resultSet()) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_TARDIS");
                        return true;
                    }
                    current_level = ((ResultSetPlayerPrefs)rs).getArtronLevel();
                }
                try {
                    amount = Integer.parseInt(args[1]);
                    if (amount < 0) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ENERGY_NOT_NEG");
                        return true;
                    }
                }
                catch (NumberFormatException n) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ARG_SEC_NUMBER");
                    return false;
                }
                if (which.equals("tardis")) {
                    if (current_level - amount < this.plugin.getArtronConfig().getInt("comehere")) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CELL_NO_TRANSFER");
                        return true;
                    }
                } else if (current_level - amount < 0) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CELL_NOT_ENOUGH");
                    return true;
                }
                if ((level = TARDISNumberParsers.parseInt(ComponentUtils.stripColour((Component)(lore = im.lore()).get(1)))) < 0) {
                    level = 0;
                }
                if ((new_amount = amount + level) > max) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CELL_NO_CHARGE", String.format("%d", max - level));
                    return false;
                }
                lore.set(1, Component.text((int)new_amount));
                im.lore(lore);
                im.setEnchantmentGlintOverride(Boolean.valueOf(true));
                im.addItemFlags(ItemFlag.values());
                im.setAttributeModifiers((Multimap)Multimaps.forMap(Map.of()));
                is.setItemMeta(im);
                HashMap<String, Object> where = new HashMap<String, Object>();
                if (which.equals("tardis")) {
                    where.put("uuid", playerUUID);
                    table = "tardis";
                } else {
                    where.put("uuid", playerUUID);
                    table = "player_prefs";
                }
                this.plugin.getQueryFactory().alterEnergyLevel(table, -amount, where, player);
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CELL_CHARGED", String.format("%d", new_amount));
            }
            return true;
        }
        return false;
    }

    private int getLevel(ItemMeta im) {
        String lore = ComponentUtils.stripColour((Component)im.lore().get(1));
        return TARDISNumberParsers.parseInt(lore);
    }

    private void setLevel(ItemStack is, ItemMeta im, int level, Player player, boolean main) {
        List lore = im.lore();
        lore.set(1, Component.text((int)level));
        im.lore(lore);
        if (main && !im.hasEnchantmentGlintOverride()) {
            im.removeEnchant(Enchantment.UNBREAKING);
            im.setEnchantmentGlintOverride(Boolean.valueOf(true));
        }
        if (main) {
            is.setItemMeta(im);
            player.getInventory().setItemInMainHand(is);
        } else {
            if (level <= 0) {
                is.getEnchantments().keySet().forEach(arg_0 -> ((ItemStack)is).removeEnchantment(arg_0));
                im.setEnchantmentGlintOverride(null);
                is.setItemMeta(im);
            }
            player.getInventory().setItemInOffHand(is);
        }
    }
}

