/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.areas;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.regex.Pattern;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.areas.EditAreasInventory;
import me.eccentric_nz.TARDIS.commands.TARDISCommandHelper;
import me.eccentric_nz.TARDIS.database.data.Area;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetAreas;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.planets.TARDISAliasResolver;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class TARDISAreaCommands
implements CommandExecutor {
    private static final Pattern LETTERS_NUMBERS = Pattern.compile("[A-Za-z0-9_]{2,16}");
    private final TARDIS plugin;

    public TARDISAreaCommands(TARDIS plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!sender.hasPermission("tardis.admin")) {
            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "NO_PERM_AREA");
            return true;
        }
        Player player = null;
        if (sender instanceof Player) {
            player = (Player)sender;
        }
        if (cmd.getName().equalsIgnoreCase("tardisarea")) {
            String first;
            if (args.length == 0) {
                new TARDISCommandHelper(this.plugin).getCommand("tardisarea", sender);
                return true;
            }
            if (player == null) {
                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "CMD_PLAYER");
                return false;
            }
            switch (first = args[0].toLowerCase(Locale.ROOT)) {
                case "start": {
                    if (args.length < 2 || !LETTERS_NUMBERS.matcher(args[1]).matches()) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "AREA_NAME_NOT_VALID");
                        return false;
                    }
                    ResultSetAreas rsa = new ResultSetAreas(this.plugin, null, false, true);
                    if (rsa.resultSet()) {
                        for (String s : rsa.getNames()) {
                            if (!s.equals(args[1])) continue;
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "AREA_IN_USE");
                            return false;
                        }
                    }
                    this.plugin.getTrackerKeeper().getArea().put(player.getUniqueId(), args[1]);
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "AREA_CLICK_START");
                    return true;
                }
                case "end": {
                    if (!this.plugin.getTrackerKeeper().getAreaStartBlock().containsKey(player.getUniqueId())) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "AREA_NO_START");
                        return false;
                    }
                    this.plugin.getTrackerKeeper().getAreaEndBlock().put(player.getUniqueId(), "end");
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "AREA_CLICK_END");
                    return true;
                }
                case "parking": {
                    int park;
                    if (args.length < 2) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "AREA_NEED");
                        return false;
                    }
                    if (args.length < 3) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "AREA_PARK");
                        return false;
                    }
                    try {
                        park = Integer.parseInt(args[2]);
                    }
                    catch (NumberFormatException nfe) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "AREA_PARK");
                        return false;
                    }
                    HashMap<String, Object> where = new HashMap<String, Object>();
                    where.put("area_name", args[1]);
                    HashMap<String, Object> set = new HashMap<String, Object>();
                    set.put("parking_distance", park);
                    this.plugin.getQueryFactory().doUpdate("areas", set, where);
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "AREA_PARK_SET", args[1]);
                    return true;
                }
                case "remove": {
                    if (args.length < 2) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "AREA_NEED");
                        return false;
                    }
                    HashMap<String, Object> wherer = new HashMap<String, Object>();
                    wherer.put("area_name", args[1]);
                    this.plugin.getQueryFactory().doDelete("areas", wherer);
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "AREA_DELETE", args[1]);
                    return true;
                }
                case "show": {
                    if (args.length < 2) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "AREA_NEED");
                        return false;
                    }
                    HashMap<String, Object> wherea = new HashMap<String, Object>();
                    wherea.put("area_name", args[1]);
                    ResultSetAreas rsaShow = new ResultSetAreas(this.plugin, wherea, false, false);
                    if (!rsaShow.resultSet()) {
                        this.plugin.getMessenger().sendColouredCommand((CommandSender)player, "AREA_NOT_FOUND", "/tardis list areas", this.plugin);
                        return false;
                    }
                    if (!rsaShow.getArea().grid()) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "AREA_SHOW_NONGRID");
                        return true;
                    }
                    Area a = rsaShow.getArea();
                    int mix = a.minX();
                    int miz = a.minZ();
                    int max = a.maxX();
                    int maz = a.maxZ();
                    World w = TARDISAliasResolver.getWorldFromAlias(a.world());
                    HashSet<Block> markers = new HashSet<Block>();
                    markers.add(w.getHighestBlockAt(mix, miz).getRelative(BlockFace.UP));
                    markers.add(w.getHighestBlockAt(mix, maz).getRelative(BlockFace.UP));
                    markers.add(w.getHighestBlockAt(max, miz).getRelative(BlockFace.UP));
                    markers.add(w.getHighestBlockAt(max, maz).getRelative(BlockFace.UP));
                    for (Block block : markers) {
                        player.sendBlockChange(block.getLocation(), TARDISConstants.SNOW_BLOCK);
                    }
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                        for (Block block : markers) {
                            block.getState().update();
                        }
                    }, 300L);
                    return true;
                }
                case "yard": {
                    if (args.length < 2) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "AREA_NEED");
                        return false;
                    }
                    BlockData fill = Material.COBBLESTONE.createBlockData();
                    BlockData dock = Material.STONE_BRICKS.createBlockData();
                    if (args.length > 2) {
                        try {
                            fill = Material.valueOf((String)args[2].toUpperCase(Locale.ROOT)).createBlockData();
                            if (args.length > 3) {
                                dock = Material.valueOf((String)args[3].toUpperCase(Locale.ROOT)).createBlockData();
                            }
                        }
                        catch (IllegalArgumentException e) {
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ARG_MATERIAL");
                            return true;
                        }
                        if (!(fill.getMaterial().isBlock() && dock.getMaterial().isBlock() && fill.getMaterial().isSolid() && dock.getMaterial().isSolid())) {
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ARG_NOT_BLOCK");
                            return true;
                        }
                    }
                    HashMap<String, Object> yardWhere = new HashMap<String, Object>();
                    yardWhere.put("area_name", args[1]);
                    ResultSetAreas rsaYard = new ResultSetAreas(this.plugin, yardWhere, false, false);
                    if (!rsaYard.resultSet()) {
                        this.plugin.getMessenger().sendColouredCommand((CommandSender)player, "AREA_NOT_FOUND", "/tardis list areas", this.plugin);
                        return false;
                    }
                    Area yardArea = rsaYard.getArea();
                    int yardMinX = yardArea.minX();
                    int yardMinZ = yardArea.minZ();
                    int yardMaxX = yardArea.maxX();
                    int yardMaxZ = yardArea.maxZ();
                    World yardWorld = TARDISAliasResolver.getWorldFromAlias(yardArea.world());
                    for (int x = yardMinX; x <= yardMaxX; ++x) {
                        for (int z = yardMinZ; z <= yardMaxZ; ++z) {
                            int y = yardWorld.getHighestBlockYAt(x, z);
                            if ((x - 2) % 5 == 0 && (z - 2) % 5 == 0) {
                                yardWorld.getBlockAt(x, y, z).setBlockData(dock);
                                continue;
                            }
                            yardWorld.getBlockAt(x, y, z).setBlockData(fill);
                        }
                    }
                    return true;
                }
                case "invisibility": {
                    if (args.length < 2) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "AREA_NEED");
                        return false;
                    }
                    if (args.length < 3) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "AREA_INVISIBILITY_ARG");
                        return false;
                    }
                    HashMap<String, Object> invisWhere = new HashMap<String, Object>();
                    invisWhere.put("area_name", args[1]);
                    ResultSetAreas rsaInvis = new ResultSetAreas(this.plugin, invisWhere, false, false);
                    if (!rsaInvis.resultSet()) {
                        this.plugin.getMessenger().sendColouredCommand((CommandSender)player, "AREA_NOT_FOUND", "/tardis list areas", this.plugin);
                        return false;
                    }
                    String value = args[2].toUpperCase(Locale.ROOT);
                    if (!value.equals("ALLOW") && !value.equals("DENY")) {
                        try {
                            ChameleonPreset.valueOf(value);
                        }
                        catch (IllegalArgumentException e) {
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ARG_PRESET");
                            return false;
                        }
                    }
                    HashMap<String, Object> invisSet = new HashMap<String, Object>();
                    invisSet.put("invisibility", value);
                    HashMap<String, Object> whereInvis = new HashMap<String, Object>();
                    whereInvis.put("area_name", args[1]);
                    this.plugin.getQueryFactory().doUpdate("areas", invisSet, whereInvis);
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "AREA_INVISIBILITY_SET", args[1]);
                    return true;
                }
                case "direction": {
                    if (args.length < 2) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "AREA_NEED");
                        return false;
                    }
                    if (args.length < 3) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "AREA_DIRECTION_ARG");
                        return false;
                    }
                    HashMap<String, Object> dirWhere = new HashMap<String, Object>();
                    dirWhere.put("area_name", args[1]);
                    ResultSetAreas rsaDir = new ResultSetAreas(this.plugin, dirWhere, false, false);
                    if (!rsaDir.resultSet()) {
                        this.plugin.getMessenger().sendColouredCommand((CommandSender)player, "AREA_NOT_FOUND", "/tardis list areas", this.plugin);
                        return false;
                    }
                    String dir = args[2].toUpperCase(Locale.ROOT);
                    try {
                        COMPASS.valueOf(dir);
                    }
                    catch (IllegalArgumentException e) {
                        if (dir.equals("NONE")) {
                            dir = "";
                        }
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ARG_COMPASS");
                        return false;
                    }
                    HashMap<String, Object> dirSet = new HashMap<String, Object>();
                    dirSet.put("direction", dir);
                    HashMap<String, Object> whereDir = new HashMap<String, Object>();
                    whereDir.put("area_name", args[1]);
                    this.plugin.getQueryFactory().doUpdate("areas", dirSet, whereDir);
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "AREA_DIRECTION_SET", args[1]);
                    return true;
                }
                case "create": {
                    if (args.length < 2 || !LETTERS_NUMBERS.matcher(args[1]).matches()) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "AREA_NAME_NOT_VALID");
                        return false;
                    }
                    ResultSetAreas rsa = new ResultSetAreas(this.plugin, null, false, true);
                    if (rsa.resultSet()) {
                        for (String s : rsa.getNames()) {
                            if (!s.equals(args[1])) continue;
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "AREA_IN_USE");
                            return false;
                        }
                    }
                    HashMap<String, Object> create = new HashMap<String, Object>();
                    create.put("area_name", args[1]);
                    create.put("world", player.getLocation().getWorld().getName());
                    create.put("grid", 0);
                    this.plugin.getQueryFactory().doInsert("areas", create);
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "AREA_SAVED", args[1]);
                    return true;
                }
                case "add": 
                case "edit": {
                    if (args.length < 2) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "AREA_NEED");
                        return false;
                    }
                    HashMap<String, Object> wherea = new HashMap<String, Object>();
                    wherea.put("area_name", args[1]);
                    ResultSetAreas rsaId = new ResultSetAreas(this.plugin, wherea, false, false);
                    if (!rsaId.resultSet()) {
                        this.plugin.getMessenger().sendColouredCommand((CommandSender)player, "AREA_NOT_FOUND", "/tardis list areas", this.plugin);
                        return false;
                    }
                    if (rsaId.getArea().grid()) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "AREA_NOT_GRID");
                        return true;
                    }
                    if (first.equals("edit")) {
                        player.openInventory(new EditAreasInventory(this.plugin, rsaId.getArea().areaId()).getInventory());
                    } else {
                        Location location = player.getLocation();
                        HashMap<String, Object> add = new HashMap<String, Object>();
                        add.put("area_id", rsaId.getArea().areaId());
                        add.put("world", location.getWorld().getName());
                        add.put("x", location.getBlockX());
                        add.put("y", location.getBlockY());
                        add.put("z", location.getBlockZ());
                        this.plugin.getQueryFactory().doInsert("area_locations", add);
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "AREA_ADD_LOCATION", args[1]);
                    }
                    return true;
                }
            }
            return false;
        }
        return false;
    }
}

