/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.admin;

import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.arch.TARDISArchCommand;
import me.eccentric_nz.TARDIS.commands.TARDISCommandHelper;
import me.eccentric_nz.TARDIS.commands.admin.CleanEntitiesCommand;
import me.eccentric_nz.TARDIS.commands.admin.CondenserCommand;
import me.eccentric_nz.TARDIS.commands.admin.CreateAbandonedCommand;
import me.eccentric_nz.TARDIS.commands.admin.CreateTARDISCommand;
import me.eccentric_nz.TARDIS.commands.admin.DechargeCommand;
import me.eccentric_nz.TARDIS.commands.admin.DeleteTARDISCommand;
import me.eccentric_nz.TARDIS.commands.admin.DisguiseCommand;
import me.eccentric_nz.TARDIS.commands.admin.DispersedCommand;
import me.eccentric_nz.TARDIS.commands.admin.EnterCommand;
import me.eccentric_nz.TARDIS.commands.admin.FindHiddenCommand;
import me.eccentric_nz.TARDIS.commands.admin.ListCommand;
import me.eccentric_nz.TARDIS.commands.admin.MakePresetCommand;
import me.eccentric_nz.TARDIS.commands.admin.PlayerCountCommand;
import me.eccentric_nz.TARDIS.commands.admin.PortalCommand;
import me.eccentric_nz.TARDIS.commands.admin.PruneCommand;
import me.eccentric_nz.TARDIS.commands.admin.PurgeCommand;
import me.eccentric_nz.TARDIS.commands.admin.RechargerCommand;
import me.eccentric_nz.TARDIS.commands.admin.RemoveProtectionCommand;
import me.eccentric_nz.TARDIS.commands.admin.RepairCommand;
import me.eccentric_nz.TARDIS.commands.admin.RevokeCommand;
import me.eccentric_nz.TARDIS.commands.admin.SetSizeCommand;
import me.eccentric_nz.TARDIS.commands.dev.AddRegionsCommand;
import me.eccentric_nz.TARDIS.database.tool.Converter;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.maze.MazeBuilder;
import me.eccentric_nz.TARDIS.maze.MazeGenerator;
import me.eccentric_nz.TARDIS.utility.update.UpdateTARDISPlugins;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class TARDISAdminCommands
implements CommandExecutor {
    private final Set<String> firstsStr = new HashSet<String>();
    private final TARDIS plugin;

    public TARDISAdminCommands(TARDIS plugin) {
        this.plugin = plugin;
        this.firstsStr.add("add_regions");
        this.firstsStr.add("arch");
        this.firstsStr.add("assemble");
        this.firstsStr.add("clean");
        this.firstsStr.add("condenser");
        this.firstsStr.add("convert_database");
        this.firstsStr.add("create");
        this.firstsStr.add("decharge");
        this.firstsStr.add("delete");
        this.firstsStr.add("disguise");
        this.firstsStr.add("dispersed");
        this.firstsStr.add("enter");
        this.firstsStr.add("find");
        this.firstsStr.add("list");
        this.firstsStr.add("make_preset");
        this.firstsStr.add("maze");
        this.firstsStr.add("mvimport");
        this.firstsStr.add("playercount");
        this.firstsStr.add("prune");
        this.firstsStr.add("prunelist");
        this.firstsStr.add("purge");
        this.firstsStr.add("purge_portals");
        this.firstsStr.add("recharger");
        this.firstsStr.add("region_flag");
        this.firstsStr.add("reload");
        this.firstsStr.add("remove_protection");
        this.firstsStr.add("repair");
        this.firstsStr.add("revoke");
        this.firstsStr.add("set_size");
        this.firstsStr.add("spawn_abandoned");
        this.firstsStr.add("undisguise");
        this.firstsStr.add("update_plugin");
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("tardisadmin")) {
            if (sender instanceof ConsoleCommandSender || sender.hasPermission("tardis.admin")) {
                if (args.length == 0) {
                    new TARDISCommandHelper(this.plugin).getCommand("tardisadmin", sender);
                    return true;
                }
                String first = args[0].toLowerCase(Locale.ROOT);
                if (!this.firstsStr.contains(first)) {
                    this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "ARG_NOT_VALID");
                    return false;
                }
                if (args.length == 1) {
                    switch (first) {
                        case "add_regions": {
                            return new AddRegionsCommand(this.plugin).doCheck(sender);
                        }
                        case "clean": {
                            return new CleanEntitiesCommand(this.plugin).checkAndRemove(sender);
                        }
                        case "condenser": {
                            return new CondenserCommand(this.plugin).set(sender);
                        }
                        case "convert_database": {
                            try {
                                this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, (Runnable)new Converter(this.plugin, sender));
                                return true;
                            }
                            catch (Exception e) {
                                this.plugin.getMessenger().message(sender, "Database conversion failed! " + e.getMessage());
                                return true;
                            }
                        }
                        case "maze": {
                            if (sender instanceof Player) {
                                Player p = (Player)sender;
                                Location l = p.getTargetBlock(this.plugin.getGeneralKeeper().getTransparent(), 16).getRelative(BlockFace.UP).getLocation();
                                MazeGenerator generator = new MazeGenerator();
                                generator.makeMaze();
                                MazeBuilder builder = new MazeBuilder(generator.getMaze(), l);
                                builder.build(false);
                            }
                            return true;
                        }
                        case "mvimport": {
                            if (!this.plugin.getServer().getPluginManager().isPluginEnabled("Multiverse-Core")) {
                                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "MULTIVERSE_ENABLED");
                            }
                            this.plugin.getMVHelper().importWorlds(sender);
                            return true;
                        }
                        case "update_plugin": {
                            if (!sender.isOp()) {
                                this.plugin.getMessenger().message(sender, "You must be a server operator to run this command!");
                                return true;
                            }
                            return new UpdateTARDISPlugins(this.plugin).fetchFromGitHub(sender);
                        }
                    }
                }
                switch (first) {
                    case "create": {
                        return new CreateTARDISCommand(this.plugin).buildTARDIS(sender, args);
                    }
                    case "find": {
                        return new FindHiddenCommand().search(this.plugin, sender, args);
                    }
                    case "remove_protection": {
                        return new RemoveProtectionCommand(this.plugin).remove(args);
                    }
                    case "list": {
                        return new ListCommand(this.plugin).listStuff(sender, args);
                    }
                    case "purge_portals": {
                        return new PortalCommand(this.plugin).clearAll(sender);
                    }
                    case "undisguise": {
                        return new DisguiseCommand(this.plugin).disguise(sender, args);
                    }
                }
                if (args.length < 2) {
                    this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "TOO_FEW_ARGS");
                    return false;
                }
                switch (first) {
                    case "arch": {
                        if (args.length > 2) {
                            return new TARDISArchCommand(this.plugin).force(sender, args);
                        }
                        return new TARDISArchCommand(this.plugin).whois(sender, args);
                    }
                    case "assemble": 
                    case "dispersed": {
                        return new DispersedCommand(this.plugin).assemble(sender, args[1]);
                    }
                    case "set_size": {
                        return new SetSizeCommand(this.plugin).overwrite(sender, args);
                    }
                    case "spawn_abandoned": {
                        return new CreateAbandonedCommand(this.plugin).spawn(sender, args);
                    }
                    case "make_preset": {
                        return new MakePresetCommand(this.plugin).scanBlocks(sender, args);
                    }
                    case "playercount": {
                        return new PlayerCountCommand(this.plugin).countPlayers(sender, args);
                    }
                    case "prune": {
                        return new PruneCommand(this.plugin).startPruning(sender, args);
                    }
                    case "prunelist": {
                        return new PruneCommand(this.plugin).listPrunes(sender, args);
                    }
                    case "purge": {
                        return new PurgeCommand(this.plugin).clearAll(sender, args);
                    }
                    case "recharger": {
                        return new RechargerCommand(this.plugin).setRecharger(sender, args);
                    }
                    case "decharge": {
                        return new DechargeCommand(this.plugin).removeChargerStatus(sender, args);
                    }
                    case "disguise": {
                        return new DisguiseCommand(this.plugin).disguise(sender, args);
                    }
                    case "enter": {
                        return new EnterCommand(this.plugin).enterTARDIS(sender, args);
                    }
                    case "delete": {
                        return new DeleteTARDISCommand(this.plugin).deleteTARDIS(sender, args);
                    }
                    case "repair": {
                        return new RepairCommand(this.plugin).setFreeCount(sender, args);
                    }
                    case "revoke": {
                        return new RevokeCommand(this.plugin).removePermission(sender, args);
                    }
                }
                return true;
            }
            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "CMD_ADMIN");
            return false;
        }
        return false;
    }
}

