/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands;

import com.google.common.collect.ImmutableList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.commands.TARDISCompleter;
import me.eccentric_nz.TARDIS.enumeration.RecipeCategory;
import me.eccentric_nz.TARDIS.enumeration.RecipeItem;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public class TARDISRecipeTabComplete
extends TARDISCompleter
implements TabCompleter {
    public static final Set<String> ROOT_SUBS = new HashSet<String>();
    public static final List<String> TARDIS_TYPES = ImmutableList.of((Object)"ancient", (Object)"ars", (Object)"bigger", (Object)"bone", (Object)"budget", (Object)"cave", (Object)"copper", (Object)"coral", (Object)"cursed", (Object)"custom", (Object)"delta", (Object)"deluxe", (Object[])new String[]{"diner", "division", "eighth", "eleventh", "ender", "factory", "fifteenth", "fugitive", "hell_bent", "hospital", "master", "mechanical", "original", "plank", "pyramid", "redstone", "rotor", "rustic", "sidrat", "steampunk", "thirteenth", "tom", "twelfth", "war", "weathered", "wood", "legacy_bigger", "legacy_deluxe", "legacy_eleventh", "legacy_redstone"});

    public TARDISRecipeTabComplete() {
        ROOT_SUBS.add("seed");
        ROOT_SUBS.add("tardis");
        for (RecipeItem recipeItem : RecipeItem.values()) {
            if (recipeItem.getCategory() == RecipeCategory.UNCRAFTABLE || recipeItem.getCategory() == RecipeCategory.UNUSED || recipeItem.getCategory() == RecipeCategory.CHEMISTRY) continue;
            ROOT_SUBS.add(recipeItem.toTabCompletionString());
        }
        for (String d : TARDIS.plugin.getCustomDoorsConfig().getKeys(false)) {
            ROOT_SUBS.add("door-" + d.toLowerCase(Locale.ROOT));
        }
        for (String r : TARDIS.plugin.getCustomRotorsConfig().getKeys(false)) {
            ROOT_SUBS.add("time-rotor-" + r.toLowerCase(Locale.ROOT));
        }
        for (String c : TARDIS.plugin.getCustomConsolesConfig().getConfigurationSection("consoles").getKeys(false)) {
            ROOT_SUBS.add("console-" + c.toLowerCase(Locale.ROOT));
        }
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        String sub;
        String lastArg = args[args.length - 1];
        if (args.length == 1) {
            return this.partial(args[0], ROOT_SUBS);
        }
        if (args.length == 2 && ((sub = args[0]).equals("tardis") || sub.equals("seed"))) {
            return this.partial(lastArg, TARDIS_TYPES);
        }
        return ImmutableList.of();
    }
}

