/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.enumeration.RecipeCategory;
import me.eccentric_nz.TARDIS.enumeration.RecipeItem;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.messaging.TARDISRecipeLister;
import me.eccentric_nz.TARDIS.recipes.TARDISRecipeCategoryInventory;
import me.eccentric_nz.TARDIS.recipes.TARDISShowSeedRecipeInventory;
import me.eccentric_nz.TARDIS.recipes.TARDISShowShapedRecipeInventory;
import me.eccentric_nz.TARDIS.recipes.TARDISShowShapelessRecipeInventory;
import me.eccentric_nz.TARDIS.utility.TARDISStringUtils;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;

public class TARDISRecipeCommands
implements CommandExecutor {
    private final TARDIS plugin;
    private final HashMap<String, String> recipeItems = new HashMap();
    private final HashMap<String, Material> t = new HashMap();
    private final Set<String> CHEM_SUBS = new HashSet<String>();
    private final List<String> CHEM_BLOCKS = List.of("atomic-elements", "chemical-compounds", "lab-table", "product-crafting", "material-reducer", "element-constructor");

    public TARDISRecipeCommands(TARDIS plugin) {
        this.plugin = plugin;
        this.recipeItems.put("seed", "");
        this.recipeItems.put("tardis", "");
        for (Object recipeItem : RecipeItem.values()) {
            if (recipeItem.getCategory() == RecipeCategory.UNCRAFTABLE || recipeItem.getCategory() == RecipeCategory.UNUSED) continue;
            this.recipeItems.put(recipeItem.toTabCompletionString(), recipeItem.toRecipeString());
        }
        for (String r : TARDIS.plugin.getCustomRotorsConfig().getKeys(false)) {
            this.recipeItems.put("time-rotor-" + r.toLowerCase(Locale.ROOT), "Time Rotor " + TARDISStringUtils.capitalise(r));
        }
        for (String d : TARDIS.plugin.getCustomDoorsConfig().getKeys(false)) {
            this.recipeItems.put("door-" + d.toLowerCase(Locale.ROOT), "Door " + TARDISStringUtils.capitalise(d));
        }
        for (String c : TARDIS.plugin.getCustomConsolesConfig().getConfigurationSection("consoles").getKeys(false)) {
            this.recipeItems.put("console-" + c.toLowerCase(Locale.ROOT), TARDISStringUtils.capitalise(c) + " Console");
        }
        if (!plugin.getConfig().getBoolean("modules.vortex_manipulator")) {
            this.recipeItems.remove("vortex-manipulator");
        }
        if (!plugin.getConfig().getBoolean("modules.regeneration")) {
            this.recipeItems.remove("elixir-of-life");
        }
        if (!plugin.getConfig().getBoolean("modules.sonic_blaster")) {
            this.recipeItems.remove("sonic-blaster");
            this.recipeItems.remove("blaster-battery");
            this.recipeItems.remove("landing-pad");
        }
        if (!plugin.getConfig().getBoolean("modules.weeping_angels")) {
            this.recipeItems.remove("judoon-ammunition");
            this.recipeItems.remove("k9");
        }
        this.t.put("ANCIENT", Material.SCULK);
        this.t.put("ARS", Material.QUARTZ_BLOCK);
        this.t.put("BIGGER", Material.GOLD_BLOCK);
        this.t.put("BONE", Material.WAXED_OXIDIZED_CUT_COPPER);
        this.t.put("BUDGET", Material.IRON_BLOCK);
        this.t.put("CAVE", Material.DRIPSTONE_BLOCK);
        this.t.put("COPPER", Material.WARPED_PLANKS);
        this.t.put("CORAL", Material.NETHER_WART_BLOCK);
        this.t.put("CURSED", Material.BLACK_CONCRETE);
        this.t.put("DELTA", Material.CRYING_OBSIDIAN);
        this.t.put("DELUXE", Material.DIAMOND_BLOCK);
        this.t.put("DINER", Material.STRIPPED_CRIMSON_HYPHAE);
        this.t.put("DIVISION", Material.PINK_GLAZED_TERRACOTTA);
        this.t.put("EIGHTH", Material.CHISELED_STONE_BRICKS);
        this.t.put("ELEVENTH", Material.EMERALD_BLOCK);
        this.t.put("ENDER", Material.PURPUR_BLOCK);
        this.t.put("FACTORY", Material.YELLOW_CONCRETE_POWDER);
        this.t.put("FIFTEENTH", Material.OCHRE_FROGLIGHT);
        this.t.put("FUGITIVE", Material.POLISHED_DEEPSLATE);
        this.t.put("HELL_BENT", Material.WHITE_GLAZED_TERRACOTTA);
        this.t.put("HOSPITAL", Material.WHITE_CONCRETE);
        this.t.put("MASTER", Material.NETHER_BRICKS);
        this.t.put("MECHANICAL", Material.POLISHED_ANDESITE);
        this.t.put("ORIGINAL", Material.PACKED_MUD);
        this.t.put("PLANK", Material.BOOKSHELF);
        this.t.put("PYRAMID", Material.SANDSTONE_STAIRS);
        this.t.put("REDSTONE", Material.REDSTONE_BLOCK);
        this.t.put("ROTOR", Material.HONEYCOMB_BLOCK);
        this.t.put("RUSTIC", Material.COPPER_BULB);
        this.t.put("SIDRAT", Material.GREEN_CONCRETE);
        this.t.put("STEAMPUNK", Material.COAL_BLOCK);
        this.t.put("THIRTEENTH", Material.ORANGE_CONCRETE);
        this.t.put("TOM", Material.LAPIS_BLOCK);
        this.t.put("TWELFTH", Material.PRISMARINE);
        this.t.put("WAR", Material.WHITE_TERRACOTTA);
        this.t.put("WEATHERED", Material.WEATHERED_COPPER);
        this.t.put("LEGACY_BIGGER", Material.ORANGE_GLAZED_TERRACOTTA);
        this.t.put("LEGACY_DELUXE", Material.LIME_GLAZED_TERRACOTTA);
        this.t.put("LEGACY_ELEVENTH", Material.CYAN_GLAZED_TERRACOTTA);
        this.t.put("LEGACY_REDSTONE", Material.RED_GLAZED_TERRACOTTA);
        plugin.getCustomDesktopsConfig().getKeys(false).forEach(console -> {
            if (plugin.getCustomDesktopsConfig().getBoolean(console + ".enabled")) {
                Material cmat = Material.valueOf((String)plugin.getCustomDesktopsConfig().getString(console + ".seed"));
                this.t.put(console.toUpperCase(Locale.ROOT), cmat);
            }
        });
        for (Object recipeItem : RecipeItem.values()) {
            if (recipeItem.getCategory() != RecipeCategory.CHEMISTRY) continue;
            this.CHEM_SUBS.add(recipeItem.toTabCompletionString());
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("tardisrecipe")) {
            if (!TARDISPermission.hasPermission(sender, "tardis.help")) {
                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "NO_PERMS");
                return true;
            }
            Player player = null;
            if (sender instanceof Player) {
                player = (Player)sender;
            }
            if (player == null) {
                if (args.length == 0) {
                    new TARDISRecipeLister(this.plugin, sender).list();
                } else {
                    this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "CMD_PLAYER");
                }
                return true;
            }
            if (args.length == 0) {
                player.openInventory(new TARDISRecipeCategoryInventory(this.plugin).getInventory());
                return true;
            }
            String which = args[0].toLowerCase(Locale.ROOT);
            if (this.CHEM_SUBS.contains(which)) {
                if (this.CHEM_BLOCKS.contains(which)) {
                    String command = which.split("-")[0];
                    this.plugin.getMessenger().sendColouredCommand((CommandSender)player, "USE_FORMULA", "/tchemistry recipe " + command, this.plugin);
                } else {
                    String command = TARDISStringUtils.chemistryCase(which);
                    this.plugin.getMessenger().sendColouredCommand((CommandSender)player, "USE_FORMULA", "/tchemistry formula " + command, this.plugin);
                }
                return true;
            }
            if (!this.recipeItems.containsKey(which)) {
                if (args[0].equalsIgnoreCase("list_more")) {
                    new TARDISRecipeLister(this.plugin, sender).listMore();
                } else {
                    new TARDISRecipeLister(this.plugin, sender).list();
                }
                return true;
            }
            if ((args[0].equalsIgnoreCase("seed") || args[0].equalsIgnoreCase("tardis")) && args.length < 2) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TOO_FEW_ARGS");
                return true;
            }
            if ((args[0].equalsIgnoreCase("seed") || args[0].equalsIgnoreCase("tardis")) && args.length == 2) {
                if (!this.t.containsKey(args[1].toUpperCase(Locale.ROOT))) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ARG_NOT_VALID");
                    return true;
                }
                this.showTARDISRecipe(player, args[1].toUpperCase(Locale.ROOT));
                return true;
            }
            switch (which) {
                case "bowl-of-custard": 
                case "jelly-baby": 
                case "biome-storage-disk": 
                case "player-storage-disk": 
                case "preset-storage-disk": 
                case "save-storage-disk": 
                case "schematic-wand": 
                case "admin-upgrade": 
                case "bio-scanner-upgrade": 
                case "redstone-upgrade": 
                case "diamond-upgrade": 
                case "emerald-upgrade": 
                case "painter-upgrade": 
                case "ignite-upgrade": 
                case "pickup-arrows-upgrade": 
                case "knockback-upgrade": 
                case "brush-upgrade": 
                case "judoon-ammunition": {
                    this.showShapelessRecipe(player, this.recipeItems.get(which));
                    return true;
                }
            }
            this.showShapedRecipe(player, this.recipeItems.get(which));
            return true;
        }
        return false;
    }

    private void showShapedRecipe(Player player, String str) {
        ShapedRecipe recipe = this.plugin.getFigura().getShapedRecipes().get(str);
        if (recipe == null) {
            this.plugin.debug(str);
        } else {
            player.discoverRecipe(recipe.getKey());
            player.closeInventory();
            this.plugin.getTrackerKeeper().getRecipeViewers().add(player.getUniqueId());
            player.openInventory(new TARDISShowShapedRecipeInventory(this.plugin, recipe, str).getInventory());
        }
    }

    private void showShapelessRecipe(Player player, String str) {
        ShapelessRecipe recipe = this.plugin.getIncomposita().getShapelessRecipes().get(str);
        player.discoverRecipe(recipe.getKey());
        player.closeInventory();
        this.plugin.getTrackerKeeper().getRecipeViewers().add(player.getUniqueId());
        player.openInventory(new TARDISShowShapelessRecipeInventory(this.plugin, recipe, str).getInventory());
    }

    private void showTARDISRecipe(Player player, String type) {
        player.closeInventory();
        this.plugin.getTrackerKeeper().getRecipeViewers().add(player.getUniqueId());
        player.openInventory(new TARDISShowSeedRecipeInventory(this.plugin, type, this.t.get(type)).getInventory());
    }
}

