/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.chameleon;

import java.util.EnumMap;
import me.eccentric_nz.TARDIS.chameleon.TARDISChameleonPreset;
import me.eccentric_nz.TARDIS.chameleon.utils.ChameleonColumn;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;

public class TARDISPreset {
    private final EnumMap<COMPASS, ChameleonColumn> blueprint = new EnumMap(COMPASS.class);
    private final EnumMap<COMPASS, ChameleonColumn> stained = new EnumMap(COMPASS.class);
    private final EnumMap<COMPASS, ChameleonColumn> glass = new EnumMap(COMPASS.class);
    private String[][] blueprintData;
    private String[][] stainedData;
    private String[][] glassData;

    public void makePresets() {
        for (COMPASS d : COMPASS.values()) {
            this.blueprint.put(d, TARDISChameleonPreset.buildTARDISChameleonColumn(d, this.blueprintData));
            this.stained.put(d, TARDISChameleonPreset.buildTARDISChameleonColumn(d, this.stainedData));
            this.glass.put(d, TARDISChameleonPreset.buildTARDISChameleonColumn(d, this.glassData));
        }
    }

    public EnumMap<COMPASS, ChameleonColumn> getBlueprint() {
        return this.blueprint;
    }

    public EnumMap<COMPASS, ChameleonColumn> getStained() {
        return this.stained;
    }

    public EnumMap<COMPASS, ChameleonColumn> getGlass() {
        return this.glass;
    }

    public void setBlueprintData(String[][] blueprintData) {
        this.blueprintData = blueprintData;
    }

    public void setStainedData(String[][] stainedData) {
        this.stainedData = stainedData;
    }

    public void setGlassData(String[][] glassData) {
        this.glassData = glassData;
    }
}

