/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.camera;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.camera.CameraLocation;
import me.eccentric_nz.TARDIS.camera.CameraTracker;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;

public class CameraPersister {
    private final TARDIS plugin;
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final String prefix;
    private PreparedStatement ps = null;
    private ResultSet rs = null;
    private int count = 0;

    public CameraPersister(TARDIS plugin) {
        this.plugin = plugin;
        this.prefix = this.plugin.getPrefix();
    }

    public void save() {
        try {
            this.ps = this.connection.prepareStatement("INSERT INTO " + this.prefix + "camera (uuid, location) VALUES (?, ?)");
            for (Map.Entry<UUID, Location> entry : this.plugin.getTrackerKeeper().getJunkRelog().entrySet()) {
                this.ps.setString(1, entry.getKey().toString());
                this.ps.setString(2, entry.getValue().toString());
                this.count += this.ps.executeUpdate();
            }
            for (Map.Entry<UUID, Object> entry : CameraTracker.SPECTATING.entrySet()) {
                this.ps.setString(1, entry.getKey().toString());
                this.ps.setString(2, ((CameraLocation)entry.getValue()).location().toString());
                this.count += this.ps.executeUpdate();
            }
            if (this.count > 0) {
                this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Saved " + this.count + " camera/junk players.");
            }
        }
        catch (SQLException ex) {
            this.plugin.debug("Insert error for camera table: " + ex.getMessage());
        }
        finally {
            try {
                if (this.ps != null) {
                    this.ps.close();
                }
                if (this.rs != null) {
                    this.rs.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.debug("Error closing camera statement: " + ex.getMessage());
            }
        }
    }

    public void load() {
        try {
            this.ps = this.connection.prepareStatement("SELECT * FROM " + this.prefix + "camera");
            this.rs = this.ps.executeQuery();
            while (this.rs.next()) {
                UUID uuid = UUID.fromString(this.rs.getString("uuid"));
                Location location = TARDISStaticLocationGetters.getLocationFromBukkitString(this.rs.getString("location"));
                this.plugin.getTrackerKeeper().getJunkRelog().put(uuid, location);
                ++this.count;
            }
            if (this.count > 0) {
                this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Loaded " + this.count + " camera/junk players.");
            }
            this.ps = this.connection.prepareStatement("DELETE FROM " + this.prefix + "camera");
            this.ps.executeUpdate();
        }
        catch (SQLException ex) {
            this.plugin.debug("ResultSet error for camera table: " + ex.getMessage());
        }
        finally {
            try {
                if (this.ps != null) {
                    this.ps.close();
                }
                if (this.rs != null) {
                    this.rs.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.debug("Error closing camera statement or resultset: " + ex.getMessage());
            }
        }
    }
}

