/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.builders.interior;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.builders.interior.TARDISInteriorPostioning;
import me.eccentric_nz.TARDIS.builders.interior.TIPSData;
import me.eccentric_nz.TARDIS.builders.utility.FractalFence;
import me.eccentric_nz.TARDIS.console.ConsoleBuilder;
import me.eccentric_nz.TARDIS.customblocks.TARDISBlockDisplayItem;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItemUtils;
import me.eccentric_nz.TARDIS.enumeration.Schematic;
import me.eccentric_nz.TARDIS.schematic.SchematicGZip;
import me.eccentric_nz.TARDIS.schematic.setters.ArmourStandSetter;
import me.eccentric_nz.TARDIS.schematic.setters.BannerSetter;
import me.eccentric_nz.TARDIS.schematic.setters.HeadSetter;
import me.eccentric_nz.TARDIS.schematic.setters.ItemDisplaySetter;
import me.eccentric_nz.TARDIS.schematic.setters.ItemFrameSetter;
import me.eccentric_nz.TARDIS.schematic.setters.MannequinSetter;
import me.eccentric_nz.TARDIS.schematic.setters.PaintingSetter;
import me.eccentric_nz.TARDIS.schematic.setters.PotSetter;
import me.eccentric_nz.TARDIS.schematic.setters.SIDRATFenceSetter;
import me.eccentric_nz.TARDIS.schematic.setters.ShelfSetter;
import me.eccentric_nz.TARDIS.schematic.setters.SignSetter;
import me.eccentric_nz.TARDIS.utility.TARDISBannerData;
import me.eccentric_nz.TARDIS.utility.TARDISBlockSetters;
import me.eccentric_nz.TARDIS.utility.TARDISStaticUtils;
import org.bukkit.Chunk;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.FaceAttachable;
import org.bukkit.block.data.Levelled;
import org.bukkit.block.data.type.Switch;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.plugin.Plugin;

public class PreviewBuildRunnable
implements Runnable {
    private final TARDIS plugin;
    private final Schematic schm;
    private final World world;
    private final int tips;
    private final HashMap<Block, BlockData> postBedBlocks = new HashMap();
    private final HashMap<Block, BlockData> postCarpetBlocks = new HashMap();
    private final HashMap<Block, BlockData> postDoorBlocks = new HashMap();
    private final HashMap<Block, BlockData> postDripstoneBlocks = new HashMap();
    private final HashMap<Block, BlockData> postLanternBlocks = new HashMap();
    private final HashMap<Block, BlockData> postLeverBlocks = new HashMap();
    private final HashMap<Block, BlockData> postLichenBlocks = new HashMap();
    private final HashMap<Block, BlockData> postPistonBaseBlocks = new HashMap();
    private final HashMap<Block, BlockData> postPistonExtensionBlocks = new HashMap();
    private final HashMap<Block, BlockData> postRedstoneTorchBlocks = new HashMap();
    private final HashMap<Block, BlockData> postRepeaterBlocks = new HashMap();
    private final HashMap<Block, BlockData> postSculkVeinBlocks = new HashMap();
    private final HashMap<Block, BlockData> postStickyPistonBaseBlocks = new HashMap();
    private final HashMap<Block, BlockData> postTorchBlocks = new HashMap();
    private final HashMap<Block, BlockData> sidratFenceBlocks = new HashMap();
    private final HashMap<Block, JsonObject> postSignBlocks = new HashMap();
    private final List<Block> fractalBlocks = new ArrayList<Block>();
    private final List<Block> iceBlocks = new ArrayList<Block>();
    private final List<Block> postLightBlocks = new ArrayList<Block>();
    private final HashMap<Block, TARDISBannerData> postBannerBlocks = new HashMap();
    private Block postBedrock = null;
    private int task;
    private int level = 0;
    private int row = 0;
    private int startx;
    private int starty;
    private int startz;
    private int resetx;
    private int resetz;
    private int h;
    private int w;
    private int d;
    private int j = 2;
    private JsonArray arr;
    private JsonObject obj;
    private Location location;
    private boolean running = false;
    private Location ender = null;
    private int counter = 0;
    private double div = 1.0;

    public PreviewBuildRunnable(TARDIS plugin, Schematic schm, World world) {
        this.plugin = plugin;
        this.schm = schm;
        this.world = world;
        this.tips = schm.getPreview();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run() {
        if (!this.running) {
            this.starty = this.schm.getStartY();
            this.obj = SchematicGZip.getObject(this.plugin, "consoles", this.schm.getPermission(), this.schm.isCustom());
            if (this.obj != null) {
                JsonObject dimensions = this.obj.get("dimensions").getAsJsonObject();
                this.h = dimensions.get("height").getAsInt() - 1;
                this.w = dimensions.get("width").getAsInt();
                this.d = dimensions.get("length").getAsInt() - 1;
                this.div = ((double)this.h + 1.0) * (double)this.w * ((double)this.d + 1.0);
                TARDISInteriorPostioning tARDISInteriorPostioning = new TARDISInteriorPostioning(this.plugin);
                TIPSData pos = tARDISInteriorPostioning.getTIPSData(this.tips);
                this.startx = pos.getCentreX();
                this.resetx = pos.getCentreX();
                this.startz = pos.getCentreZ();
                this.resetz = pos.getCentreZ();
                Location cl = new Location(this.world, (double)this.startx, (double)this.starty, (double)this.startz);
                Chunk c = this.world.getChunkAt(cl);
                while (!c.isLoaded()) {
                    c.load(true);
                }
                this.location = new Location(this.world, (double)this.startx, (double)this.starty, (double)this.startz);
                this.arr = this.obj.get("input").getAsJsonArray();
                this.running = true;
            }
        }
        if (this.level == this.h && this.row == this.w - 1) {
            this.postBedBlocks.forEach(Block::setBlockData);
            this.postDoorBlocks.forEach(Block::setBlockData);
            this.postRedstoneTorchBlocks.forEach(Block::setBlockData);
            this.postTorchBlocks.forEach(Block::setBlockData);
            this.postLanternBlocks.forEach(Block::setBlockData);
            this.postRepeaterBlocks.forEach(Block::setBlockData);
            this.postStickyPistonBaseBlocks.forEach(Block::setBlockData);
            this.postPistonBaseBlocks.forEach(Block::setBlockData);
            this.postPistonExtensionBlocks.forEach(Block::setBlockData);
            this.postLeverBlocks.forEach(Block::setBlockData);
            this.postDripstoneBlocks.forEach(Block::setBlockData);
            this.postLichenBlocks.forEach(Block::setBlockData);
            this.postSculkVeinBlocks.forEach(Block::setBlockData);
            SignSetter.setSigns(this.postSignBlocks, this.plugin, -1);
            for (Map.Entry entry : this.postCarpetBlocks.entrySet()) {
                Block pcb = (Block)entry.getKey();
                pcb.setBlockData((BlockData)entry.getValue());
            }
            if (this.postBedrock != null) {
                this.postBedrock.setBlockData(TARDISConstants.POWER);
            }
            this.postLightBlocks.forEach(block -> {
                if (block.getType().isAir()) {
                    Levelled levelled = TARDISConstants.LIGHT;
                    levelled.setLevel(15);
                    block.setBlockData((BlockData)levelled);
                }
            });
            if (this.schm.getPermission().equals("cave")) {
                this.iceBlocks.forEach(ice -> ice.setBlockData(TARDISConstants.WATER));
                this.iceBlocks.clear();
            }
            for (int f = 0; f < this.fractalBlocks.size(); ++f) {
                FractalFence.grow(this.fractalBlocks.get(f), f);
            }
            BannerSetter.setBanners(this.postBannerBlocks);
            SIDRATFenceSetter.update(this.sidratFenceBlocks);
            if (this.ender != null) {
                Entity ender_crystal = this.world.spawnEntity(this.ender, EntityType.END_CRYSTAL);
                ((EnderCrystal)ender_crystal).setShowingBottom(false);
            }
            if (this.obj.has("mannequins")) {
                JsonArray mannequins = this.obj.get("mannequins").getAsJsonArray();
                MannequinSetter.setMannequins(mannequins, this.world, this.resetx, this.starty, this.resetz);
            }
            if (this.obj.has("armour_stands")) {
                JsonArray stands = this.obj.get("armour_stands").getAsJsonArray();
                ArmourStandSetter.setStands(stands, this.world, this.resetx, this.starty, this.resetz);
            }
            if (this.obj.has("paintings")) {
                JsonArray paintings = (JsonArray)this.obj.get("paintings");
                PaintingSetter.setArt(paintings, this.world, this.resetx, this.starty, this.resetz);
            }
            if (this.obj.has("item_frames")) {
                JsonArray frames = this.obj.get("item_frames").getAsJsonArray();
                ItemFrameSetter.curate(frames, this.location, -1);
            }
            if (this.obj.has("item_displays")) {
                void var2_13;
                JsonArray displays = this.obj.get("item_displays").getAsJsonArray();
                boolean bl = false;
                while (var2_13 < displays.size()) {
                    ItemDisplaySetter.fakeBlock(displays.get((int)var2_13).getAsJsonObject(), this.location, this.tips);
                    ++var2_13;
                }
            }
            this.plugin.getServer().getScheduler().cancelTask(this.task);
            this.task = -1;
        }
        JsonArray floor = this.arr.get(this.level).getAsJsonArray();
        JsonArray jsonArray = (JsonArray)floor.get(this.row);
        for (int col = 0; col <= this.d; ++col) {
            Bisected bisected;
            ++this.counter;
            JsonObject c = jsonArray.get(col).getAsJsonObject();
            int x = this.startx + this.row;
            int y = this.starty + this.level;
            int z = this.startz + col;
            BlockData data = this.plugin.getServer().createBlockData(c.get("data").getAsString());
            Material type = data.getMaterial();
            if (type.equals((Object)Material.LIGHT_GRAY_CONCRETE) && (this.schm.getPermission().equals("bone") || this.schm.getPermission().equals("rustic") || this.schm.getPermission().equals("diner") || this.schm.getPermission().equals("hell_bent"))) {
                Block block2 = new Location(this.world, (double)x, (double)y, (double)z).getBlock();
                String ct = switch (this.schm.getPermission()) {
                    case "bone" -> "console_light_gray";
                    case "rustic" -> "console_rustic";
                    default -> "console_white";
                };
                new ConsoleBuilder(this.plugin).create(block2, ct, -1, UUID.randomUUID().toString());
            }
            if (type.equals((Object)Material.NOTE_BLOCK)) {
                data = TARDISConstants.BARRIER;
                TARDISDisplayItemUtils.set(TARDISBlockDisplayItem.DISK_STORAGE, this.world, x, y, z);
            }
            if (type.equals((Object)Material.ORANGE_WOOL)) {
                data = TARDISConstants.BARRIER;
                TARDISDisplayItemUtils.set(TARDISBlockDisplayItem.HEXAGON, this.world, x, y, z);
            }
            if (type.equals((Object)Material.BLUE_WOOL)) {
                data = TARDISConstants.BARRIER;
                TARDISDisplayItemUtils.set(TARDISBlockDisplayItem.BLUE_BOX, this.world, x, y, z);
            }
            if ((type.equals((Object)Material.WARPED_FENCE) || type.equals((Object)Material.CRIMSON_FENCE)) && this.schm.getPermission().equals("delta")) {
                this.fractalBlocks.add(this.world.getBlockAt(x, y, z));
            }
            if (this.level == 0 && type.equals((Object)Material.PINK_STAINED_GLASS) && this.schm.getPermission().equals("division")) {
                this.postLightBlocks.add(this.world.getBlockAt(x, y - 1, z));
            }
            if (type.equals((Object)Material.DEEPSLATE_REDSTONE_ORE) && (this.schm.getPermission().equals("division") || this.schm.getPermission().equals("hospital"))) {
                BlockData blockData = data = this.schm.getPermission().equals("division") ? Material.GRAY_CONCRETE.createBlockData() : Material.LIGHT_GRAY_CONCRETE.createBlockData();
            }
            if (type.equals((Object)Material.WHITE_STAINED_GLASS) && (this.schm.getPermission().equals("war") || this.schm.getPermission().equals("diner") || this.schm.getPermission().equals("hell_bent"))) {
                data = TARDISConstants.BARRIER;
                TARDISDisplayItemUtils.set(TARDISBlockDisplayItem.ROUNDEL, this.world, x, y, z);
            }
            if (type.equals((Object)Material.WHITE_TERRACOTTA) && (this.schm.getPermission().equals("war") || this.schm.getPermission().equals("diner") || this.schm.getPermission().equals("hell_bent"))) {
                data = TARDISConstants.BARRIER;
                TARDISDisplayItemUtils.set(TARDISBlockDisplayItem.ROUNDEL_OFFSET, this.world, x, y, z);
            }
            if (type.equals((Object)Material.IRON_DOOR) && (bisected = (Bisected)data).getHalf().equals((Object)Bisected.Half.BOTTOM)) {
                HashMap<String, Object> set = new HashMap<String, Object>();
                set.put("tardis_id", this.tips);
                set.put("name", this.schm.getPermission());
                set.put("world", this.world.getName());
                set.put("x", (double)x + 0.5);
                set.put("y", y);
                set.put("z", z + 1);
                this.plugin.getQueryFactory().doInsert("transmats", set);
            }
            if (type.equals((Object)Material.CAKE) && this.schm.getPermission().equals("sidrat")) {
                Object blockData = Material.LEVER.createBlockData();
                Switch lever = (Switch)blockData;
                lever.setAttachedFace(FaceAttachable.AttachedFace.WALL);
                lever.setFacing(BlockFace.WEST);
                data = lever;
            }
            if (!(!type.equals((Object)Material.JUKEBOX) || this.schm.getPermission().equals("eighth") && this.world.getBlockAt(x, y, z).getRelative(BlockFace.DOWN).getType() == Material.ANDESITE || this.schm.getPermission().equals("diner") && this.world.getBlockAt(x, y, z).getRelative(BlockFace.DOWN).getType() == Material.WHITE_CONCRETE)) {
                data = TARDISConstants.BARRIER;
                TARDISDisplayItemUtils.set(TARDISBlockDisplayItem.ADVANCED_CONSOLE, this.world, x, y, z);
            }
            if ((type.equals((Object)Material.COMMAND_BLOCK) || (this.schm.getPermission().equals("bigger") || this.schm.getPermission().equals("coral") || this.schm.getPermission().equals("deluxe") || this.schm.getPermission().equals("twelfth")) && type.equals((Object)Material.BEACON)) && type.equals((Object)Material.COMMAND_BLOCK)) {
                switch (this.schm.getPermission()) {
                    case "ender": {
                        BlockData blockData = Material.END_STONE_BRICKS.createBlockData();
                        break;
                    }
                    case "delta": 
                    case "cursed": {
                        BlockData blockData = Material.BLACKSTONE.createBlockData();
                        break;
                    }
                    case "ancient": 
                    case "bone": 
                    case "fugitive": {
                        BlockData blockData = Material.GRAY_WOOL.createBlockData();
                        break;
                    }
                    case "hospital": {
                        BlockData blockData = Material.LIGHT_GRAY_WOOL.createBlockData();
                        break;
                    }
                    case "sidrat": {
                        BlockData blockData = Material.RED_CONCRETE.createBlockData();
                        break;
                    }
                    default: {
                        BlockData blockData = data = Material.STONE_BRICKS.createBlockData();
                    }
                }
            }
            if (type.equals((Object)Material.BEACON) && this.schm.getPermission().equals("ender")) {
                this.ender = this.world.getBlockAt(x, y, z).getLocation().add(0.5, 4.0, 0.5);
            }
            if (type.equals((Object)Material.PALE_OAK_FENCE) && this.schm.getPermission().equals("sidrat")) {
                this.sidratFenceBlocks.put(this.world.getBlockAt(x, y, z), data);
            } else if (type.equals((Object)Material.ICE) && this.schm.getPermission().equals("cave")) {
                this.iceBlocks.add(this.world.getBlockAt(x, y, z));
            } else if (Tag.BEDS.isTagged((Keyed)type)) {
                this.postBedBlocks.put(this.world.getBlockAt(x, y, z), data);
            } else if (type.equals((Object)Material.IRON_DOOR)) {
                this.postDoorBlocks.put(this.world.getBlockAt(x, y, z), data);
            } else if (type.equals((Object)Material.REDSTONE_TORCH) || type.equals((Object)Material.REDSTONE_WALL_TORCH)) {
                this.postRedstoneTorchBlocks.put(this.world.getBlockAt(x, y, z), data);
            } else if (type.equals((Object)Material.TORCH) || type.equals((Object)Material.WALL_TORCH) || type.equals((Object)Material.SOUL_TORCH) || type.equals((Object)Material.SOUL_WALL_TORCH)) {
                this.postTorchBlocks.put(this.world.getBlockAt(x, y, z), data);
            } else if (type.equals((Object)Material.STICKY_PISTON)) {
                this.postStickyPistonBaseBlocks.put(this.world.getBlockAt(x, y, z), data);
            } else if (type.equals((Object)Material.PISTON)) {
                this.postPistonBaseBlocks.put(this.world.getBlockAt(x, y, z), data);
            } else if (type.equals((Object)Material.PISTON_HEAD)) {
                this.postPistonExtensionBlocks.put(this.world.getBlockAt(x, y, z), data);
            } else if (type.equals((Object)Material.LEVER)) {
                this.postLeverBlocks.put(this.world.getBlockAt(x, y, z), data);
            } else if (Tag.ALL_SIGNS.isTagged((Keyed)type)) {
                this.postSignBlocks.put(this.world.getBlockAt(x, y, z), c);
            } else if (type.equals((Object)Material.POINTED_DRIPSTONE)) {
                this.postDripstoneBlocks.put(this.world.getBlockAt(x, y, z), data);
            } else if (type.equals((Object)Material.GLOW_LICHEN)) {
                this.postLichenBlocks.put(this.world.getBlockAt(x, y, z), data);
            } else if (type.equals((Object)Material.SCULK_VEIN)) {
                this.postSculkVeinBlocks.put(this.world.getBlockAt(x, y, z), data);
            } else if (type.equals((Object)Material.LANTERN) || type.equals((Object)Material.SOUL_LANTERN)) {
                this.postLanternBlocks.put(this.world.getBlockAt(x, y, z), data);
            } else if (Tag.BANNERS.isTagged((Keyed)type)) {
                JsonObject state;
                JsonObject jsonObject = state = c.has("banner") ? c.get("banner").getAsJsonObject() : null;
                if (state != null) {
                    TARDISBannerData tbd = new TARDISBannerData(data, state);
                    this.postBannerBlocks.put(this.world.getBlockAt(x, y, z), tbd);
                }
            } else if (type.equals((Object)Material.PLAYER_HEAD) || type.equals((Object)Material.PLAYER_WALL_HEAD)) {
                JsonObject head;
                TARDISBlockSetters.setBlock(this.world, x, y, z, data);
                if (c.has("head") && (head = c.get("head").getAsJsonObject()).has("uuid")) {
                    try {
                        UUID uuid = UUID.fromString(head.get("uuid").getAsString());
                        HeadSetter.textureSkull(this.plugin, uuid, head, this.world.getBlockAt(x, y, z));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
            } else if (type.equals((Object)Material.DECORATED_POT)) {
                TARDISBlockSetters.setBlock(this.world, x, y, z, data);
                if (c.has("pot")) {
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> PotSetter.decorate(this.plugin, c.get("pot").getAsJsonObject(), this.world.getBlockAt(x, y, z)), 1L);
                }
            } else if (Tag.WOODEN_SHELVES.isTagged((Keyed)type)) {
                TARDISBlockSetters.setBlock(this.world, x, y, z, data);
                if (c.has("items")) {
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> ShelfSetter.stock(this.world.getBlockAt(x, y, z), c.get("items").getAsJsonArray()), 3L);
                }
            } else if (TARDISStaticUtils.isInfested(type)) {
                TARDISBlockSetters.setBlock(this.world, x, y, z, Material.VOID_AIR);
            } else if (type.equals((Object)Material.MUSHROOM_STEM)) {
                if (this.j < 6) {
                    data = Material.REPEATER.createBlockData();
                    Directional directional = (Directional)data;
                    switch (this.j) {
                        case 2: {
                            directional.setFacing(BlockFace.WEST);
                            this.postRepeaterBlocks.put(this.world.getBlockAt(x, y, z), (BlockData)directional);
                            break;
                        }
                        case 3: {
                            directional.setFacing(BlockFace.NORTH);
                            this.postRepeaterBlocks.put(this.world.getBlockAt(x, y, z), (BlockData)directional);
                            break;
                        }
                        case 4: {
                            directional.setFacing(BlockFace.SOUTH);
                            this.postRepeaterBlocks.put(this.world.getBlockAt(x, y, z), (BlockData)directional);
                            break;
                        }
                        default: {
                            directional.setFacing(BlockFace.EAST);
                            this.postRepeaterBlocks.put(this.world.getBlockAt(x, y, z), (BlockData)directional);
                        }
                    }
                    ++this.j;
                }
            } else if (type.equals((Object)Material.SPONGE)) {
                TARDISBlockSetters.setBlock(this.world, x, y, z, Material.VOID_AIR);
            } else if (type.equals((Object)Material.BEDROCK)) {
                this.postBedrock = this.world.getBlockAt(x, y, z);
            } else if (type.equals((Object)Material.BROWN_MUSHROOM) && this.schm.getPermission().equals("master")) {
                TARDISBlockSetters.setBlock(this.world, x, y, z, Material.VOID_AIR);
                this.plugin.setTardisSpawn(true);
                this.world.spawnEntity(new Location(this.world, (double)x + 0.5, (double)y + 0.25, (double)z + 0.5), EntityType.VILLAGER);
            } else if (type.equals((Object)Material.BLACK_CARPET) && this.schm.getPermission().equals("master")) {
                this.postCarpetBlocks.put(this.world.getBlockAt(x, y, z), data);
            } else {
                TARDISBlockSetters.setBlock(this.world, x, y, z, data);
            }
            if (col == this.d && this.row < this.w) {
                ++this.row;
            }
            if (col != this.d || this.row != this.w || this.level >= this.h) continue;
            this.row = 0;
            ++this.level;
        }
    }

    public void setTask(int task) {
        this.task = task;
    }
}

